// Jean Luc Biellmann - contact@alsatux.com - 20140721 - v0.2

"use strict";

var version = 'v0.2';

Date.prototype.toYYYYMMDD = function () {
	var spacer = arguments.length ? arguments[0] : '';
	var day = _Fmt.two_digits(this.getDate());
	var month = _Fmt.two_digits(this.getMonth() + 1);
	return this.getFullYear() + spacer + month + spacer + day;
}

String.prototype.escapeHTML = function() {
  return this.replace(/&(?!amp;)/g, '&amp;').replace(/<(?!lt;)/g, '&lt;').replace(/>(?!gt;)/g, '&gt;').replace(/"(?!quot;)/g, '&quot;').replace(/'(?!#039;)/g, '&#039;');
}

window.onload = function () {
	_Lang.chg_to(0);
	_MenuGUI.click_today();
	_SettingsGUI.set_wkst(_CalGUI.settings['wkst']);
	_SettingsGUI.set_lang(_Lang.current);
	_Log.info(tr('Thanks to use') + ' Cactus ' + version + ' ! ' + tr('Please report any bug to') + ' contact@alsatux.com !');
	// add default category "None"
	var cat = _CatDB.add();
	_CatDB.upd({
		'seq': cat['seq'],
		'name': tr('None')
	});
	// GUI inits
	_CalGUI.init();
	_CatGUI.init();
	_CatEditorGUI.init();
	_CatManageGUI.init();
	_Colors.init();
	_DialerGUI.init();
	_EventGUI.init();
	_LogGUI.init();
	_MenuGUI.init();
	_MonthGUI.init();
	_RepeatGUI.init();
	_SettingsGUI.init();
	// test file...
	if (typeof testxml != 'undefined') {
		_XML.read(testxml);
		_CatDB.upd_style();
		_MenuGUI.scroll_today();
	} else {
		// Get last backup
		if (_Storage.allowed()) {
			_Log.info(tr('Storage allowed... Searching for the last backup file...'));
			_SD.recall_last_backup();
		} else {
			_Log.warn(tr('Storage not allowed !'));
		}
	}
	// delete input getting focus
	var input_nums = document.querySelectorAll('input[type="number"]');
	for (var i=0;i<input_nums.length;i++) {
		input_nums[i].addEventListener('click', function () {
			this.setAttribute('data-oldvalue', this.value);
			this.value = '';
		});
		input_nums[i].addEventListener('blur', function () {
			if (this.value==null || !this.value.length) {
				this.value = this.getAttribute('data-oldvalue');
			}
		});
	}
}
