// Jean Luc Biellmann - contact@alsatux.com

"use strict";

var _CalGUI = {
	debug: false,
	counter: 0,
	current_year: 2014,
	settings: {
		wkst: 'monday' // internal - no translation - value is monday or sunday
	},
	init: function () {
		document.getElementById('cal').addEventListener("click", _CalGUI.click_on_day);
	},
	goto_year: function (y) {
		_CalGUI.current_year = y;
		document.getElementById('menu_current_year').innerHTML = y;
		var months = tr('January,February,March,April,May,June,July,August,September,October,November,December').split(',');
		var days = tr('S,M,T,W,T,F,S').split(',');
		var d = new Date(y,0,1); // 1st january
		var dn = d.getDay();
		var oldm = -1;
		var cal = '';
		while (d.getFullYear()==y) {
			if (d.getMonth()!=oldm) {
				cal += '<h3 class="month">' + months[d.getMonth()]+ '</h3>';
				oldm = d.getMonth();
			}
			var day = d.getDate();
			var yyyymmdd = d.toYYYYMMDD('-');
			var now = new Date();
			var today = now.toYYYYMMDD('-');
			cal += '<div class="day' + (dn==0 ? ' sunday' : '') + (today==yyyymmdd ? ' today' : '') + '" id="day_' + yyyymmdd + '">' + (day<10 ? '0' : '') + day + ' ' + days[dn] + '</div>';
			// <div class="events"></div>
			dn = ++dn%7;
			d = new Date(d.getFullYear(),d.getMonth(),day + 1);
		}
		var div_cal = document.getElementById('cal');
		div_cal.innerHTML = cal;
		// refresh events
		_CalGUI.refresh_events();
	},
	add: function (event) {
		// future repeat events should be filtered here
		// and should create new events for the current year only
		var repeat_events_start_dates = _RRule.filter(_CalGUI.current_year, event);
		for (var i=0;i<repeat_events_start_dates.length;i++) {
			var single_event = JSON.parse(JSON.stringify(event));
			single_event.start_date = repeat_events_start_dates[i];
			var div_day = document.getElementById('day_' + single_event.start_date);
			if (div_day!=null) {
				var legend;
				var order = _Fmt.two_digits(single_event.start_hour) + _Fmt.two_digits(single_event.start_minute);
				var allday = false;
				var cat = event.cat_seq.length ? _CatDB.db[event.cat_seq] : null;
				var infos = [];
				if (single_event.start_hour==0 && single_event.start_minute==0 && single_event.duration_hour==24 && single_event.duration_minute==0) {
					// force a space to avoid empty cell (cell height will be too small)
					legend = '<span class="allday">-&nbsp;' + single_event.title.escapeHTML() + '&nbsp;-</span>';
					if (cat!=null && cat.seq!='cat_seq_0')
						infos.push('<span class="cat">' + cat.name.escapeHTML() +'</span>');
					allday = true;
				} else {
					legend = _Fmt.two_digits(single_event.start_hour) + ':' + _Fmt.two_digits(single_event.start_minute) + ' ' + single_event.title.escapeHTML();
					infos.push('<span class="duration">' + _Fmt.two_digits(single_event.duration_hour) + ':' +  _Fmt.two_digits(single_event.duration_minute) + '</span>');
					if (cat!=null && cat.seq!='cat_seq_0')
						infos.push('<span class="cat">' + cat.name.escapeHTML() +'</span>');
				}
				if (_CalGUI.debug)
					legend += ' {' + event.rrule.freq + ',' + event.rrule.count + ',' + event.rrule.interval + ',' + event.rrule.until + '}';
				var html = '\
				<div class="event" id="cal_event_' + _CalGUI.counter + '" data-event="' + event.seq + '" data-order="' + order + '">\
					<p>' +  legend + (infos.length ? '<div class="infos">[' + infos.join('/') + ']</div>' : '') +  '</p>\
				</div>';
				div_day.innerHTML += html;
				// change style according to category
				var obj = document.getElementById('cal_event_' + _CalGUI.counter);
				obj.className = obj.className + ' ' + cat.seq;
				_CalGUI.counter++;
				// reorder the events
				var events = div_day.querySelectorAll('div.event[data-order]');
				if (events.length>1) {
					var hash = {};
					var keys = [];
					for (var j=0;j<events.length;j++) {
						var key = events[j].getAttribute('data-order');
						keys.push(key);
						if (hash[key]==undefined)
							hash[key] = [];
						hash[key].push(events[j]);
					}
					keys.sort();
					for (var k=0;k<keys.length;k++) {
						var key = keys[k];
						for (var l=0;l<hash[key].length;l++)
							div_day.appendChild(hash[key][l]);
					}
				}
			}
		}
	},
	del: function (seq) {
		var divs = document.querySelectorAll('div[data-event="'+seq+'"]');
		for (var i=divs.length-1;i>=0;i--) {
			var div = divs[i];
			div.parentNode.removeChild(div);
		}
	},
	click_on_day: function (e) {
		var o = e.target;
		while (o && o.classList && !o.classList.contains('day') && !o.classList.contains('event'))
			o = o.parentNode;
		if (o.nodeName && o.nodeName=='DIV') {
			if (o.classList.contains('day')) {
				// create a new event
				var day = o.id.replace('day_','');
				var new_event = _EventDB.add();
				new_event.start_date = day;
				_EventGUI.show(new_event);
			}
			if (o.classList.contains('event')) {
				// edit existing event
				var seq = o.getAttribute('data-event');
				_EventGUI.show(_EventDB.db[seq]);
			}
		}
	},
	refresh_events: function () {
		for (var seq in _EventDB.db)
			_CalGUI.add(_EventDB.db[seq]);
		_CatDB.upd_style();
	},
	chg_wkst: function (value) {
		if (value.match(/^(monday|sunday)$/)!=null && value!=_CalGUI.settings['wkst']) {
			_CalGUI.settings['wkst'] = value;
			_SettingsGUI.set_wkst(value);
			_CalGUI.goto_year(_CalGUI.current_year);
		}
	},
	chg_lang: function (value) {
		if (_Lang.available.indexOf(value)!=-1 && value!=_Lang.current) {
			var index = _Lang.available.indexOf(value);
			_Lang.chg_to(index);
			_SettingsGUI.set_lang(index);
			_CalGUI.goto_year(_CalGUI.current_year);
		}
	}
};

