// Jean Luc Biellmann - contact@alsatux.com

"use strict";

var _CatEditorGUI = {
	init: function () {
		// opener
		document.getElementById('button_cat_editor_add').addEventListener("click", _CatEditorGUI.add);
		// GUI objects
		document.getElementById('button_cat_editor_delete').addEventListener("click", _CatEditorGUI.del);
		document.getElementById('button_cat_editor_submit').addEventListener("click", _CatEditorGUI.rec);
		document.getElementById('cat_editor_styles').addEventListener("click", _CatEditorGUI.click_style);
		document.getElementById('cat_editor_bg_type_radio').addEventListener("click", _CatEditorGUI.click_bg_type);
		document.getElementById('cat_editor_bg_angle').addEventListener("change", _CatEditorGUI.upd_preview);
		document.getElementById('cat_editor_color').addEventListener("click", _CatEditorGUI.set_color);
		document.getElementById('cat_editor_bg_from').addEventListener("click", _CatEditorGUI.set_color);
		document.getElementById('cat_editor_bg_to').addEventListener("click", _CatEditorGUI.set_color);
	},
	show: function (event) {
		document.getElementById('div_cat_editor').style.display = '';
	},
	hide: function (e) {
		document.getElementById('div_cat_editor').style.display = 'none';
		_CatManageGUI.show();
	},
	add: function (e) {
		_CatEditorGUI.show();
		var cat = _CatDB.add();
		_CatEditorGUI.edit(cat.seq);
	},
	edit: function (seq) {
		if (!(seq in _CatDB.db))
			return _Log.error(tr('Category not found') + ' ! ');
		_CatEditorGUI.show();
		var cat = _CatDB.db[seq];
		document.getElementById('cat_editor_seq').value = seq;
		document.getElementById('cat_editor_name').value = cat.name.escapeHTML();
		document.getElementById('cat_editor_color').innerHTML = cat.color;
		document.getElementById('cat_editor_bg_from').innerHTML = cat.bg_from;
		document.getElementById('cat_editor_bg_to').innerHTML = cat.bg_to;
		document.getElementById('cat_editor_bg_angle').value = cat.bg_angle;
		// bold, italic, underline
		_CatEditorGUI.set_button('italic', cat.styles.indexOf('italic')!=-1);
		_CatEditorGUI.set_button('bold', cat.styles.indexOf('bold')!=-1);
		_CatEditorGUI.set_button('underline', cat.styles.indexOf('underline')!=-1);
		// background type
		_CatEditorGUI.set_bg_type(cat.bg_type);
		// fg after bg...
		_CatEditorGUI.upd_preview();
	},
	set_color: function (e) {
		var o = e.target;
		_Colors.show(o.innerHTML, function (value) {
			o.innerHTML = value;
			_CatEditorGUI.upd_preview();
		});
	},
	set_button: function (id, selected) {
		var o = document.getElementById('cat_editor_' + id);
		if (selected) {
			if (!o.classList.contains('selected'))
				o.classList.add('selected');
		} else {
			if (o.classList.contains('selected'))
				o.classList.remove('selected');
		}
	},
	click_style: function (e) {
		var o = e.target;
		if (o.nodeName && o.nodeName=='SPAN') {
			// flip flop button style
			var cn = o.getAttribute('data-value');
			_CatEditorGUI.set_button(cn, !o.classList.contains('selected'));
			_CatEditorGUI.upd_preview();
		}
	},
	del: function (e) {
		var cat_seq = document.getElementById('cat_editor_seq').value;
		if (cat_seq=='cat_seq_0') {
			alert(tr('Unable to delete default category !'));
		} else {
			if (confirm(tr('Delete this category ?'))) {
				_CatDB.del(cat_seq);
				_EventDB.save();
			}
		}
		_CatEditorGUI.hide();
	},
	rec: function (e) {
		var cat_seq = document.getElementById('cat_editor_seq').value;
		if (cat_seq=='cat_seq_0') {
			alert(tr('Unable to change default category !'));
			_CatEditorGUI.hide();
		} else {
			var styles = [];
			if (document.getElementById('cat_editor_italic').classList.contains('selected'))
				styles.push('italic');
			if (document.getElementById('cat_editor_bold').classList.contains('selected'))
				styles.push('bold');
			if (document.getElementById('cat_editor_underline').classList.contains('selected'))
				styles.push('underline');
			var cat = {
				'seq': document.getElementById('cat_editor_seq').value,
				'name': document.getElementById('cat_editor_name').value,
				'color': document.getElementById('cat_editor_color').innerHTML,
				'bg_type': document.getElementById('cat_editor_bg_type').value,
				'bg_from': document.getElementById('cat_editor_bg_from').innerHTML,
				'bg_to': document.getElementById('cat_editor_bg_to').innerHTML,
				'bg_angle': document.getElementById('cat_editor_bg_angle').value,
				'styles': styles.join(' ')
			}
			try {
				_CatDB.chk(cat);
				_CatDB.upd(cat);
				_CatEditorGUI.hide();
				_EventDB.save();
				// we need to update all objects name
				var objs = document.querySelectorAll('div.event.' + cat_seq + ' span.cat');
				for (var i=0;i<objs.length;i++)
					objs[i].innerHTML = cat.name;
			} catch (err) {
				alert(err);
			}
		}
	},
	upd_preview: function () {
		// update name field
		var f = document.getElementById('cat_editor_name');
		f.style.color = document.getElementById('cat_editor_color').innerHTML;
		f.style.background = _CatGUI.get_css_background({
			'bg_type': document.getElementById('cat_editor_bg_type').value,
			'bg_from': document.getElementById('cat_editor_bg_from').innerHTML,
			'bg_to': document.getElementById('cat_editor_bg_to').innerHTML,
			'bg_angle': document.getElementById('cat_editor_bg_angle').value
		});
		// set styles
		var cstyle = document.querySelectorAll('span.cstyle');
		for (var i=0;i<cstyle.length;i++) {
			var cn = cstyle[i].getAttribute('data-value');
			if (document.getElementById('cat_editor_' + cn).classList.contains('selected')) {
				if (!f.classList.contains(cn))
					f.classList.add(cn);
			} else {
				if (f.classList.contains(cn))
					f.classList.remove(cn);
			}
		}
	},
	set_bg_type: function (value) {
		var ul = document.getElementById('cat_editor_bg_type_radio');
		var lis = ul.querySelectorAll('li');
		// unselect all
		_Fmt.resetClassName(lis);
		// select by value
		for (var i=0;i<lis.length;i++) {
			if (lis[i].getAttribute('data-value').toLowerCase()==value.toLowerCase())
				lis[i].className = 'selected';
		}
		// update colors and angle
		document.getElementById('cat_editor_bg_type').value = value.toLowerCase();
		if (value.toLowerCase()=='transparent') {
			document.getElementById('cat_editor_block_from').style.display = 'none';
			document.getElementById('cat_editor_block_to').style.display = 'none';
			document.getElementById('cat_editor_block_angle').style.display = 'none';
		}
		else if (value.toLowerCase()=='color') {
			document.getElementById('cat_editor_block_from').style.display = '';
			document.getElementById('cat_editor_block_to').style.display = 'none';
			document.getElementById('cat_editor_block_angle').style.display = 'none';
		}
		else { // gradient
			document.getElementById('cat_editor_block_from').style.display = '';
			document.getElementById('cat_editor_block_to').style.display = '';
			document.getElementById('cat_editor_block_angle').style.display = '';
		}
	},
	click_bg_type: function (e) {
		var o = e.target;
		if (o.nodeName && o.nodeName=='LI') {
			_CatEditorGUI.set_bg_type(o.getAttribute('data-value').toLowerCase());
			_CatEditorGUI.upd_preview();
		}
	}
}
