// Jean Luc Biellmann - contact@alsatux.com

"use strict";

var _CatGUI = {
	init: function () {
		// opener
		document.getElementById('button_event_cat').addEventListener("click", _CatGUI.show);
		// GUI objects
		document.getElementById('div_event_cat_radio').addEventListener("click", _CatGUI.click_cat);
	},
	show: function (event) {
		document.getElementById('div_cat').style.display = '';
		document.getElementById('div_event_cat_radio').innerHTML = '';
		var cat_seq =	document.getElementById('event_cat_seq').value;
		var div_event_cat_radio = document.getElementById('div_event_cat_radio');
		for (var seq in _CatDB.db) {
			var cat = _CatDB.db[seq];
			var div = document.createElement('div');
			div.id = seq;
			div.style.color = cat.color;
			div.style.background = _CatGUI.get_css_background(cat);
			div.className = cat.styles;
			if (seq==cat_seq)
				div.classList.add('selected');
			div.innerHTML = cat.name;
			div_event_cat_radio.appendChild(div)
		}
	},
	hide: function (e) {
		document.getElementById('div_cat').style.display = 'none';
		_EventGUI.upd_cat_button();
	},
	click_cat: function (e) {
		var o = e.target;
		if (o.nodeName && o.nodeName=='DIV') {
			var divs = o.parentNode.querySelectorAll('div');
			_Fmt.resetClassName(divs);
			o.classList.add('selected');
			document.getElementById('event_cat_seq').value = o.id;
			_Log.info(tr('Category choosed') + ' : ' + _CatDB.db[o.id].name);
		}
		_CatGUI.hide();
		_CatDB.upd_style();
	},
	get_css_background: function (cat) {
		if (cat.bg_type.toLowerCase()=='transparent')
			return 'transparent';
		if (cat.bg_type.toLowerCase()=='color')
			return cat.bg_from;
		return 'linear-gradient(' + cat.bg_angle +'deg, ' + cat.bg_from + ' 0%, ' + cat.bg_to + ' 100%)';
	}
}
