// Jean Luc Biellmann - contact@alsatux.com

"use strict";

var _CatManageGUI = {
	init: function () {
		// opener
		document.getElementById('button_cat_manage_open').addEventListener("click", _CatManageGUI.show);
		// GUI objects
		document.getElementById('button_cat_manage_close').addEventListener("click", _CatManageGUI.hide);

		document.getElementById('cat_manage_radio').addEventListener("click", _CatManageGUI.click_cat);
	},
	show: function (event) {
		document.getElementById('div_cat_manage').style.display = '';
		document.getElementById('cat_manage_radio').innerHTML = '';
		var cat_manage_radio = document.getElementById('cat_manage_radio');
		for (var seq in _CatDB.db) {
			var cat = _CatDB.db[seq];
			var div = document.createElement('div');
			div.id = seq;
			div.style.color = cat.color;
			div.style.background = _CatGUI.get_css_background(cat);
			div.className = cat.styles;
			div.innerHTML = cat.name;
			cat_manage_radio.appendChild(div);
		}
	},
	hide: function (e) {
		document.getElementById('div_cat_manage').style.display = 'none';
		_CatGUI.show();
	},
	click_cat: function (e) {
		var o = e.target;
		if (o.nodeName && o.nodeName=='DIV') {
			var divs = o.parentNode.querySelectorAll('li');
			_Fmt.resetClassName(divs);
			_Log.info(tr('Editing category') + ' : ' + _CatDB.db[o.id].name);
			_CatEditorGUI.edit(o.id)
		}
	}
}
