// Jean Luc Biellmann - contact@alsatux.com

"use strict";

var _DialerGUI = {
	input_target: null,
	init: function () {
		// show dialer
		document.getElementById('event_start_hour').addEventListener("click", _DialerGUI.show);
		document.getElementById('event_start_minute').addEventListener("click", _DialerGUI.show);
		document.getElementById('event_duration_hour').addEventListener("click", _DialerGUI.show);
		document.getElementById('event_duration_minute').addEventListener("click", _DialerGUI.show);
		// hide dialer
		document.getElementById('div_event_start_hour').addEventListener("click", _DialerGUI.hide);
		document.getElementById('div_event_start_minute').addEventListener("click", _DialerGUI.hide);
		document.getElementById('div_event_duration_hour').addEventListener("click", _DialerGUI.hide);
		document.getElementById('div_event_duration_minute').addEventListener("click", _DialerGUI.hide);
	},
	show: function (e) {
		var o = e.target;
		var div = document.getElementById('div_' + o.id);
		div.style.display = '';
		// search for a text field inside the fix
		if (div.getElementsByTagName('input').length) {
			div.getElementsByTagName('input')[0].value = o.innerHTML;
		}
		// select current li
		var lis = div.querySelectorAll('li');
		for (var i=0;i<lis.length;i++) {
			if (lis[i].innerHTML==o.innerHTML) {
				lis[i].className = 'selected';
				break;
			}
		}
		_DialerGUI.input_target = o;
		e.stopPropagation();
		return false;
	},
	hide: function (e) {
		var o = e.target;
		var close_panel = false;
		var div = document.getElementById('div_' + _DialerGUI.input_target.id);
		if (o.nodeName && o.nodeName=='LI') {
			// user choose a value
			_DialerGUI.input_target.innerHTML = _Fmt.two_digits(o.innerHTML);
			close_panel = true;
		}
		if (o.nodeName && o.nodeName=='BUTTON') {
			// user enter a value then press OK
			var value = parseInt(div.getElementsByTagName('input')[0].value,10) || 0;
			_DialerGUI.input_target.innerHTML = _Fmt.two_digits(value%100);
			close_panel = true;
		}
		// unselect selected li
		_Fmt.resetClassName(div.querySelectorAll('li'));
		if (close_panel) {
			// user press OK or a value
			while (o && o.className.match(/fixed/)==null)
				// search for the parent "card" div
				o = o.parentNode;
			if (o)
				o.style.display = 'none';
		}
		_EventGUI.upd_allday_button();
		e.stopPropagation();
		return false;
	}
};

