// Jean Luc Biellmann - contact@alsatux.com

"use strict";

var _EventGUI = {
	init: function () {
		// all day button
		document.getElementById('button_event_allday').addEventListener("click", _EventGUI.allday);
		// event buttons
		document.getElementById('button_event_submit').addEventListener("click",_EventGUI.add);
		document.getElementById('button_event_delete').addEventListener("click",_EventGUI.del);
	},
	show: function (event) {
		document.getElementById('div_edit_event').style.display = '';
		document.getElementById('event_seq').value = event.seq;
		document.getElementById('event_start_date').value = event.start_date;
		document.getElementById('event_start_hour').innerHTML = _Fmt.two_digits(event.start_hour);
		document.getElementById('event_start_minute').innerHTML = _Fmt.two_digits(event.start_minute);
		document.getElementById('event_duration_hour').innerHTML = _Fmt.two_digits(event.duration_hour);
		document.getElementById('event_duration_minute').innerHTML = _Fmt.two_digits(event.duration_minute);
		document.getElementById('event_title').value = event.title;
		document.getElementById('event_description').value = event.description;
		// rrule
		document.getElementById('event_rrule_freq').innerHTML = event.rrule.freq;
		document.getElementById('event_rrule_count').value = event.rrule.count;
		document.getElementById('event_rrule_interval').value = event.rrule.interval;
		document.getElementById('event_rrule_until').value = event.rrule.until;
		_RepeatGUI.select_freq(event.rrule.freq);
		// cat seq
		document.getElementById('event_cat_seq').value = event.cat_seq;
		// update all buttons
		_EventGUI.upd_repeat_button();
		_EventGUI.upd_allday_button();
		_EventGUI.upd_cat_button();
	},
	hide: function (e) {
		document.getElementById('div_edit_event').style.display = 'none';
	},
	add: function (e) {
		var event = {
			'seq': document.getElementById('event_seq').value,
			'start_date': document.getElementById('event_start_date').value,
			'start_hour': document.getElementById('event_start_hour').innerHTML,
			'start_minute': document.getElementById('event_start_minute').innerHTML,
			'duration_hour': document.getElementById('event_duration_hour').innerHTML,
			'duration_minute': document.getElementById('event_duration_minute').innerHTML,
			'title': document.getElementById('event_title').value,
			'description': document.getElementById('event_description').value,
			'rrule': {
				'freq': document.getElementById('event_rrule_freq').value,
				'until': document.getElementById('event_rrule_until').value,
				'count': document.getElementById('event_rrule_count').value,
				'interval': document.getElementById('event_rrule_interval').value,
			},
			'cat_seq': document.getElementById('event_cat_seq').value,
		};
		try {
			_EventDB.chk(event);
			_EventDB.upd(event);
			_EventGUI.hide();
			_CalGUI.del(event.seq);
			//_CalGUI.add(_EventDB.db[event.seq]);
			_CalGUI.add(event);
			_EventDB.save();
		} catch (err) {
			alert(err);
		}
	},
	del: function (e) {
		var seq = document.getElementById('event_seq').value;
		_EventGUI.hide();
		_CalGUI.del(seq);
		_EventDB.del(seq);
		_EventDB.save();
	},
	allday: function () {
		document.getElementById('event_start_hour').innerHTML = _Fmt.two_digits(0);
		document.getElementById('event_start_minute').innerHTML = _Fmt.two_digits(0);
		document.getElementById('event_duration_hour').innerHTML = _Fmt.two_digits(24);
		document.getElementById('event_duration_minute').innerHTML = _Fmt.two_digits(0);
		_EventGUI.upd_allday_button();
	},
	upd_repeat_button: function () {
		// update repeat button according to parameters
		var button = document.getElementById('button_event_repeat');
		var repeated = document.getElementById('event_rrule_until').value.length || document.getElementById('event_rrule_freq_radio').querySelectorAll('li.selected').length;
		if (repeated) {
			if (!button.classList.contains('selected'))
				button.classList.add('selected');
		} else {
			if (button.classList.contains('selected'))
				button.classList.remove('selected');
		}
	},
	upd_allday_button: function () {
		// update allday button
		var allday = document.getElementById('event_start_hour').innerHTML=='00' && document.getElementById('event_start_minute').innerHTML=='00' && document.getElementById('event_duration_hour').innerHTML=='24' && document.getElementById('event_duration_minute').innerHTML=='00';
		var button = document.getElementById('button_event_allday');
		if (allday) {
			if (!button.classList.contains('selected'))
				button.classList.add('selected');
		} else {
			if (button.classList.contains('selected'))
				button.classList.remove('selected');
		}
	},
	upd_cat_button: function () {
		var seq = document.getElementById('event_cat_seq').value;
		var obj = document.getElementById('button_event_cat');
		if (seq.length) {
			var cat = _CatDB.db[seq];
			obj.style.color = cat.color;
			obj.style.background = _CatGUI.get_css_background(cat);
			obj.className = 'rounded ' + cat.styles;
			obj.innerHTML = cat.name;
		} else {
			obj.style.color = '';
			obj.style.background = '';
			obj.className = 'rounded';
			obj.innerHTML = tr('None');
		}
	}
};

