// Jean Luc Biellmann - contact@alsatux.com

"use strict";

var _Fmt = {
	two_digits: function (value) {
		var val = _Fmt.to_uint(value);
		return (val<10 ? '0' : '') + val;
	},
	to_int: function (value) {
		return parseInt(value,10) || 0;
	},
	to_uint: function (value) {
		return Math.abs(_Fmt.to_int(value));
	},
	modulo: function (value, modulo) {
		return _Fmt.to_uint(value)%modulo;
	},
	resetClassName: function (objs) {
		for (var i=0;i<objs.length;i++)
			objs[i].className = '';
	},
	removeClassName: function (name, objs) {
		for (var i=0;i<objs.length;i++)
			objs[i].classList.remove(name);
	}
};

