// Jean Luc Biellmann - contact@alsatux.com

"use strict";

function tr (txt) {
	var pos = _Lang.dict.indexOf(txt);
	return _Lang.dict[pos + _Lang.current];
}

var _Lang = {
	current: 0,
	available: ['English', 'Français'],
	dict: [
// cactus.js
'Thanks to use','Merci d\'utiliser',
'Please report any bug to','Veuillez signaler tout bug à',
'Storage allowed... Searching for the last backup file...','Stockage autorisé... Recherche de la dernière sauvegarde...',
'Storage not allowed !','Stockage non autorisé !',
'None','Aucune',
// catdb.js
'The field','Le champ',
'is missing','est manquant',
'is empty','est vide',
'is bad formatted','est mal formaté',
'Unknown style','Style inconnu',
'sequence','séquence',
'name','nom',
'text color','couleur du texte',
'background type','type de fond',
'gradient color 1','couleur de dégradé 1',
'gradient color 2','couleur de dégradé 2',
'gradient angle','angle du dégradé',
// calgui.js
'Monday','Lundi',
'January,February,March,April,May,June,July,August,September,October,November,December','Janvier,Février,Mars,Avril,Mai,Juin,Juillet,Août,Septembre,Octobre,Novembre,Décembre',
'S,M,T,W,T,F,S','D,L,M,M,J,V,S',
// eventdb.js
'An event object is missing','Un objet événement est manquant',
'A category object is missing','Un objet catégorie est manquant',
'event start date','date de l\'événement',
'event start hour','heure du début de l\'événement',
'event start minute','minute de fin de l\'événement',
'event duration hour','nombre d\'heures',
'event duration minute','nombre de minutes',
'event title','titre de l\'événement',
'event description','description de l\'événement',
'event count','nombre de répétitions',
'event interval','intervalle de répétition',
'No sequence given','Pas de séquence donnée',
'Unknow sequence','Séquence inconnue',
'Invalid start date','Date de départ invalide',
'Invalid rrule frequency','Fréquence de répétition invalide',
'Invalid until date','Date de fin de répétition invalide',
// lang.js
'Lang is now','Langue courante',
// sd.js
' files found',' fichiers disponibles',
'Last backup detected','Dernière sauvegarde disponible',
'File','Fichier',
'succesfully readed','lu avec succès',
'Unable to read the file','Impossible de lire le fichier',
'Unable to read the last backup','Impossible de lire la dernière sauvegarde',
// settingsgui.js
'Week start is now','Le premier jour de la semaine est maintenant',
'monday','lundi',
'sunday','dimanche',
// storage.js
'Storage API not available','API de stockage non disponible',
'Storage device','Périphérique de stockage',
'not found','introuvable',
'Unable to write the file','Impossible d\'écrire le fichier',
'The file','Le fichier',
'has been written','a été écrit',
'Unable to write','Impossible d\'écrire',
'Unable to read the directory','Impossible de lire le répertoire',
'Reading directory','Lecture du répertoire',
'Adding a file','Ajout d\'un fichier',
'Continue','Continu',
'Finished','Terminé',
'USB not unplugged','cordon USB non débranché',
// xml.js
'Parsing XML failed','L\'analyse XML a échoué',
'Reading settings failed','La lecture des préférences a échoué',
'Reading category failed','La lecture de la catégorie a échoué',
'Creating new event','Création d\'un nouvel événement',
'Bad frequency value','La valeur de la fréquence de répétition est erronée',
'Bad start date value','La date de l\'événement est erronée',
'Unknown category','Catégorie inconnue',
'Reading event failed','La lecture de l\'événement a échoué',
'Recording settings failed','L\'enregistrement des préférences a échoué',
'Recording category failed','L\'enregistrement  d\'une catégorie a échoué',
'Recording event failed','L\'enregistrement de l\'événement a échoué',
// catgui.js
'Category choosed','Catégorie choisie : ',
// catmanage.js
'Editing category','Edition de la catégorie',
// cateditorgui.js
'Category not found','Catégorie introuvable',
'Unable to delete default category !','Impossible d\'enlever la catégorie par défaut !',
'Delete this category ?','Effacer cette catégorie ?',
'Unable to change default category !','Impossible de modifier la catégorie par défaut !',
'Field "name" is empty !','Le champ "nom" est vide !'
	],
	gui: [ // for index.html
// main
'menu_goto_settings','S','P',
'menu_goto_today','T','A',
'menu_goto_month','M','M',
// div_settings
'label_settings','Settings','Préférences',
'button_settings_close','X','X',
'label_lang','Language ?','Langue ?',
'label_wkst','Week start ?','Début de la semaine ?',
'cal_settings_wkst',['Monday,Sunday'],['Lundi,Dimanche'],
// div_goto_month
'label_go_to_month','Go to month ?','Aller au mois ?',
'ul_months_abrv',['Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov,Dec'],['Jan,Fév,Mar,Avr,Mai,Jui,Jul,Aoû,Sep,Oct,Nov,Déc'],
// div_event_start_hour
'label_event_start_hour','Hour ?','Heure ?',
// div_event_start_minute
'label_event_start_minute','Minute ?','Minute ?',
'label_event_start_minute_ok','OK','OK',
// div_event_duration_hour
'label_event_duration_hour','Hour ?','Heure ?',
'label_event_duration_hour_ok','OK','OK',
// div_event_duration_minute
'label_event_duration_minute','Minute ?','Minute ?',
'label_event_duration_minute_ok','OK','OK',
'button_event_delete','Delete','Effacer',
'button_event_submit','Submit','Envoyer',
'event_start_date','Start date','Date de début',
'label_event_start_time','Start time:','Début :',
'button_event_allday','Allday','Jour entier',
'label_event_duration','Duration:','Durée : ',
'button_event_repeat','Repeat','Répéter',
'event_title','Title ?','Titre ?',
'event_description','Description ?','Description ?',
'label_event_cat','Category:','Catégorie :',
'button_event_cat','None','Aucune',
// div_cat
'label_cat_category','Category ?','Catégorie ?',
'button_cat_manage_open','&gt;','&gt;',
// div_cat_manage
'button_cat_editor_add','+','+',
'button_cat_manage_close','&lt;','&lt;',
// div_cat_editor
'button_cat_editor_delete','Delete','Effacer',
'button_cat_editor_submit','Submit','Envoyer',
'cat_editor_name','Category name ?','Nom catégorie ?',
'cat_editor_fg_label','Text','Texte',
'label_cat_editor_color','Color:','Couleur : ',
'cat_editor_italic','I','I',
'cat_editor_bold','B','G',
'cat_editor_underline','U','S',
'cat_editor_bg_label','Background','Fond',
'label_cat_editor_bg_from','Color 1: ','Couleur 1 : ',
'label_cat_editor_bg_to','Color 2: ','Couleur 2 : ',
'label_cat_editor_bg_angle','Angle: ','Angle : ',
'cat_editor_bg_transparent','Transparent','Transparent',
'cat_editor_bg_color','Color','Aplat',
'cat_editor_bg_gradient','Gradient','Dégradé',
// div_log
'button_log_close','Close log','Fermer le journal',
// div_repeat
'button_repeat_close','Close','Fermer',
'event_rrule_freq_radio',['Yearly,Monthly,Weekly,Daily'],['An,Mois,Semaine,Jour'],
'event_rrule_label_interval','Interval ?','Intervalle ?',
'event_rrule_label_count','Count','Nombre',
'event_rrule_label_count_no_limit','(0=no limit)','(0=sans fin)',
'event_rrule_until','End date ?','Date de fin ?',
'event_rrule_until_reset','Reset','Effacer',
	],
	chg_to: function (index) {
		var pos = _Fmt.to_uint(index);
		if (pos>=0 && pos<_Lang.available.length && pos!=_Lang.current) {
			_Lang.current = pos;
			_Log.info(tr('Lang is now') + ' : ' + _Lang.available[_Lang.current]);
			for (var i=0;i<_Lang.gui.length;i+=3) {
				var obj = document.getElementById(_Lang.gui[i]);
				var value = _Lang.gui[i+1+_Lang.current];
				// object is a placeholder
				if (obj.hasAttribute('placeholder')) {
					obj.setAttribute('placeholder',value);
					continue;
				}
				// value is an array
				if (typeof value == 'object') {
					var v = String(value[0]).split(',');
					// obj is an ul
					var nodes = obj.querySelectorAll('li');
					if (nodes.length) {
						for (var j=0;j<v.length;j++)
							nodes[j].innerHTML = v[j];
						continue;
					}
					// obj is a span
					var nodes = obj.querySelectorAll('span');
					if (nodes.length) {
						for (var j=0;j<v.length;j++)
							nodes[j].innerHTML = v[j];
						continue;
					}
				}
				// value is a node
				obj.innerHTML = value;
			}
		}
	}
};
