// Jean Luc Biellmann - contact@alsatux.com

"use strict";

var _RepeatGUI = {
	init: function () {
		// opener
		document.getElementById('button_event_repeat').addEventListener("click", _RepeatGUI.show);
		// GUI objects
		document.getElementById('button_repeat_close').addEventListener("click", _RepeatGUI.hide);
		document.getElementById('event_rrule_freq_radio').addEventListener("click", _RepeatGUI.click_freq);
		document.getElementById('event_rrule_until_reset').addEventListener("click", _RepeatGUI.click_reset_until);
	},
	show: function (event) {
		document.getElementById('div_repeat').style.display = '';
	},
	hide: function (e) {
		document.getElementById('div_repeat').style.display = 'none';
		_EventGUI.upd_repeat_button();
	},
	select_freq: function (value) {
		var ul = document.getElementById('event_rrule_freq_radio');
		var lis = ul.querySelectorAll('li');
		// unselect all
		_Fmt.resetClassName(lis);
		// select by value
		for (var i=0;i<lis.length;i++) {
			if (lis[i].getAttribute('data-value').toLowerCase()==value.toLowerCase())
				lis[i].className = 'selected';
		}
		document.getElementById('event_rrule_freq').value = value.toLowerCase();
	},
	click_freq: function (e) {
		var o = e.target;
		if (o.nodeName && o.nodeName=='LI') {
			if (o.classList.contains('selected')) {
				// unselect
				_RepeatGUI.select_freq('');
			} else {
				// select
				_RepeatGUI.select_freq(o.getAttribute('data-value'));
			}
		}
	},
	click_reset_until: function (e) {
		document.getElementById('event_rrule_until').value = '';
	}
}
