// Jean Luc Biellmann - contact@alsatux.com

"use strict";

var _RRule = {
	y_cal: 2014,
	cal_year_events: [],
	YYYY: function (date) {
		return String(date).substr(0,4);
	},
	Y: function (date) {
		return parseInt(_RRule.YYYY(date),10);
	},
	MM: function (date) {
		return String(date).substr(5,2);
	},
	M: function (date) {
		return parseInt(_RRule.MM(date),10);
	},
	DD: function (date) {
		return String(date).substr(8,2);
	},
	D: function (date) {
		return parseInt(_RRule.DD(date),10);
	},
	add: function (date, rrule) {
		if (_RRule.YYYY(date)!=_RRule.y_cal)
			return false;
		if ('until' in rrule && rrule.until.length) {
			if (date>rrule.until)
				return false;
		}
		_RRule.cal_year_events.push(date);
		return true;
	},
	filter: function (y_cal, event) {

		_RRule.y_cal = y_cal;
		_RRule.cal_year_events = [];

		var start_date = event.start_date;
		var rrule = event.rrule;

		var now = new Date();
		var today = now.toYYYYMMDD('-');
		var yyyy_now = _RRule.YYYY(today); // string 4 chars
		var y_now = _RRule.Y(today); // int
		var mm_now = _RRule.MM(today); // string 2 chars
		var m_now = _RRule.M(today); // int
		var dd_now = _RRule.DD(today); // string 2 chars
		var d_now = _RRule.D(today); // int

		var yyyy_start_date = _RRule.YYYY(start_date); // string 4 chars
		var y_start_date = _RRule.Y(start_date); // int
		var mm_start_date = _RRule.MM(start_date); // string 2 chars
		var m_start_date = _RRule.M(start_date); // int
		var dd_start_date = _RRule.DD(start_date); // string 2 chars
		var d_start_date = _RRule.D(start_date); // int

		if (y_start_date>y_cal) // ignore futur events
			return [];

		if ('until' in rrule && rrule.until.length)
			if (_RRule.Y(rrule.until)<y_cal) // ignore old events
				return [];

		// frequency first
		if ('freq' in rrule && rrule.freq.length) {
			// yearly
			if (rrule.freq=='yearly') {
				var interval = 'interval' in rrule && rrule.interval>0 ? rrule.interval : 1;
				if ((y_cal-y_start_date)%interval==0) {
					var step = (y_cal-y_start_date)/interval;
					if (step<0) // start_date in the future
						return [];
					if ('count' in rrule && rrule.count>0) {
						if (step>rrule.count)
							return [];
					}
					var date = y_cal + '-' + mm_start_date + '-' + dd_start_date;
					_RRule.add(date, rrule);
				}
			}
			// monthly
			if (rrule.freq=='monthly') {
				var interval = 'interval' in rrule && rrule.interval>0 ? rrule.interval : 1;
				for (var m=1;m<13;m++) {
					if ((y_cal*12+m-(y_start_date*12+m_start_date))%interval==0) {
						var step = (y_cal*12+m-(y_start_date*12+m_start_date))/interval;
						if (step<0) // start_date in the future
							continue;
						if ('count' in rrule && rrule.count>0) {
							if (step>rrule.count)
								continue;
						}
						var date = y_cal + '-' + _Fmt.two_digits(m) + '-' + dd_start_date;
						_RRule.add(date, rrule);
					}
				}
			}
			// daily
			if (rrule.freq=='daily') {
				var interval = 'interval' in rrule && rrule.interval>0 ? rrule.interval : 1;
				_RRule.add(start_date, rrule);
				if ('count' in rrule && rrule.count>0) {
					for (var i=1;i<=rrule.count;i++) {
						var day = new Date(y_start_date, m_start_date-1, d_start_date+i*interval);
						var real_date = day.getFullYear() + '-' + _Fmt.two_digits(day.getMonth()+1) + '-' + _Fmt.two_digits(day.getDate());
						_RRule.add(real_date, rrule);
					}
				} else { // no count
					if (y_start_date==y_cal) {
						var i = 0;
						var y = y_start_date;
						while (y==y_cal) {
							i++;
							var day = new Date(y_start_date, m_start_date-1, d_start_date+i*rrule.interval);
							var real_date = day.getFullYear() + '-' + _Fmt.two_digits(day.getMonth()+1) + '-' + _Fmt.two_digits(day.getDate());
							_RRule.add(real_date, rrule);
							y = day.getFullYear();
						}
					} else { // event starts before calendar year
						var event_time = (new Date(y_start_date,m_start_date-1,d_start_date)).getTime();
						var step_time = rrule.interval*86400000;
						var step_min = Math.round(((new Date(y_cal,0,1)).getTime()-event_time)/step_time);
						var step_max = Math.round(((new Date(y_cal+1,0,1)).getTime()-event_time)/step_time);
						var y = y_start_date;
						for (var i=step_min;i<=step_max;i++) {
							var day = new Date(y_start_date, m_start_date-1, d_start_date+i*interval);
							var real_date = day.getFullYear() + '-' + _Fmt.two_digits(day.getMonth()+1) + '-' + _Fmt.two_digits(day.getDate());
							_RRule.add(real_date, rrule);
							y = day.getFullYear();
						}
					}
				}
			}
			// weekly
			if (rrule.freq=='weekly') {
				var interval = 'interval' in rrule && rrule.interval>0 ? rrule.interval*7 : 7;
				_RRule.add(start_date, rrule);
				if ('count' in rrule && rrule.count>0) {
					for (var i=1;i<=rrule.count;i++) {
						var day = new Date(y_start_date, m_start_date-1, d_start_date+i*interval);
						var real_date = day.getFullYear() + '-' + _Fmt.two_digits(day.getMonth()+1) + '-' + _Fmt.two_digits(day.getDate());
						_RRule.add(real_date, rrule);
					}
				} else { // no count
					if (y_start_date==y_cal) {
						var i = 0;
						var y = y_start_date;
						while (y==y_cal) {
							i++;
							var day = new Date(y_start_date, m_start_date-1, d_start_date+i*interval);
							var real_date = day.getFullYear() + '-' + _Fmt.two_digits(day.getMonth()+1) + '-' + _Fmt.two_digits(day.getDate());
							_RRule.add(real_date, rrule);
							y = day.getFullYear();
						}
					} else { // event starts before calendar year
						var event_time = (new Date(y_start_date,m_start_date-1,d_start_date)).getTime();
						var step_time = rrule.interval*7*86400000;
						var step_min = Math.round(((new Date(y_cal,0,1)).getTime()-event_time)/step_time);
						var step_max = Math.round(((new Date(y_cal+1,0,1)).getTime()-event_time)/step_time);
						var y = y_start_date;
						for (var i=step_min;i<=step_max;i++) {
							var day = new Date(y_start_date, m_start_date-1, d_start_date+i*interval);
							var real_date = day.getFullYear() + '-' + _Fmt.two_digits(day.getMonth()+1) + '-' + _Fmt.two_digits(day.getDate());
							_RRule.add(real_date, rrule);
							y = day.getFullYear();
						}
					}
				}
			}
		} else {
			//var date = y_cal + '-' + _RRule.MM(start_date) + '-' + _RRule.DD(start_date);
			_RRule.add(start_date, rrule);
		}
		return _RRule.cal_year_events;
	}
}
