// Jean Luc Biellmann - contact@alsatux.com

"use strict";

var _SD = {
	recall_last_backup: function () {
		_Storage.ls('sdcard', 'cactus/default', function (files) {
			_Log.info(files.length + tr(' files found') + '.');
			if (files.length) {
				var re = new RegExp('^.*cactus/default/([0-9]{14}).xml$','');
				var opts = {};
				for (var i=0;i<files.length;i++) {
					var m = (files[i].name).match(re);
					if (m!=null) {
						var txt = m[1];
						opts[txt] = files[i].name;
					}
				}
				var keys = Object.keys(opts);
				keys.sort();
				keys.reverse();
				// the first one the latest
				var filename = 'cactus/default/' + keys[0] + '.xml';
				_Log.info(tr('Last backup detected') + ' : ' + filename + '.');
				_SD.read(filename);
			}
		});
	},
	read: function (filename) {
		_Storage.read('sdcard', filename, function (req) {
			var reader = new FileReader();
			reader.onload = function(e) {
				_XML.read(reader.result);
				_MenuGUI.scroll_today();
				_Log.info(tr('File') + ' "' + filename + '" ' + tr('succesfully readed') + ' !');
			}
			reader.readAsText(req.result, 'UTF-8');
		}, function (req) {
			_Log.error(tr('Unable to read the file') + ' : ' + req.error);
			alert(tr('Unable to read the last backup') + ' ?!');
		});
	}
};

