// Jean Luc Biellmann - contact@alsatux.com

"use strict";

var _SettingsGUI = {
	init: function () {
		document.getElementById('menu_goto_settings').addEventListener("click",_SettingsGUI.show);
		document.getElementById('cal_settings_lang').addEventListener("click", _SettingsGUI.click_lang);
		document.getElementById('cal_settings_wkst').addEventListener("click", _SettingsGUI.click_wkst);
		document.getElementById('button_settings_close').addEventListener("click",_SettingsGUI.hide);
	},
	show: function (event) {
		document.getElementById('div_settings').style.display = '';
	},
	hide: function (e) {
		document.getElementById('div_settings').style.display = 'none';
	},
	set_wkst: function (value) {
		var lis = document.getElementById('cal_settings_wkst').querySelectorAll('span');
		for (var i=0;i<lis.length;i++)
			if (lis[i].getAttribute('data-value')!=value)
				lis[i].classList.remove('selected');
			else
				if (!lis[i].classList.contains('selected'))
					lis[i].classList.add('selected');
	},
	click_wkst: function (e) {
		var o = e.target;
		if (o.nodeName && o.nodeName=='SPAN') {
			_SettingsGUI.set_wkst(o.getAttribute('data-value'));
			_CalGUI.settings['wkst'] = o.getAttribute('data-value').toLowerCase();
			_Log.info(tr('Week start is now') + ' : ' + tr(_CalGUI.settings['wkst']));
		}
		_EventDB.save();
		_CalGUI.goto_year(_CalGUI.current_year);
	},
	set_lang: function (value) {
		var lis = document.getElementById('cal_settings_lang').querySelectorAll('span');
		for (var i=0;i<lis.length;i++)
			if (lis[i].getAttribute('data-value')!=value)
				lis[i].classList.remove('selected');
			else
				if (!lis[i].classList.contains('selected'))
					lis[i].classList.add('selected');
	},
	click_lang: function (e) {
		var o = e.target;
		if (o.nodeName && o.nodeName=='SPAN') {
			_SettingsGUI.set_lang(o.getAttribute('data-value'));
			_Lang.chg_to(o.getAttribute('data-value'));
			_CatDB.upd({
				'seq': 'cat_seq_0',
				'name': tr('None')
			});
		}
		_EventDB.save();
		_CalGUI.goto_year(_CalGUI.current_year);
	}
};

