// Jean Luc Biellmann - contact@alsatux.com

"use strict";

var _Storage = {
	debug: false,
	allowed: function () {
		return navigator.getDeviceStorage!==undefined;
	},
	read: function (device, filename, callback_onsuccess, callback_onerror) {
		if (!_Storage.allowed()) {
			_Log.warn(tr('Storage API not available') + '. ' + tr('Unable to read the file') + ' "' + device + ':' + filename + '".');
			return;
		}
		var storage = navigator.getDeviceStorage(device);
		if (storage==null) {
			_Log.warn(tr('Storage device') + ' "' + device + '" ' + tr('not found') + '.  ' + tr('Unable to read the file') + ' "' + filename + '".');
			return;
		}
		var req = storage.get(filename);
		req.onsuccess = function () {
			callback_onsuccess(this);
		}
		req.onerror = function () {
			callback_onerror(this);
		}
	},
	write: function (device, filename, blobdata, blobtype) {
		if (!_Storage.allowed()) {
			_Log.warn(tr('Storage API not available') + '. ' + tr('Unable to write the file') + ' "' + device + ':' + filename + '".');
			return;
		}
		var blob = new Blob([blobdata], {type: blobtype});
		var storage = navigator.getDeviceStorage(device);
		if (storage==null) {
			_Log.warn(tr('Storage device') + ' "' + device + '" ' + tr('not found') + '. ' + tr('Unable to write the file') + ' "' + filename + '".');
			return;
		}
		var req = storage.addNamed(blob, filename);
		req.onsuccess = function () {
			_Log.info(tr('The file') + ' "' + device + ':' + filename + '" ' + tr('has been written') + ' !');
		}
		req.onerror = function () {
			var extra = (device=='sdcard' ? ' ' + tr('USB not unplugged') + ' ?' : '');
			_Log.error(tr('Unable to write') + ' "' + device + ':' +  filename + '"' + extra);
		}
	},
	ls: function (device, dir, callback) {
		var files = [];
		if (!_Storage.allowed()) {
			_Log.warn(tr('Storage API not available') + '. ' + tr('Unable to read the directory') + ' "' + dir + '".');
			return callback(files);
		}
		var storage = navigator.getDeviceStorage(device);
		if (storage==null) {
			_Log.warn(tr('Storage device') + ' "' + device + '" ' + tr('not found') + '. ' + tr('Unable to read the directory') + ' "' + dir + '".');
			return callback(files);
		}
		_Log.info(tr('Reading directory') + ' "' + device + ':' + dir + '"...');
		var cursor = storage.enumerate(dir);
		cursor.onsuccess = function () {
			var file = cursor.result;
			if (file != null) {
				if (Storage.debug)
					_Log.info(tr('Adding a file') + ' "' + file.name + '"...');
				files.push(file);
				if (Storage.debug)
					_Log.info(tr('Continue') + '...');
				cursor.continue();
			} else {
				if (Storage.debug)
					_Log.info(tr('Finished') + '...');
				callback(files);
			}
		}
		cursor.onerror = function () {
			var extra = (device=='sdcard' ? ' ' + tr('USB not unplugged') + ' ?' : '');
			_Log.warn(tr('Unable to read the directory') + ' "' + device + ':' + dir + '".' + extra);
			callback(files);
		}
	}
};

