define(
    [],
  function(){
        var debug = 1;
        return {
                 pick:function(arg, def) {
                            return (typeof arg == 'undefined' ? def : arg);
                 },
                 get_type:function(obj){
                         Object.prototype.toString.call(obj).replace(/^\[object (.+)\]$/,"$1").toLowerCase();
                 },
                 log:function(object){
                    if(debug===1) console.log(object);
                 },
                getStyle:function(el,styleProp) { //http://stackoverflow.com/questions/1955048/get-computed-font-size-for-dom-element-in-js
                  if(!el) return null;
                  var camelize = function (str) {
                    return str.replace(/\-(\w)/g, function(str, letter){
                      return letter.toUpperCase();
                    });
                  };
                  if((el.style && el.style[camelize(styleProp)]) || (el.currentStyle && el.currentStyle[camelize(styleProp)])){
                       var res = el.style[camelize(styleProp)] || el.currentStyle[camelize(styleProp)];
                       if([null, undefined, 'undefined', '', 'auto'].indexOf(res)===-1) return res;
                  }
                  if(/height|width|top|left|right|bottom/i.test(styleProp) && el.getBoundingClientRect){
                      res = el.getBoundingClientRect()[styleProp];
                      return res;
                  } else if (document.defaultView && document.defaultView.getComputedStyle){
                      res = document.defaultView.getComputedStyle(el,null)
                                                .getPropertyValue(styleProp);
                      return res;
                  }
                },
                 emptynext: "<!DOCTYPE html><html><body><h1>Open next page..</h1></body></html>",
                 emptyprev: "<!DOCTYPE html><html><body><h1>Open prev page..</h1></body></html>",
                 empty: "<!DOCTYPE html><html><body><h1>No book opened.</h1></body></html>",
                 pprefix:"xmaintext",
                 targetimg:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAQAAADZc7J/AAAAAmJLR0QA/4ePzL8AAAMxSURBVEjHVdXZlts4DATQS4pabPcy+f+PTNJxWwspcR5EezLSg3xAEAcoVJUDFYIP0flMBtF5UJ2nARSL3H4vYaYKFaJ/WvrFRVUlvb6VDA67bFNFxb2VLeEPof53nU9BNZpQ9TodDoei6BSzQ/CwCGeJUIMfKqIPdG6q3qRTdW2Uwy7YzKLNQ5DdBayhfoqIPh0mE94Eg0EQXgUoVofNLPhC8UcgtTk/HC4GvclgFPXSXx0URXKg98enL8nVTEL1idFgNLqJJoNk0KmiqsqybBM9fPjy7sskKwmjKLpIRm+iq9FoaCBGxW63yg3Uhw+/3dy9+ZlUN4cbLq6iq6vJZJIMoopdtth0jQN3Nw+94pJMqgE3Sefq6urSuuh1gl2RDeZ2/XBz17n6bUwG1SSJLiajycXN1cVk0AkOxWoWG6S7bHC465UT6WjUC3qjydXVm5ux7WG363WialdsimoTDCeIvUP/eifjC4dnB1knqG2UySaIBtSE1FiXDAbJ2ECcjKLgkERVsRmtZkmnl626pIo6UdAJjUCpFRskwWFzyPq22CS2O1VMNMKexO1EnSS11FGQ7a/YGT/lHVXh6QFPxXt9n7Ez/b/z+v+s9AoebcdHU9/hsDcW7q/I8ZfR1FNMoR3XllJkpZEn2EWlxc73kF/Fgj1hVxpBtpa8Ng4eTWzZarPaZMtfvQVHQjE0lIvNbPCQ2t6fPMhms9nWiHQoNruaVFmw6QyyTW9u2y+NSKcWHx4Ws8VmUziHTLLB6jAp1ibgoNoNxpeYVqvFt9lqs1ssopVkNlmMZlWytgXtstHSTPX05GcHs9VhlZGTajGYjQZ3bwKqzcWiF1o3m/zqYre5CxbBd8LDaDW4+3RvXBiUxrsTxEO2yma7hwe+sRDqDyTvqg+8C96EZiZPBzg9ICtWm4dillW/hLOAZujvuBgkF6djPz1odygWhzsesuAnhDq4oboZ2nWuOkEvNUROW2exCr7tgl+nAAL1akQ1uao6VwFjk+3zn2lTRKsF1e+mpV+BVwmid0FtblCb8k5d7rIVweLRRvulNlnWyaXpcjSJNB96suI4tSf7bkUPXyr/AuzktdPMOGclAAAAAElFTkSuQmCC",
                 cycles:"data:image/svg+xml;base64,PCEtLSBDcmVhdGVkIHdpdGggSW5rc2NhcGUgKGh0dHA6Ly93d3cuaW5rc2NhcGUub3JnLykgLS0+CjxzdmcgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZlcnNpb249IjEuMSIgeG1sbnM6Y2M9Imh0dHA6Ly9jcmVhdGl2ZWNvbW1vbnMub3JnL25zIyIgeG1sbnM6ZGM9Imh0dHA6Ly9wdXJsLm9yZy9kYy9lbGVtZW50cy8xLjEvIiB2aWV3Qm94PSIwIDAgMzMwIDQxMCI+CiA8ZGVmcz48L2RlZnM+CiA8bWV0YWRhdGE+CiAgPHJkZjpSREY+CiAgIDxjYzpXb3JrIHJkZjphYm91dD0iIj4KICAgIDxkYzpmb3JtYXQ+aW1hZ2Uvc3ZnK3htbDwvZGM6Zm9ybWF0PgogICAgPGRjOnR5cGUgcmRmOnJlc291cmNlPSJodHRwOi8vcHVybC5vcmcvZGMvZGNtaXR5cGUvU3RpbGxJbWFnZSIvPgogICAgPGRjOnRpdGxlLz4KICAgPC9jYzpXb3JrPgogIDwvcmRmOlJERj4KIDwvbWV0YWRhdGE+CiA8ZyB0cmFuc2Zvcm09InRyYW5zbGF0ZSgtMTAxLjQzNzI4LC0zNDkuNzE4NzUpIj4KICA8ZyBvcGFjaXR5PSIwLjgwMDAwMDAwMDAwMDAwMDA0IiBzdHJva2UtbGluZWpvaW49InJvdW5kIiBmaWxsLXJ1bGU9Im5vbnplcm8iIHN0cm9rZS1kYXNob2Zmc2V0PSIwIiBzdHJva2U9IiMwMDAiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLW1pdGVybGltaXQ9IjQiIHN0cm9rZS1kYXNoYXJyYXk9Im5vbmUiIHN0cm9rZS13aWR0aD0iMiIgZmlsbD0iI2I2OTA5MCI+CiAgIDxwYXRoIGQ9Im0zOTAsNTUwYy0wLjA0OCwzMC0xMSw1Ny0zMCw4MGwzNCwyN2MyNC0zMCwzNi02NiwzNi0xMDAsMC4xNS05Ni03OC0xNzAtMTcwLTE3MCwwLDAtMS4xLTAuMTUtMS4yLTM0LDAsMC0wLjEzLTAuMjEtNzMsNTMsNzMsNTMsNzMsNTMsNzMsNTMsMC4xMy0zNCwwLjk5LTMzLDAuOTktMzMsNzMsMC4yLDEzMCw1OSwxMzAsMTMweiIvPgogICA8cGF0aCBkPSJtMTQwLDU2MGMwLjA0OC0zMCwxMS01NywzMC04MGwtMzQtMjdjLTI0LDMwLTM2LDY2LTM2LDEwMC0wLjE1LDk2LDc4LDE3MCwxNzAsMTcwLDAsMCwxLjEsMC4xNSwxLjIsMzQsMCwwLDAuMTMsMC4yMSw3My01My03My01My03My01My03My01My0wLjEzLDM0LTAuOTksMzMtMC45OSwzMy03My0wLjItMTMwLTU5LTEzMC0xMzB6Ii8+CiAgPC9nPgogPC9nPgo8L3N2Zz4K",
                 sndimg:"data:image/svg+xml;base64,PCEtLSBDcmVhdGVkIHdpdGggSW5rc2NhcGUgKGh0dHA6Ly93d3cuaW5rc2NhcGUub3JnLykgLS0+CjxzdmcgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZlcnNpb249IjEuMSIgeG1sbnM6Y2M9Imh0dHA6Ly9jcmVhdGl2ZWNvbW1vbnMub3JnL25zIyIgeG1sbnM6ZGM9Imh0dHA6Ly9wdXJsLm9yZy9kYy9lbGVtZW50cy8xLjEvIiB2aWV3Qm94PSIwIDAgMTUwIDE1MCI+CiA8bWV0YWRhdGE+CiAgPHJkZjpSREY+CiAgIDxjYzpXb3JrIHJkZjphYm91dD0iIj4KICAgIDxkYzpmb3JtYXQ+aW1hZ2Uvc3ZnK3htbDwvZGM6Zm9ybWF0PgogICAgPGRjOnR5cGUgcmRmOnJlc291cmNlPSJodHRwOi8vcHVybC5vcmcvZGMvZGNtaXR5cGUvU3RpbGxJbWFnZSIvPgogICAgPGRjOnRpdGxlLz4KICAgPC9jYzpXb3JrPgogIDwvcmRmOlJERj4KIDwvbWV0YWRhdGE+CiA8ZyB0cmFuc2Zvcm09InRyYW5zbGF0ZSgtNjIuNjc4ODMsLTI5Ni4zNjgyMSkiPgogIDxnIHN0cm9rZS1saW5lam9pbj0icm91bmQiIHN0cm9rZS1kYXNob2Zmc2V0PSIwIiB0cmFuc2Zvcm09Im1hdHJpeCgwLC0xLDEsMCwtMjMzLjUwNiw1MDcuMjU3MykiIHN0cm9rZT0iIzAwMCIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtZGFzaGFycmF5PSJub25lIiBzdHJva2UtbWl0ZXJsaW1pdD0iNCIgZmlsbD0ibm9uZSI+CiAgIDxwYXRoIGQ9Im0xNDAsMzAwLDY2LDc2LTEzMCwweiIgc3Ryb2tlLXdpZHRoPSI1LjIiLz4KICAgPHBhdGggZD0ibTM5MCw1NTBjLTM4LDUzLTEyMCw2OC0xODAsMzQtMTUtOC45LTI4LTIxLTM4LTM0IiB0cmFuc2Zvcm09Im1hdHJpeCgwLjY0ODUsMCwwLDAuMjgxLC00OC4zNjYzLDI3MikiIHN0cm9rZS13aWR0aD0iMTQuMTgyNjEzMzciLz4KICAgPHBhdGggZD0ibTM5MCw1NTBjLTM4LDUzLTEyMCw2OC0xODAsMzQtMTUtOC45LTI4LTIxLTM4LTM0IiB0cmFuc2Zvcm09Im1hdHJpeCgwLjUyNywwLDAsMC4zNTUsLTEzLjU2MTMzLDIxNC4zKSIgc3Ryb2tlLXdpZHRoPSIxMy42NTIwNyIvPgogICA8cGF0aCBkPSJtMzkwLDU1MGMtMzgsNTMtMTIwLDY4LTE4MCwzNC0xNS04LjktMjgtMjEtMzgtMzQiIHRyYW5zZm9ybT0ibWF0cml4KDAuNDI0NzMxNTEsMCwwLDAuMzgsMTUuNTQ2LDE4NC43KSIgc3Ryb2tlLXdpZHRoPSIxNi45OTk5MTk4OSIvPgogIDwvZz4KIDwvZz4KPC9zdmc+Cg==",
                 tocxsl:"<xsl:stylesheet version=&quot;1.0&quot; xmlns=&quot;http://www.w3.org/1999/xhtml&quot; exclude-result-prefixes=&quot;ncx xsl&quot; xmlns:ncx=&quot;http://www.daisy.org/z3986/2005/ncx/&quot; xmlns:epub=&quot;http://www.idpf.org/2007/ops&quot; xmlns:xsl=&quot;http://www.w3.org/1999/XSL/Transform&quot;> <xsl:output method=&quot;html&quot; indent=&quot;yes&quot; encoding=&quot;UTF-8&quot;/> <xsl:param name=&quot;contents-str&quot;>Contents</xsl:param> <xsl:template match=&quot;ncx:ncx&quot;> <xsl:call-template name=&quot;html-head&quot;/> <select id=&quot;tocselect&quot;> <xsl:apply-templates/> </select> </xsl:template> <xsl:template match=&quot;ncx:navMap&quot;> <!--h1><xsl:value-of select=&quot;$contents-str&quot;/></h1--> <xsl:apply-templates/> </xsl:template> <xsl:template match=&quot;ncx:navPoint&quot;> <option style=&quot;text-indent:{16*count(ancestor::*)}px&quot;> <xsl:attribute name=&quot;id&quot;> <xsl:value-of select=&quot;@playOrder&quot;/> </xsl:attribute> <xsl:attribute name=&quot;url&quot;> <xsl:apply-templates select=&quot;ncx:content&quot;/> </xsl:attribute> <xsl:value-of select=&quot;ncx:navLabel&quot;/> </option> <xsl:apply-templates select=&quot;ncx:navPoint&quot;/> </xsl:template> <xsl:template match=&quot;ncx:content&quot;> <xsl:apply-templates select=&quot;@src&quot;/> </xsl:template> <xsl:template match=&quot;ncx:navLabel| ncx:text&quot;> <xsl:apply-templates/> </xsl:template> <xsl:template match=&quot;ncx:head| ncx:docAuthor| ncx:docTitle&quot;/> <xsl:template match=&quot;ncx:head/text()| ncx:docAuthor/text()| ncx:docTitle/text()| ncx:navLabel/text()&quot;/> <xsl:template match=&quot;*&quot;> <xsl:message terminate=&quot;yes&quot;>ERROR: <xsl:value-of select=&quot;name(.)&quot;/> not matched! </xsl:message> </xsl:template> <xsl:template name=&quot;html-head&quot;> <h1><xsl:apply-templates select=&quot;/ncx:ncx/ncx:docTitle/ncx:text&quot;/></h1> </xsl:template> </xsl:stylesheet>",
                fb2xsl:"\x3C\x78\x73\x6C\x3A\x73\x74\x79\x6C\x65\x73\x68\x65\x65\x74\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\"\x31\x2E\x30\"\x20\x78\x6D\x6C\x6E\x73\x3A\x78\x73\x6C\x3D\"\x68\x74\x74\x70\x3A\x2F\x2F\x77\x77\x77\x2E\x77\x33\x2E\x6F\x72\x67\x2F\x31\x39\x39\x39\x2F\x58\x53\x4C\x2F\x54\x72\x61\x6E\x73\x66\x6F\x72\x6D\"\x20\x78\x6D\x6C\x6E\x73\x3A\x78\x6C\x69\x6E\x6B\x3D\"\x68\x74\x74\x70\x3A\x2F\x2F\x77\x77\x77\x2E\x77\x33\x2E\x6F\x72\x67\x2F\x31\x39\x39\x39\x2F\x78\x6C\x69\x6E\x6B\"\x20\x78\x6D\x6C\x6E\x73\x3A\x66\x62\x3D\"\x68\x74\x74\x70\x3A\x2F\x2F\x77\x77\x77\x2E\x67\x72\x69\x62\x75\x73\x65\x72\x2E\x72\x75\x2F\x78\x6D\x6C\x2F\x66\x69\x63\x74\x69\x6F\x6E\x62\x6F\x6F\x6B\x2F\x32\x2E\x30\"\x3E\n\t\x3C\x78\x73\x6C\x3A\x6F\x75\x74\x70\x75\x74\x20\x6D\x65\x74\x68\x6F\x64\x3D\"\x68\x74\x6D\x6C\"\x20\x65\x6E\x63\x6F\x64\x69\x6E\x67\x3D\"\x55\x54\x46\x2D\x38\"\x2F\x3E\n\t\x3C\x78\x73\x6C\x3A\x6B\x65\x79\x20\x6E\x61\x6D\x65\x3D\"\x6E\x6F\x74\x65\x2D\x6C\x69\x6E\x6B\"\x20\x6D\x61\x74\x63\x68\x3D\"\x66\x62\x3A\x73\x65\x63\x74\x69\x6F\x6E\"\x20\x75\x73\x65\x3D\"\x40\x69\x64\"\x2F\x3E\n\t\x3C\x78\x73\x6C\x3A\x74\x65\x6D\x70\x6C\x61\x74\x65\x20\x6D\x61\x74\x63\x68\x3D\"\x2F\x2A\"\x3E\n\t\t\t\t\t\t\x3C\x68\x34\x20\x61\x6C\x69\x67\x6E\x3D\"\x63\x65\x6E\x74\x65\x72\"\x3E\n\x20\x20\x20\x20\x20\x20\x20\x20\t\t\t\t\t\x3C\x78\x73\x6C\x3A\x76\x61\x6C\x75\x65\x2D\x6F\x66\x20\x73\x65\x6C\x65\x63\x74\x3D\"\x66\x62\x3A\x64\x65\x73\x63\x72\x69\x70\x74\x69\x6F\x6E\x2F\x66\x62\x3A\x74\x69\x74\x6C\x65\x2D\x69\x6E\x66\x6F\x2F\x66\x62\x3A\x62\x6F\x6F\x6B\x2D\x74\x69\x74\x6C\x65\"\x2F\x3E\n\t\t\t\t\t\t\x3C\x2F\x68\x34\x3E\n\n\x3C\x78\x73\x6C\x3A\x66\x6F\x72\x2D\x65\x61\x63\x68\x20\x73\x65\x6C\x65\x63\x74\x3D\"\x66\x62\x3A\x64\x65\x73\x63\x72\x69\x70\x74\x69\x6F\x6E\x2F\x66\x62\x3A\x74\x69\x74\x6C\x65\x2D\x69\x6E\x66\x6F\x2F\x66\x62\x3A\x63\x6F\x76\x65\x72\x70\x61\x67\x65\x2F\x66\x62\x3A\x69\x6D\x61\x67\x65\"\x3E\n\t\t\x3C\x78\x73\x6C\x3A\x63\x61\x6C\x6C\x2D\x74\x65\x6D\x70\x6C\x61\x74\x65\x20\x6E\x61\x6D\x65\x3D\"\x69\x6D\x61\x67\x65\"\x2F\x3E\n\t\t\x3C\x2F\x78\x73\x6C\x3A\x66\x6F\x72\x2D\x65\x61\x63\x68\x3E\n\n\t\t\t\t\x3C\x78\x73\x6C\x3A\x66\x6F\x72\x2D\x65\x61\x63\x68\x20\x73\x65\x6C\x65\x63\x74\x3D\"\x66\x62\x3A\x64\x65\x73\x63\x72\x69\x70\x74\x69\x6F\x6E\x2F\x66\x62\x3A\x74\x69\x74\x6C\x65\x2D\x69\x6E\x66\x6F\x2F\x66\x62\x3A\x61\x6E\x6E\x6F\x74\x61\x74\x69\x6F\x6E\"\x3E\n\n\t\t\t\t\t\x3C\x64\x69\x76\x20\x69\x64\x3D\"\x54\x4F\x43\x5F\x7B\x67\x65\x6E\x65\x72\x61\x74\x65\x2D\x69\x64\x28\x29\x7D\"\x3E\n\t\t\t\t\t\t\x3C\x78\x73\x6C\x3A\x63\x61\x6C\x6C\x2D\x74\x65\x6D\x70\x6C\x61\x74\x65\x20\x6E\x61\x6D\x65\x3D\"\x61\x6E\x6E\x6F\x74\x61\x74\x69\x6F\x6E\"\x2F\x3E\n\t\t\t\t\t\x3C\x2F\x64\x69\x76\x3E\n\t\t\t\t\t\x3C\x68\x72\x2F\x3E\n\t\t\t\t\x3C\x2F\x78\x73\x6C\x3A\x66\x6F\x72\x2D\x65\x61\x63\x68\x3E\n\t\t\t\t\x3C\x21\x2D\x2D\x20\x42\x55\x49\x4C\x44\x20\x54\x4F\x43\x20\x2D\x2D\x3E\n\t\t\t\t\x3C\x73\x65\x6C\x65\x63\x74\x20\x69\x64\x3D\"\x66\x62\x32\x74\x6F\x63\"\x3E\n\t\t\t\t\t\x3C\x78\x73\x6C\x3A\x61\x70\x70\x6C\x79\x2D\x74\x65\x6D\x70\x6C\x61\x74\x65\x73\x20\x73\x65\x6C\x65\x63\x74\x3D\"\x66\x62\x3A\x62\x6F\x64\x79\"\x20\x6D\x6F\x64\x65\x3D\"\x74\x6F\x63\"\x2F\x3E\n\t\t\t\t\x3C\x2F\x73\x65\x6C\x65\x63\x74\x3E\n\t\t\t\t\x3C\x68\x72\x2F\x3E\n\t\t\t\t\x3C\x21\x2D\x2D\x20\x42\x55\x49\x4C\x44\x20\x42\x4F\x4F\x4B\x20\x2D\x2D\x3E\n\t\t\t\t\x3C\x78\x73\x6C\x3A\x66\x6F\x72\x2D\x65\x61\x63\x68\x20\x73\x65\x6C\x65\x63\x74\x3D\"\x66\x62\x3A\x62\x6F\x64\x79\"\x3E\n\t\t\t\t\t\x3C\x78\x73\x6C\x3A\x69\x66\x20\x74\x65\x73\x74\x3D\"\x70\x6F\x73\x69\x74\x69\x6F\x6E\x28\x29\x21\x3D\x31\"\x3E\n\t\t\t\t\t\t\x3C\x68\x72\x2F\x3E\n\t\t\t\t\t\x3C\x2F\x78\x73\x6C\x3A\x69\x66\x3E\n\t\t\t\t\t\x3C\x78\x73\x6C\x3A\x69\x66\x20\x74\x65\x73\x74\x3D\"\x40\x6E\x61\x6D\x65\"\x3E\n\t\t\t\t\t\t\x3C\x68\x34\x20\x61\x6C\x69\x67\x6E\x3D\"\x63\x65\x6E\x74\x65\x72\"\x3E\n\t\t\t\t\t\t\t\x3C\x78\x73\x6C\x3A\x76\x61\x6C\x75\x65\x2D\x6F\x66\x20\x73\x65\x6C\x65\x63\x74\x3D\"\x40\x6E\x61\x6D\x65\"\x2F\x3E\n\t\t\t\t\t\t\x3C\x2F\x68\x34\x3E\n\t\t\t\t\t\x3C\x2F\x78\x73\x6C\x3A\x69\x66\x3E\n\t\t\t\t\t\x3C\x21\x2D\x2D\x20\x3C\x78\x73\x6C\x3A\x61\x70\x70\x6C\x79\x2D\x74\x65\x6D\x70\x6C\x61\x74\x65\x73\x20\x2F\x3E\x20\x2D\x2D\x3E\n\t\t\t\t\t\x3C\x78\x73\x6C\x3A\x61\x70\x70\x6C\x79\x2D\x74\x65\x6D\x70\x6C\x61\x74\x65\x73\x2F\x3E\n\t\t\t\t\x3C\x2F\x78\x73\x6C\x3A\x66\x6F\x72\x2D\x65\x61\x63\x68\x3E\n\t\x3C\x2F\x78\x73\x6C\x3A\x74\x65\x6D\x70\x6C\x61\x74\x65\x3E\n\t\x3C\x21\x2D\x2D\x20\x61\x75\x74\x68\x6F\x72\x20\x74\x65\x6D\x70\x6C\x61\x74\x65\x20\x2D\x2D\x3E\n\t\x3C\x78\x73\x6C\x3A\x74\x65\x6D\x70\x6C\x61\x74\x65\x20\x6E\x61\x6D\x65\x3D\"\x61\x75\x74\x68\x6F\x72\"\x3E\n\t\t\x3C\x78\x73\x6C\x3A\x76\x61\x6C\x75\x65\x2D\x6F\x66\x20\x73\x65\x6C\x65\x63\x74\x3D\"\x66\x62\x3A\x66\x69\x72\x73\x74\x2D\x6E\x61\x6D\x65\"\x2F\x3E\n\t\t\x3C\x78\x73\x6C\x3A\x74\x65\x78\x74\x20\x64\x69\x73\x61\x62\x6C\x65\x2D\x6F\x75\x74\x70\x75\x74\x2D\x65\x73\x63\x61\x70\x69\x6E\x67\x3D\"\x6E\x6F\"\x3E\x26\x23\x30\x33\x32\x3B\x3C\x2F\x78\x73\x6C\x3A\x74\x65\x78\x74\x3E\n\t\t\x3C\x78\x73\x6C\x3A\x76\x61\x6C\x75\x65\x2D\x6F\x66\x20\x73\x65\x6C\x65\x63\x74\x3D\"\x66\x62\x3A\x6D\x69\x64\x64\x6C\x65\x2D\x6E\x61\x6D\x65\"\x2F\x3E\x26\x23\x30\x33\x32\x3B\n\x20\x20\x20\x20\x20\x20\x20\x20\x20\x3C\x78\x73\x6C\x3A\x74\x65\x78\x74\x20\x64\x69\x73\x61\x62\x6C\x65\x2D\x6F\x75\x74\x70\x75\x74\x2D\x65\x73\x63\x61\x70\x69\x6E\x67\x3D\"\x6E\x6F\"\x3E\x26\x23\x30\x33\x32\x3B\x3C\x2F\x78\x73\x6C\x3A\x74\x65\x78\x74\x3E\n\t\t\x3C\x78\x73\x6C\x3A\x76\x61\x6C\x75\x65\x2D\x6F\x66\x20\x73\x65\x6C\x65\x63\x74\x3D\"\x66\x62\x3A\x6C\x61\x73\x74\x2D\x6E\x61\x6D\x65\"\x2F\x3E\n\t\t\x3C\x62\x72\x2F\x3E\n\t\x3C\x2F\x78\x73\x6C\x3A\x74\x65\x6D\x70\x6C\x61\x74\x65\x3E\n\t\x3C\x21\x2D\x2D\x20\x73\x65\x63\x75\x65\x6E\x63\x65\x20\x74\x65\x6D\x70\x6C\x61\x74\x65\x20\x2D\x2D\x3E\n\t\x3C\x78\x73\x6C\x3A\x74\x65\x6D\x70\x6C\x61\x74\x65\x20\x6E\x61\x6D\x65\x3D\"\x73\x65\x71\x75\x65\x6E\x63\x65\"\x3E\n\t\t\x3C\x4C\x49\x2F\x3E\n\t\t\x3C\x78\x73\x6C\x3A\x76\x61\x6C\x75\x65\x2D\x6F\x66\x20\x73\x65\x6C\x65\x63\x74\x3D\"\x40\x6E\x61\x6D\x65\"\x2F\x3E\n\t\t\x3C\x78\x73\x6C\x3A\x69\x66\x20\x74\x65\x73\x74\x3D\"\x40\x6E\x75\x6D\x62\x65\x72\"\x3E\n\t\t\t\x3C\x78\x73\x6C\x3A\x74\x65\x78\x74\x20\x64\x69\x73\x61\x62\x6C\x65\x2D\x6F\x75\x74\x70\x75\x74\x2D\x65\x73\x63\x61\x70\x69\x6E\x67\x3D\"\x6E\x6F\"\x3E\x2C\x26\x23\x30\x33\x32\x3B\x23\x3C\x2F\x78\x73\x6C\x3A\x74\x65\x78\x74\x3E\n\t\t\t\x3C\x78\x73\x6C\x3A\x76\x61\x6C\x75\x65\x2D\x6F\x66\x20\x73\x65\x6C\x65\x63\x74\x3D\"\x40\x6E\x75\x6D\x62\x65\x72\"\x2F\x3E\n\t\t\x3C\x2F\x78\x73\x6C\x3A\x69\x66\x3E\n\t\t\x3C\x78\x73\x6C\x3A\x69\x66\x20\x74\x65\x73\x74\x3D\"\x66\x62\x3A\x73\x65\x71\x75\x65\x6E\x63\x65\"\x3E\n\t\t\t\x3C\x75\x6C\x3E\n\t\t\t\t\x3C\x78\x73\x6C\x3A\x66\x6F\x72\x2D\x65\x61\x63\x68\x20\x73\x65\x6C\x65\x63\x74\x3D\"\x66\x62\x3A\x73\x65\x71\x75\x65\x6E\x63\x65\"\x3E\n\t\t\t\t\t\x3C\x78\x73\x6C\x3A\x63\x61\x6C\x6C\x2D\x74\x65\x6D\x70\x6C\x61\x74\x65\x20\x6E\x61\x6D\x65\x3D\"\x73\x65\x71\x75\x65\x6E\x63\x65\"\x2F\x3E\n\t\t\t\t\x3C\x2F\x78\x73\x6C\x3A\x66\x6F\x72\x2D\x65\x61\x63\x68\x3E\n\t\t\t\x3C\x2F\x75\x6C\x3E\n\t\t\x3C\x2F\x78\x73\x6C\x3A\x69\x66\x3E\n\t\t\x3C\x21\x2D\x2D\x20\x20\x20\x20\x20\x20\x3C\x62\x72\x2F\x3E\x20\x2D\x2D\x3E\n\t\x3C\x2F\x78\x73\x6C\x3A\x74\x65\x6D\x70\x6C\x61\x74\x65\x3E\n\t\x3C\x21\x2D\x2D\x20\x74\x6F\x63\x20\x74\x65\x6D\x70\x6C\x61\x74\x65\x20\x2D\x2D\x3E\n\t\x3C\x78\x73\x6C\x3A\x74\x65\x6D\x70\x6C\x61\x74\x65\x20\x6D\x61\x74\x63\x68\x3D\"\x66\x62\x3A\x73\x65\x63\x74\x69\x6F\x6E\"\x20\x6D\x6F\x64\x65\x3D\"\x74\x6F\x63\"\x3E\n\t\t\x3C\x78\x73\x6C\x3A\x63\x68\x6F\x6F\x73\x65\x3E\n\t\t\t\x3C\x78\x73\x6C\x3A\x77\x68\x65\x6E\x20\x74\x65\x73\x74\x3D\"\x6E\x61\x6D\x65\x28\x29\x3D\'\x62\x6F\x64\x79\'\x20\x61\x6E\x64\x20\x70\x6F\x73\x69\x74\x69\x6F\x6E\x28\x29\x3D\x31\x20\x61\x6E\x64\x20\x6E\x6F\x74\x28\x66\x62\x3A\x74\x69\x74\x6C\x65\x29\"\x3E\n\t\t\t\t\x3C\x78\x73\x6C\x3A\x61\x70\x70\x6C\x79\x2D\x74\x65\x6D\x70\x6C\x61\x74\x65\x73\x20\x73\x65\x6C\x65\x63\x74\x3D\"\x66\x62\x3A\x73\x65\x63\x74\x69\x6F\x6E\"\x20\x6D\x6F\x64\x65\x3D\"\x74\x6F\x63\"\x2F\x3E\n\t\t\t\x3C\x2F\x78\x73\x6C\x3A\x77\x68\x65\x6E\x3E\n\t\t\t\x3C\x78\x73\x6C\x3A\x6F\x74\x68\x65\x72\x77\x69\x73\x65\x3E\n\t\t\t\t\x3C\x6F\x70\x74\x69\x6F\x6E\x20\x73\x74\x79\x6C\x65\x3D\"\x74\x65\x78\x74\x2D\x69\x6E\x64\x65\x6E\x74\x3A\x7B\x31\x36\x2A\x63\x6F\x75\x6E\x74\x28\x61\x6E\x63\x65\x73\x74\x6F\x72\x3A\x3A\x2A\x29\x7D\x70\x78\"\x20\x64\x69\x64\x3D\"\x54\x4F\x43\x5F\x7B\x67\x65\x6E\x65\x72\x61\x74\x65\x2D\x69\x64\x28\x29\x7D\"\x3E\n\t\t\t\t\t\x3C\x21\x2D\x2D\x61\x20\x68\x72\x65\x66\x3D\"\x23\x54\x4F\x43\x5F\x7B\x67\x65\x6E\x65\x72\x61\x74\x65\x2D\x69\x64\x28\x29\x7D\"\x3E\x3C\x2F\x61\x2D\x2D\x3E\n\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x3C\x78\x73\x6C\x3A\x76\x61\x6C\x75\x65\x2D\x6F\x66\x20\x73\x65\x6C\x65\x63\x74\x3D\"\x6E\x6F\x72\x6D\x61\x6C\x69\x7A\x65\x2D\x73\x70\x61\x63\x65\x28\x66\x62\x3A\x74\x69\x74\x6C\x65\x2F\x66\x62\x3A\x70\x5B\x31\x5D\x20\x7C\x20\x40\x6E\x61\x6D\x65\x29\"\x2F\x3E\n\t\t\t\t\x3C\x2F\x6F\x70\x74\x69\x6F\x6E\x3E\n\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x3C\x78\x73\x6C\x3A\x69\x66\x20\x74\x65\x73\x74\x3D\"\x66\x62\x3A\x73\x65\x63\x74\x69\x6F\x6E\"\x3E\n\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x3C\x78\x73\x6C\x3A\x61\x70\x70\x6C\x79\x2D\x74\x65\x6D\x70\x6C\x61\x74\x65\x73\x20\x73\x65\x6C\x65\x63\x74\x3D\"\x66\x62\x3A\x73\x65\x63\x74\x69\x6F\x6E\"\x20\x6D\x6F\x64\x65\x3D\"\x74\x6F\x63\"\x2F\x3E\n\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x3C\x2F\x78\x73\x6C\x3A\x69\x66\x3E\n\t\t\t\x3C\x2F\x78\x73\x6C\x3A\x6F\x74\x68\x65\x72\x77\x69\x73\x65\x3E\n\t\t\x3C\x2F\x78\x73\x6C\x3A\x63\x68\x6F\x6F\x73\x65\x3E\n\t\x3C\x2F\x78\x73\x6C\x3A\x74\x65\x6D\x70\x6C\x61\x74\x65\x3E\n\t\x3C\x21\x2D\x2D\x20\x64\x65\x73\x63\x72\x69\x70\x74\x69\x6F\x6E\x20\x2D\x2D\x3E\n\t\x3C\x78\x73\x6C\x3A\x74\x65\x6D\x70\x6C\x61\x74\x65\x20\x6D\x61\x74\x63\x68\x3D\"\x66\x62\x3A\x64\x65\x73\x63\x72\x69\x70\x74\x69\x6F\x6E\"\x3E\n\t\t\x3C\x78\x73\x6C\x3A\x61\x70\x70\x6C\x79\x2D\x74\x65\x6D\x70\x6C\x61\x74\x65\x73\x2F\x3E\n\t\x3C\x2F\x78\x73\x6C\x3A\x74\x65\x6D\x70\x6C\x61\x74\x65\x3E\n\t\x3C\x21\x2D\x2D\x20\x62\x6F\x64\x79\x20\x2D\x2D\x3E\n\t\x3C\x78\x73\x6C\x3A\x74\x65\x6D\x70\x6C\x61\x74\x65\x20\x6D\x61\x74\x63\x68\x3D\"\x66\x62\x3A\x62\x6F\x64\x79\"\x3E\n\t\t\x3C\x64\x69\x76\x20\x69\x64\x3D\"\x54\x4F\x43\x5F\x7B\x67\x65\x6E\x65\x72\x61\x74\x65\x2D\x69\x64\x28\x29\x7D\"\x3E\x3C\x78\x73\x6C\x3A\x61\x70\x70\x6C\x79\x2D\x74\x65\x6D\x70\x6C\x61\x74\x65\x73\x2F\x3E\x3C\x2F\x64\x69\x76\x3E\n\t\x3C\x2F\x78\x73\x6C\x3A\x74\x65\x6D\x70\x6C\x61\x74\x65\x3E\n\n\t\x3C\x78\x73\x6C\x3A\x74\x65\x6D\x70\x6C\x61\x74\x65\x20\x6D\x61\x74\x63\x68\x3D\"\x66\x62\x3A\x73\x65\x63\x74\x69\x6F\x6E\"\x3E\n\t\t\x3C\x64\x69\x76\x20\x69\x64\x3D\"\x54\x4F\x43\x5F\x7B\x67\x65\x6E\x65\x72\x61\x74\x65\x2D\x69\x64\x28\x29\x7D\"\x3E\n\t\t\x3C\x78\x73\x6C\x3A\x69\x66\x20\x74\x65\x73\x74\x3D\"\x40\x69\x64\"\x3E\n\t\t\t\x3C\x78\x73\x6C\x3A\x65\x6C\x65\x6D\x65\x6E\x74\x20\x6E\x61\x6D\x65\x3D\"\x61\"\x3E\n\t\t\t\t\x3C\x78\x73\x6C\x3A\x61\x74\x74\x72\x69\x62\x75\x74\x65\x20\x6E\x61\x6D\x65\x3D\"\x6E\x61\x6D\x65\"\x3E\x3C\x78\x73\x6C\x3A\x76\x61\x6C\x75\x65\x2D\x6F\x66\x20\x73\x65\x6C\x65\x63\x74\x3D\"\x40\x69\x64\"\x2F\x3E\x3C\x2F\x78\x73\x6C\x3A\x61\x74\x74\x72\x69\x62\x75\x74\x65\x3E\n\t\t\t\x3C\x2F\x78\x73\x6C\x3A\x65\x6C\x65\x6D\x65\x6E\x74\x3E\n\t\t\x3C\x2F\x78\x73\x6C\x3A\x69\x66\x3E\n\t\t\x3C\x78\x73\x6C\x3A\x61\x70\x70\x6C\x79\x2D\x74\x65\x6D\x70\x6C\x61\x74\x65\x73\x20\x73\x65\x6C\x65\x63\x74\x3D\"\x2A\x5B\x6E\x6F\x74\x28\x73\x65\x6C\x66\x3A\x3A\x66\x62\x3A\x73\x65\x63\x74\x69\x6F\x6E\x29\x5D\"\x2F\x3E\n\x20\x20\x20\x20\x20\x20\x20\x20\x3C\x2F\x64\x69\x76\x3E\n\x20\x20\x20\x20\x20\x20\x20\x20\x3C\x78\x73\x6C\x3A\x61\x70\x70\x6C\x79\x2D\x74\x65\x6D\x70\x6C\x61\x74\x65\x73\x20\x73\x65\x6C\x65\x63\x74\x3D\"\x66\x62\x3A\x73\x65\x63\x74\x69\x6F\x6E\"\x2F\x3E\n\t\x3C\x2F\x78\x73\x6C\x3A\x74\x65\x6D\x70\x6C\x61\x74\x65\x3E\n\t\n\t\n\t\x3C\x21\x2D\x2D\x20\x73\x65\x63\x74\x69\x6F\x6E\x2F\x74\x69\x74\x6C\x65\x20\x2D\x2D\x3E\n\t\x3C\x78\x73\x6C\x3A\x74\x65\x6D\x70\x6C\x61\x74\x65\x20\x6D\x61\x74\x63\x68\x3D\"\x66\x62\x3A\x73\x65\x63\x74\x69\x6F\x6E\x2F\x66\x62\x3A\x74\x69\x74\x6C\x65\x7C\x66\x62\x3A\x70\x6F\x65\x6D\x2F\x66\x62\x3A\x74\x69\x74\x6C\x65\"\x3E\n\t\t\x3C\x78\x73\x6C\x3A\x63\x68\x6F\x6F\x73\x65\x3E\n\t\t\t\x3C\x78\x73\x6C\x3A\x77\x68\x65\x6E\x20\x74\x65\x73\x74\x3D\"\x63\x6F\x75\x6E\x74\x28\x61\x6E\x63\x65\x73\x74\x6F\x72\x3A\x3A\x6E\x6F\x64\x65\x28\x29\x29\x20\x26\x6C\x74\x3B\x20\x39\"\x3E\n\t\t\t\t\x3C\x78\x73\x6C\x3A\x65\x6C\x65\x6D\x65\x6E\x74\x20\x6E\x61\x6D\x65\x3D\"\x7B\x63\x6F\x6E\x63\x61\x74\x28\'\x68\'\x2C\x63\x6F\x75\x6E\x74\x28\x61\x6E\x63\x65\x73\x74\x6F\x72\x3A\x3A\x6E\x6F\x64\x65\x28\x29\x29\x2D\x33\x29\x7D\"\x3E\n\t\t\t\t\t\x3C\x21\x2D\x2D\x61\x20\x6E\x61\x6D\x65\x3D\"\x54\x4F\x43\x5F\x7B\x67\x65\x6E\x65\x72\x61\x74\x65\x2D\x69\x64\x28\x29\x7D\"\x3E\x3C\x2F\x61\x2D\x2D\x3E\n\t\t\t\t\t\x3C\x78\x73\x6C\x3A\x69\x66\x20\x74\x65\x73\x74\x3D\"\x40\x69\x64\"\x3E\n\t\t\t\t\t\t\x3C\x78\x73\x6C\x3A\x65\x6C\x65\x6D\x65\x6E\x74\x20\x6E\x61\x6D\x65\x3D\"\x61\"\x3E\n\t\t\t\t\t\t\t\x3C\x78\x73\x6C\x3A\x61\x74\x74\x72\x69\x62\x75\x74\x65\x20\x6E\x61\x6D\x65\x3D\"\x6E\x61\x6D\x65\"\x3E\x3C\x78\x73\x6C\x3A\x76\x61\x6C\x75\x65\x2D\x6F\x66\x20\x73\x65\x6C\x65\x63\x74\x3D\"\x40\x69\x64\"\x2F\x3E\x3C\x2F\x78\x73\x6C\x3A\x61\x74\x74\x72\x69\x62\x75\x74\x65\x3E\n\t\t\t\t\t\t\x3C\x2F\x78\x73\x6C\x3A\x65\x6C\x65\x6D\x65\x6E\x74\x3E\n\t\t\t\t\t\x3C\x2F\x78\x73\x6C\x3A\x69\x66\x3E\n\t\t\t\t\t\x3C\x78\x73\x6C\x3A\x61\x70\x70\x6C\x79\x2D\x74\x65\x6D\x70\x6C\x61\x74\x65\x73\x2F\x3E\n\t\t\t\t\x3C\x2F\x78\x73\x6C\x3A\x65\x6C\x65\x6D\x65\x6E\x74\x3E\n\t\t\t\x3C\x2F\x78\x73\x6C\x3A\x77\x68\x65\x6E\x3E\n\t\t\t\x3C\x78\x73\x6C\x3A\x6F\x74\x68\x65\x72\x77\x69\x73\x65\x3E\n\t\t\t\t\x3C\x78\x73\x6C\x3A\x65\x6C\x65\x6D\x65\x6E\x74\x20\x6E\x61\x6D\x65\x3D\"\x68\x36\"\x3E\n\t\t\t\t\t\x3C\x78\x73\x6C\x3A\x69\x66\x20\x74\x65\x73\x74\x3D\"\x40\x69\x64\"\x3E\n\t\t\t\t\t\t\x3C\x78\x73\x6C\x3A\x65\x6C\x65\x6D\x65\x6E\x74\x20\x6E\x61\x6D\x65\x3D\"\x61\"\x3E\n\t\t\t\t\t\t\t\x3C\x78\x73\x6C\x3A\x61\x74\x74\x72\x69\x62\x75\x74\x65\x20\x6E\x61\x6D\x65\x3D\"\x6E\x61\x6D\x65\"\x3E\x3C\x78\x73\x6C\x3A\x76\x61\x6C\x75\x65\x2D\x6F\x66\x20\x73\x65\x6C\x65\x63\x74\x3D\"\x40\x69\x64\"\x2F\x3E\x3C\x2F\x78\x73\x6C\x3A\x61\x74\x74\x72\x69\x62\x75\x74\x65\x3E\n\t\t\t\t\t\t\x3C\x2F\x78\x73\x6C\x3A\x65\x6C\x65\x6D\x65\x6E\x74\x3E\n\t\t\t\t\t\x3C\x2F\x78\x73\x6C\x3A\x69\x66\x3E\n\t\t\t\t\t\x3C\x78\x73\x6C\x3A\x61\x70\x70\x6C\x79\x2D\x74\x65\x6D\x70\x6C\x61\x74\x65\x73\x2F\x3E\n\t\t\t\t\x3C\x2F\x78\x73\x6C\x3A\x65\x6C\x65\x6D\x65\x6E\x74\x3E\n\t\t\t\x3C\x2F\x78\x73\x6C\x3A\x6F\x74\x68\x65\x72\x77\x69\x73\x65\x3E\n\t\t\x3C\x2F\x78\x73\x6C\x3A\x63\x68\x6F\x6F\x73\x65\x3E\n\t\x3C\x2F\x78\x73\x6C\x3A\x74\x65\x6D\x70\x6C\x61\x74\x65\x3E\n\t\x3C\x21\x2D\x2D\x20\x73\x65\x63\x74\x69\x6F\x6E\x2F\x74\x69\x74\x6C\x65\x20\x2D\x2D\x3E\n\t\x3C\x78\x73\x6C\x3A\x74\x65\x6D\x70\x6C\x61\x74\x65\x20\x6D\x61\x74\x63\x68\x3D\"\x66\x62\x3A\x62\x6F\x64\x79\x2F\x66\x62\x3A\x74\x69\x74\x6C\x65\"\x3E\n\t\t\x3C\x68\x31\x3E\x3C\x78\x73\x6C\x3A\x61\x70\x70\x6C\x79\x2D\x74\x65\x6D\x70\x6C\x61\x74\x65\x73\x20\x6D\x6F\x64\x65\x3D\"\x74\x69\x74\x6C\x65\"\x2F\x3E\x3C\x2F\x68\x31\x3E\n\t\x3C\x2F\x78\x73\x6C\x3A\x74\x65\x6D\x70\x6C\x61\x74\x65\x3E\n\n\t\x3C\x78\x73\x6C\x3A\x74\x65\x6D\x70\x6C\x61\x74\x65\x20\x6D\x61\x74\x63\x68\x3D\"\x66\x62\x3A\x74\x69\x74\x6C\x65\x2F\x66\x62\x3A\x70\"\x3E\n\t\t\x3C\x78\x73\x6C\x3A\x61\x70\x70\x6C\x79\x2D\x74\x65\x6D\x70\x6C\x61\x74\x65\x73\x2F\x3E\x3C\x78\x73\x6C\x3A\x74\x65\x78\x74\x20\x64\x69\x73\x61\x62\x6C\x65\x2D\x6F\x75\x74\x70\x75\x74\x2D\x65\x73\x63\x61\x70\x69\x6E\x67\x3D\"\x6E\x6F\"\x3E\x26\x23\x30\x33\x32\x3B\x3C\x2F\x78\x73\x6C\x3A\x74\x65\x78\x74\x3E\x3C\x62\x72\x2F\x3E\n\t\x3C\x2F\x78\x73\x6C\x3A\x74\x65\x6D\x70\x6C\x61\x74\x65\x3E\n\t\x3C\x21\x2D\x2D\x20\x73\x75\x62\x74\x69\x74\x6C\x65\x20\x2D\x2D\x3E\n\t\x3C\x78\x73\x6C\x3A\x74\x65\x6D\x70\x6C\x61\x74\x65\x20\x6D\x61\x74\x63\x68\x3D\"\x66\x62\x3A\x73\x75\x62\x74\x69\x74\x6C\x65\"\x3E\n\t\t\x3C\x78\x73\x6C\x3A\x69\x66\x20\x74\x65\x73\x74\x3D\"\x40\x69\x64\"\x3E\n\t\t\t\x3C\x78\x73\x6C\x3A\x65\x6C\x65\x6D\x65\x6E\x74\x20\x6E\x61\x6D\x65\x3D\"\x61\"\x3E\n\t\t\t\t\x3C\x78\x73\x6C\x3A\x61\x74\x74\x72\x69\x62\x75\x74\x65\x20\x6E\x61\x6D\x65\x3D\"\x6E\x61\x6D\x65\"\x3E\x3C\x78\x73\x6C\x3A\x76\x61\x6C\x75\x65\x2D\x6F\x66\x20\x73\x65\x6C\x65\x63\x74\x3D\"\x40\x69\x64\"\x2F\x3E\x3C\x2F\x78\x73\x6C\x3A\x61\x74\x74\x72\x69\x62\x75\x74\x65\x3E\n\t\t\t\x3C\x2F\x78\x73\x6C\x3A\x65\x6C\x65\x6D\x65\x6E\x74\x3E\n\t\t\x3C\x2F\x78\x73\x6C\x3A\x69\x66\x3E\n\t\t\x3C\x68\x35\x3E\n\t\t\t\x3C\x78\x73\x6C\x3A\x61\x70\x70\x6C\x79\x2D\x74\x65\x6D\x70\x6C\x61\x74\x65\x73\x2F\x3E\n\t\t\x3C\x2F\x68\x35\x3E\n\t\x3C\x2F\x78\x73\x6C\x3A\x74\x65\x6D\x70\x6C\x61\x74\x65\x3E\n\t\x3C\x21\x2D\x2D\x20\x70\x20\x2D\x2D\x3E\n\t\x3C\x78\x73\x6C\x3A\x74\x65\x6D\x70\x6C\x61\x74\x65\x20\x6D\x61\x74\x63\x68\x3D\"\x66\x62\x3A\x70\"\x3E\n\t\t\x3C\x64\x69\x76\x20\x69\x64\x3D\"\x54\x4F\x43\x5F\x7B\x67\x65\x6E\x65\x72\x61\x74\x65\x2D\x69\x64\x28\x29\x7D\"\x20\x61\x6C\x69\x67\x6E\x3D\"\x6A\x75\x73\x74\x69\x66\x79\"\x3E\x3C\x78\x73\x6C\x3A\x69\x66\x20\x74\x65\x73\x74\x3D\"\x40\x69\x64\"\x3E\n\t\t\t\t\x3C\x78\x73\x6C\x3A\x65\x6C\x65\x6D\x65\x6E\x74\x20\x6E\x61\x6D\x65\x3D\"\x61\"\x3E\n\t\t\t\t\t\x3C\x78\x73\x6C\x3A\x61\x74\x74\x72\x69\x62\x75\x74\x65\x20\x6E\x61\x6D\x65\x3D\"\x6E\x61\x6D\x65\"\x3E\x3C\x78\x73\x6C\x3A\x76\x61\x6C\x75\x65\x2D\x6F\x66\x20\x73\x65\x6C\x65\x63\x74\x3D\"\x40\x69\x64\"\x2F\x3E\x3C\x2F\x78\x73\x6C\x3A\x61\x74\x74\x72\x69\x62\x75\x74\x65\x3E\n\t\t\t\t\x3C\x2F\x78\x73\x6C\x3A\x65\x6C\x65\x6D\x65\x6E\x74\x3E\n\t\t\t\x3C\x2F\x78\x73\x6C\x3A\x69\x66\x3E\t\x26\x23\x31\x36\x30\x3B\x26\x23\x31\x36\x30\x3B\x26\x23\x31\x36\x30\x3B\x3C\x78\x73\x6C\x3A\x61\x70\x70\x6C\x79\x2D\x74\x65\x6D\x70\x6C\x61\x74\x65\x73\x2F\x3E\x3C\x2F\x64\x69\x76\x3E\n\t\x3C\x2F\x78\x73\x6C\x3A\x74\x65\x6D\x70\x6C\x61\x74\x65\x3E\n\t\x3C\x21\x2D\x2D\x20\x73\x74\x72\x6F\x6E\x67\x20\x2D\x2D\x3E\n\t\x3C\x78\x73\x6C\x3A\x74\x65\x6D\x70\x6C\x61\x74\x65\x20\x6D\x61\x74\x63\x68\x3D\"\x66\x62\x3A\x73\x74\x72\x6F\x6E\x67\"\x3E\n\t\t\x3C\x62\x3E\x3C\x78\x73\x6C\x3A\x61\x70\x70\x6C\x79\x2D\x74\x65\x6D\x70\x6C\x61\x74\x65\x73\x2F\x3E\x3C\x2F\x62\x3E\n\t\x3C\x2F\x78\x73\x6C\x3A\x74\x65\x6D\x70\x6C\x61\x74\x65\x3E\n\t\x3C\x21\x2D\x2D\x20\x65\x6D\x70\x68\x61\x73\x69\x73\x20\x2D\x2D\x3E\n\t\x3C\x78\x73\x6C\x3A\x74\x65\x6D\x70\x6C\x61\x74\x65\x20\x6D\x61\x74\x63\x68\x3D\"\x66\x62\x3A\x65\x6D\x70\x68\x61\x73\x69\x73\"\x3E\n\t\t\x3C\x69\x3E\t\x3C\x78\x73\x6C\x3A\x61\x70\x70\x6C\x79\x2D\x74\x65\x6D\x70\x6C\x61\x74\x65\x73\x2F\x3E\x3C\x2F\x69\x3E\n\t\x3C\x2F\x78\x73\x6C\x3A\x74\x65\x6D\x70\x6C\x61\x74\x65\x3E\n\t\x3C\x21\x2D\x2D\x20\x73\x74\x79\x6C\x65\x20\x2D\x2D\x3E\n\t\x3C\x78\x73\x6C\x3A\x74\x65\x6D\x70\x6C\x61\x74\x65\x20\x6D\x61\x74\x63\x68\x3D\"\x66\x62\x3A\x73\x74\x79\x6C\x65\"\x3E\n\t\t\x3C\x73\x70\x61\x6E\x20\x63\x6C\x61\x73\x73\x3D\"\x7B\x40\x6E\x61\x6D\x65\x7D\"\x3E\x3C\x78\x73\x6C\x3A\x61\x70\x70\x6C\x79\x2D\x74\x65\x6D\x70\x6C\x61\x74\x65\x73\x2F\x3E\x3C\x2F\x73\x70\x61\x6E\x3E\n\t\x3C\x2F\x78\x73\x6C\x3A\x74\x65\x6D\x70\x6C\x61\x74\x65\x3E\n\t\x3C\x21\x2D\x2D\x20\x65\x6D\x70\x74\x79\x2D\x6C\x69\x6E\x65\x20\x2D\x2D\x3E\n\t\x3C\x78\x73\x6C\x3A\x74\x65\x6D\x70\x6C\x61\x74\x65\x20\x6D\x61\x74\x63\x68\x3D\"\x66\x62\x3A\x65\x6D\x70\x74\x79\x2D\x6C\x69\x6E\x65\"\x3E\n\t\t\x3C\x62\x72\x2F\x3E\n\t\x3C\x2F\x78\x73\x6C\x3A\x74\x65\x6D\x70\x6C\x61\x74\x65\x3E\n\t\x3C\x21\x2D\x2D\x20\x6C\x69\x6E\x6B\x20\x2D\x2D\x3E\n\t\x3C\x78\x73\x6C\x3A\x74\x65\x6D\x70\x6C\x61\x74\x65\x20\x6D\x61\x74\x63\x68\x3D\"\x66\x62\x3A\x61\"\x3E\n\t\t\x3C\x78\x73\x6C\x3A\x65\x6C\x65\x6D\x65\x6E\x74\x20\x6E\x61\x6D\x65\x3D\"\x61\"\x3E\n\t\t\t\x3C\x78\x73\x6C\x3A\x61\x74\x74\x72\x69\x62\x75\x74\x65\x20\x6E\x61\x6D\x65\x3D\"\x68\x72\x65\x66\"\x3E\x3C\x78\x73\x6C\x3A\x76\x61\x6C\x75\x65\x2D\x6F\x66\x20\x73\x65\x6C\x65\x63\x74\x3D\"\x40\x78\x6C\x69\x6E\x6B\x3A\x68\x72\x65\x66\"\x2F\x3E\x3C\x2F\x78\x73\x6C\x3A\x61\x74\x74\x72\x69\x62\x75\x74\x65\x3E\n\t\t\t\x3C\x78\x73\x6C\x3A\x61\x74\x74\x72\x69\x62\x75\x74\x65\x20\x6E\x61\x6D\x65\x3D\"\x74\x69\x74\x6C\x65\"\x3E\n\t\t\t\t\x3C\x78\x73\x6C\x3A\x63\x68\x6F\x6F\x73\x65\x3E\n\t\t\t\t\t\x3C\x78\x73\x6C\x3A\x77\x68\x65\x6E\x20\x74\x65\x73\x74\x3D\"\x73\x74\x61\x72\x74\x73\x2D\x77\x69\x74\x68\x28\x40\x78\x6C\x69\x6E\x6B\x3A\x68\x72\x65\x66\x2C\'\x23\'\x29\"\x3E\x3C\x78\x73\x6C\x3A\x76\x61\x6C\x75\x65\x2D\x6F\x66\x20\x73\x65\x6C\x65\x63\x74\x3D\"\x6B\x65\x79\x28\'\x6E\x6F\x74\x65\x2D\x6C\x69\x6E\x6B\'\x2C\x73\x75\x62\x73\x74\x72\x69\x6E\x67\x2D\x61\x66\x74\x65\x72\x28\x40\x78\x6C\x69\x6E\x6B\x3A\x68\x72\x65\x66\x2C\'\x23\'\x29\x29\x2F\x66\x62\x3A\x70\"\x2F\x3E\x3C\x2F\x78\x73\x6C\x3A\x77\x68\x65\x6E\x3E\n\t\t\t\t\t\x3C\x78\x73\x6C\x3A\x6F\x74\x68\x65\x72\x77\x69\x73\x65\x3E\x3C\x78\x73\x6C\x3A\x76\x61\x6C\x75\x65\x2D\x6F\x66\x20\x73\x65\x6C\x65\x63\x74\x3D\"\x6B\x65\x79\x28\'\x6E\x6F\x74\x65\x2D\x6C\x69\x6E\x6B\'\x2C\x40\x78\x6C\x69\x6E\x6B\x3A\x68\x72\x65\x66\x29\x2F\x66\x62\x3A\x70\"\x2F\x3E\x3C\x2F\x78\x73\x6C\x3A\x6F\x74\x68\x65\x72\x77\x69\x73\x65\x3E\n\t\t\t\t\x3C\x2F\x78\x73\x6C\x3A\x63\x68\x6F\x6F\x73\x65\x3E\n\t\t\t\x3C\x2F\x78\x73\x6C\x3A\x61\x74\x74\x72\x69\x62\x75\x74\x65\x3E\n\t\t\t\x3C\x78\x73\x6C\x3A\x63\x68\x6F\x6F\x73\x65\x3E\n\t\t\t\t\x3C\x78\x73\x6C\x3A\x77\x68\x65\x6E\x20\x74\x65\x73\x74\x3D\"\x28\x40\x74\x79\x70\x65\x29\x20\x3D\x20\'\x6E\x6F\x74\x65\'\"\x3E\n\t\t\t\t\t\x3C\x73\x75\x70\x3E\n\t\t\t\t\t\t\x3C\x78\x73\x6C\x3A\x61\x70\x70\x6C\x79\x2D\x74\x65\x6D\x70\x6C\x61\x74\x65\x73\x2F\x3E\n\t\t\t\t\t\x3C\x2F\x73\x75\x70\x3E\n\t\t\t\t\x3C\x2F\x78\x73\x6C\x3A\x77\x68\x65\x6E\x3E\n\t\t\t\t\x3C\x78\x73\x6C\x3A\x6F\x74\x68\x65\x72\x77\x69\x73\x65\x3E\n\t\t\t\t\t\x3C\x78\x73\x6C\x3A\x61\x70\x70\x6C\x79\x2D\x74\x65\x6D\x70\x6C\x61\x74\x65\x73\x2F\x3E\n\t\t\t\t\x3C\x2F\x78\x73\x6C\x3A\x6F\x74\x68\x65\x72\x77\x69\x73\x65\x3E\n\t\t\t\x3C\x2F\x78\x73\x6C\x3A\x63\x68\x6F\x6F\x73\x65\x3E\n\t\t\x3C\x2F\x78\x73\x6C\x3A\x65\x6C\x65\x6D\x65\x6E\x74\x3E\n\t\x3C\x2F\x78\x73\x6C\x3A\x74\x65\x6D\x70\x6C\x61\x74\x65\x3E\n\t\x3C\x21\x2D\x2D\x20\x61\x6E\x6E\x6F\x74\x61\x74\x69\x6F\x6E\x20\x2D\x2D\x3E\n\t\x3C\x78\x73\x6C\x3A\x74\x65\x6D\x70\x6C\x61\x74\x65\x20\x6E\x61\x6D\x65\x3D\"\x61\x6E\x6E\x6F\x74\x61\x74\x69\x6F\x6E\"\x3E\n\t\t\x3C\x78\x73\x6C\x3A\x69\x66\x20\x74\x65\x73\x74\x3D\"\x40\x69\x64\"\x3E\n\t\t\t\x3C\x78\x73\x6C\x3A\x65\x6C\x65\x6D\x65\x6E\x74\x20\x6E\x61\x6D\x65\x3D\"\x61\"\x3E\n\t\t\t\t\x3C\x78\x73\x6C\x3A\x61\x74\x74\x72\x69\x62\x75\x74\x65\x20\x6E\x61\x6D\x65\x3D\"\x6E\x61\x6D\x65\"\x3E\x3C\x78\x73\x6C\x3A\x76\x61\x6C\x75\x65\x2D\x6F\x66\x20\x73\x65\x6C\x65\x63\x74\x3D\"\x40\x69\x64\"\x2F\x3E\x3C\x2F\x78\x73\x6C\x3A\x61\x74\x74\x72\x69\x62\x75\x74\x65\x3E\n\t\t\t\x3C\x2F\x78\x73\x6C\x3A\x65\x6C\x65\x6D\x65\x6E\x74\x3E\n\t\t\x3C\x2F\x78\x73\x6C\x3A\x69\x66\x3E\n\t\t\x3C\x68\x33\x3E\x41\x6E\x6E\x6F\x74\x61\x74\x69\x6F\x6E\x3C\x2F\x68\x33\x3E\n\t\t\x3C\x78\x73\x6C\x3A\x61\x70\x70\x6C\x79\x2D\x74\x65\x6D\x70\x6C\x61\x74\x65\x73\x2F\x3E\n\t\x3C\x2F\x78\x73\x6C\x3A\x74\x65\x6D\x70\x6C\x61\x74\x65\x3E\n\t\x3C\x21\x2D\x2D\x20\x65\x70\x69\x67\x72\x61\x70\x68\x20\x2D\x2D\x3E\n\t\x3C\x78\x73\x6C\x3A\x74\x65\x6D\x70\x6C\x61\x74\x65\x20\x6D\x61\x74\x63\x68\x3D\"\x66\x62\x3A\x65\x70\x69\x67\x72\x61\x70\x68\"\x3E\n\t\t\x3C\x62\x6C\x6F\x63\x6B\x71\x75\x6F\x74\x65\x20\x63\x6C\x61\x73\x73\x3D\"\x65\x70\x69\x67\x72\x61\x70\x68\"\x3E\n\t\t\t\x3C\x78\x73\x6C\x3A\x69\x66\x20\x74\x65\x73\x74\x3D\"\x40\x69\x64\"\x3E\n\t\t\t\t\x3C\x78\x73\x6C\x3A\x65\x6C\x65\x6D\x65\x6E\x74\x20\x6E\x61\x6D\x65\x3D\"\x61\"\x3E\n\t\t\t\t\t\x3C\x78\x73\x6C\x3A\x61\x74\x74\x72\x69\x62\x75\x74\x65\x20\x6E\x61\x6D\x65\x3D\"\x6E\x61\x6D\x65\"\x3E\x3C\x78\x73\x6C\x3A\x76\x61\x6C\x75\x65\x2D\x6F\x66\x20\x73\x65\x6C\x65\x63\x74\x3D\"\x40\x69\x64\"\x2F\x3E\x3C\x2F\x78\x73\x6C\x3A\x61\x74\x74\x72\x69\x62\x75\x74\x65\x3E\n\t\t\t\t\x3C\x2F\x78\x73\x6C\x3A\x65\x6C\x65\x6D\x65\x6E\x74\x3E\n\t\t\t\x3C\x2F\x78\x73\x6C\x3A\x69\x66\x3E\n\t\t\t\x3C\x78\x73\x6C\x3A\x61\x70\x70\x6C\x79\x2D\x74\x65\x6D\x70\x6C\x61\x74\x65\x73\x2F\x3E\n\t\t\x3C\x2F\x62\x6C\x6F\x63\x6B\x71\x75\x6F\x74\x65\x3E\n\t\x3C\x2F\x78\x73\x6C\x3A\x74\x65\x6D\x70\x6C\x61\x74\x65\x3E\n\t\x3C\x21\x2D\x2D\x20\x65\x70\x69\x67\x72\x61\x70\x68\x2F\x74\x65\x78\x74\x2D\x61\x75\x74\x68\x6F\x72\x20\x2D\x2D\x3E\n\t\x3C\x78\x73\x6C\x3A\x74\x65\x6D\x70\x6C\x61\x74\x65\x20\x6D\x61\x74\x63\x68\x3D\"\x66\x62\x3A\x65\x70\x69\x67\x72\x61\x70\x68\x2F\x66\x62\x3A\x74\x65\x78\x74\x2D\x61\x75\x74\x68\x6F\x72\"\x3E\n\t\t\x3C\x62\x6C\x6F\x63\x6B\x71\x75\x6F\x74\x65\x3E\n\t\t\t\x3C\x69\x3E\x3C\x78\x73\x6C\x3A\x61\x70\x70\x6C\x79\x2D\x74\x65\x6D\x70\x6C\x61\x74\x65\x73\x2F\x3E\x3C\x2F\x69\x3E\n\t\t\x3C\x2F\x62\x6C\x6F\x63\x6B\x71\x75\x6F\x74\x65\x3E\n\t\x3C\x2F\x78\x73\x6C\x3A\x74\x65\x6D\x70\x6C\x61\x74\x65\x3E\n\t\x3C\x21\x2D\x2D\x20\x63\x69\x74\x65\x20\x2D\x2D\x3E\n\t\x3C\x78\x73\x6C\x3A\x74\x65\x6D\x70\x6C\x61\x74\x65\x20\x6D\x61\x74\x63\x68\x3D\"\x66\x62\x3A\x63\x69\x74\x65\"\x3E\n\t\t\x3C\x62\x6C\x6F\x63\x6B\x71\x75\x6F\x74\x65\x3E\n\t\t\x3C\x78\x73\x6C\x3A\x69\x66\x20\x74\x65\x73\x74\x3D\"\x40\x69\x64\"\x3E\n\t\t\t\x3C\x78\x73\x6C\x3A\x65\x6C\x65\x6D\x65\x6E\x74\x20\x6E\x61\x6D\x65\x3D\"\x61\"\x3E\n\t\t\t\t\x3C\x78\x73\x6C\x3A\x61\x74\x74\x72\x69\x62\x75\x74\x65\x20\x6E\x61\x6D\x65\x3D\"\x6E\x61\x6D\x65\"\x3E\x3C\x78\x73\x6C\x3A\x76\x61\x6C\x75\x65\x2D\x6F\x66\x20\x73\x65\x6C\x65\x63\x74\x3D\"\x40\x69\x64\"\x2F\x3E\x3C\x2F\x78\x73\x6C\x3A\x61\x74\x74\x72\x69\x62\x75\x74\x65\x3E\n\t\t\t\x3C\x2F\x78\x73\x6C\x3A\x65\x6C\x65\x6D\x65\x6E\x74\x3E\n\t\t\x3C\x2F\x78\x73\x6C\x3A\x69\x66\x3E\n\t\t\x3C\x78\x73\x6C\x3A\x61\x70\x70\x6C\x79\x2D\x74\x65\x6D\x70\x6C\x61\x74\x65\x73\x2F\x3E\n\t\t\x3C\x2F\x62\x6C\x6F\x63\x6B\x71\x75\x6F\x74\x65\x3E\n\t\x3C\x2F\x78\x73\x6C\x3A\x74\x65\x6D\x70\x6C\x61\x74\x65\x3E\n\t\x3C\x21\x2D\x2D\x20\x63\x69\x74\x65\x2F\x74\x65\x78\x74\x2D\x61\x75\x74\x68\x6F\x72\x20\x2D\x2D\x3E\n\t\x3C\x78\x73\x6C\x3A\x74\x65\x6D\x70\x6C\x61\x74\x65\x20\x6D\x61\x74\x63\x68\x3D\"\x66\x62\x3A\x74\x65\x78\x74\x2D\x61\x75\x74\x68\x6F\x72\"\x3E\n\t\t\x3C\x62\x6C\x6F\x63\x6B\x71\x75\x6F\x74\x65\x3E\n\t\t\x3C\x69\x3E\t\x3C\x78\x73\x6C\x3A\x61\x70\x70\x6C\x79\x2D\x74\x65\x6D\x70\x6C\x61\x74\x65\x73\x2F\x3E\x3C\x2F\x69\x3E\x3C\x2F\x62\x6C\x6F\x63\x6B\x71\x75\x6F\x74\x65\x3E\n\t\x3C\x2F\x78\x73\x6C\x3A\x74\x65\x6D\x70\x6C\x61\x74\x65\x3E\n\t\x3C\x21\x2D\x2D\x20\x64\x61\x74\x65\x20\x2D\x2D\x3E\n\t\x3C\x78\x73\x6C\x3A\x74\x65\x6D\x70\x6C\x61\x74\x65\x20\x6D\x61\x74\x63\x68\x3D\"\x66\x62\x3A\x64\x61\x74\x65\"\x3E\n\t\t\x3C\x78\x73\x6C\x3A\x63\x68\x6F\x6F\x73\x65\x3E\n\t\t\t\x3C\x78\x73\x6C\x3A\x77\x68\x65\x6E\x20\x74\x65\x73\x74\x3D\"\x6E\x6F\x74\x28\x40\x76\x61\x6C\x75\x65\x29\"\x3E\n\t\t\t\t\x26\x23\x31\x36\x30\x3B\x26\x23\x31\x36\x30\x3B\x26\x23\x31\x36\x30\x3B\x3C\x78\x73\x6C\x3A\x61\x70\x70\x6C\x79\x2D\x74\x65\x6D\x70\x6C\x61\x74\x65\x73\x2F\x3E\n\t\t\t\t\x3C\x62\x72\x2F\x3E\n\t\t\t\x3C\x2F\x78\x73\x6C\x3A\x77\x68\x65\x6E\x3E\n\t\t\t\x3C\x78\x73\x6C\x3A\x6F\x74\x68\x65\x72\x77\x69\x73\x65\x3E\n\t\t\t\t\x26\x23\x31\x36\x30\x3B\x26\x23\x31\x36\x30\x3B\x26\x23\x31\x36\x30\x3B\x3C\x78\x73\x6C\x3A\x76\x61\x6C\x75\x65\x2D\x6F\x66\x20\x73\x65\x6C\x65\x63\x74\x3D\"\x40\x76\x61\x6C\x75\x65\"\x2F\x3E\n\t\t\t\t\x3C\x62\x72\x2F\x3E\n\t\t\t\x3C\x2F\x78\x73\x6C\x3A\x6F\x74\x68\x65\x72\x77\x69\x73\x65\x3E\n\t\t\x3C\x2F\x78\x73\x6C\x3A\x63\x68\x6F\x6F\x73\x65\x3E\n\t\x3C\x2F\x78\x73\x6C\x3A\x74\x65\x6D\x70\x6C\x61\x74\x65\x3E\n\t\x3C\x21\x2D\x2D\x20\x70\x6F\x65\x6D\x20\x2D\x2D\x3E\n\t\x3C\x78\x73\x6C\x3A\x74\x65\x6D\x70\x6C\x61\x74\x65\x20\x6D\x61\x74\x63\x68\x3D\"\x66\x62\x3A\x70\x6F\x65\x6D\"\x3E\n\t\t\x3C\x62\x6C\x6F\x63\x6B\x71\x75\x6F\x74\x65\x3E\n\t\t\t\x3C\x78\x73\x6C\x3A\x69\x66\x20\x74\x65\x73\x74\x3D\"\x40\x69\x64\"\x3E\n\t\t\t\t\x3C\x78\x73\x6C\x3A\x65\x6C\x65\x6D\x65\x6E\x74\x20\x6E\x61\x6D\x65\x3D\"\x61\"\x3E\n\t\t\t\t\t\x3C\x78\x73\x6C\x3A\x61\x74\x74\x72\x69\x62\x75\x74\x65\x20\x6E\x61\x6D\x65\x3D\"\x6E\x61\x6D\x65\"\x3E\x3C\x78\x73\x6C\x3A\x76\x61\x6C\x75\x65\x2D\x6F\x66\x20\x73\x65\x6C\x65\x63\x74\x3D\"\x40\x69\x64\"\x2F\x3E\x3C\x2F\x78\x73\x6C\x3A\x61\x74\x74\x72\x69\x62\x75\x74\x65\x3E\n\t\t\t\t\x3C\x2F\x78\x73\x6C\x3A\x65\x6C\x65\x6D\x65\x6E\x74\x3E\n\t\t\t\x3C\x2F\x78\x73\x6C\x3A\x69\x66\x3E\n\t\t\t\x3C\x78\x73\x6C\x3A\x61\x70\x70\x6C\x79\x2D\x74\x65\x6D\x70\x6C\x61\x74\x65\x73\x2F\x3E\n\t\t\x3C\x2F\x62\x6C\x6F\x63\x6B\x71\x75\x6F\x74\x65\x3E\n\t\x3C\x2F\x78\x73\x6C\x3A\x74\x65\x6D\x70\x6C\x61\x74\x65\x3E\n\n\t\x3C\x21\x2D\x2D\x20\x73\x74\x61\x6E\x7A\x61\x20\x2D\x2D\x3E\n\t\x3C\x78\x73\x6C\x3A\x74\x65\x6D\x70\x6C\x61\x74\x65\x20\x6D\x61\x74\x63\x68\x3D\"\x66\x62\x3A\x73\x74\x61\x6E\x7A\x61\"\x3E\n\t\t\x3C\x78\x73\x6C\x3A\x61\x70\x70\x6C\x79\x2D\x74\x65\x6D\x70\x6C\x61\x74\x65\x73\x2F\x3E\n\t\t\x3C\x62\x72\x2F\x3E\n\t\x3C\x2F\x78\x73\x6C\x3A\x74\x65\x6D\x70\x6C\x61\x74\x65\x3E\n\t\x3C\x21\x2D\x2D\x20\x76\x20\x2D\x2D\x3E\n\t\x3C\x78\x73\x6C\x3A\x74\x65\x6D\x70\x6C\x61\x74\x65\x20\x6D\x61\x74\x63\x68\x3D\"\x66\x62\x3A\x76\"\x3E\n\t\t\x3C\x78\x73\x6C\x3A\x69\x66\x20\x74\x65\x73\x74\x3D\"\x40\x69\x64\"\x3E\n\t\t\t\x3C\x78\x73\x6C\x3A\x65\x6C\x65\x6D\x65\x6E\x74\x20\x6E\x61\x6D\x65\x3D\"\x61\"\x3E\n\t\t\t\t\x3C\x78\x73\x6C\x3A\x61\x74\x74\x72\x69\x62\x75\x74\x65\x20\x6E\x61\x6D\x65\x3D\"\x6E\x61\x6D\x65\"\x3E\x3C\x78\x73\x6C\x3A\x76\x61\x6C\x75\x65\x2D\x6F\x66\x20\x73\x65\x6C\x65\x63\x74\x3D\"\x40\x69\x64\"\x2F\x3E\x3C\x2F\x78\x73\x6C\x3A\x61\x74\x74\x72\x69\x62\x75\x74\x65\x3E\n\t\t\t\x3C\x2F\x78\x73\x6C\x3A\x65\x6C\x65\x6D\x65\x6E\x74\x3E\n\t\t\x3C\x2F\x78\x73\x6C\x3A\x69\x66\x3E\n\t\t\x3C\x78\x73\x6C\x3A\x61\x70\x70\x6C\x79\x2D\x74\x65\x6D\x70\x6C\x61\x74\x65\x73\x2F\x3E\x3C\x62\x72\x2F\x3E\n\t\x3C\x2F\x78\x73\x6C\x3A\x74\x65\x6D\x70\x6C\x61\x74\x65\x3E\n\t\x3C\x21\x2D\x2D\x20\x69\x6D\x61\x67\x65\x20\x2D\x2D\x3E\n\t\x3C\x78\x73\x6C\x3A\x74\x65\x6D\x70\x6C\x61\x74\x65\x20\x6D\x61\x74\x63\x68\x3D\"\x66\x62\x3A\x69\x6D\x61\x67\x65\"\x20\x6E\x61\x6D\x65\x3D\"\x69\x6D\x61\x67\x65\"\x3E\n\t\t\x3C\x64\x69\x76\x20\x69\x64\x3D\"\x54\x4F\x43\x5F\x7B\x67\x65\x6E\x65\x72\x61\x74\x65\x2D\x69\x64\x28\x29\x7D\"\x20\x61\x6C\x69\x67\x6E\x3D\"\x63\x65\x6E\x74\x65\x72\"\x3E\n\t\t\t\x3C\x69\x6D\x67\x20\x62\x6F\x72\x64\x65\x72\x3D\"\x31\"\x3E\n\t\t\t\t\x3C\x78\x73\x6C\x3A\x63\x68\x6F\x6F\x73\x65\x3E\n\t\t\t\t\t\x3C\x78\x73\x6C\x3A\x77\x68\x65\x6E\x20\x74\x65\x73\x74\x3D\"\x73\x74\x61\x72\x74\x73\x2D\x77\x69\x74\x68\x28\x40\x78\x6C\x69\x6E\x6B\x3A\x68\x72\x65\x66\x2C\'\x23\'\x29\"\x3E\n\t\t\t\t\t\t\x3C\x78\x73\x6C\x3A\x61\x74\x74\x72\x69\x62\x75\x74\x65\x20\x6E\x61\x6D\x65\x3D\"\x73\x72\x63\"\x3E\x3C\x78\x73\x6C\x3A\x74\x65\x78\x74\x3E\x64\x61\x74\x61\x3A\x3C\x2F\x78\x73\x6C\x3A\x74\x65\x78\x74\x3E\x3C\x78\x73\x6C\x3A\x76\x61\x72\x69\x61\x62\x6C\x65\x20\x6E\x61\x6D\x65\x3D\"\x68\x72\x65\x66\"\x20\x73\x65\x6C\x65\x63\x74\x3D\"\x73\x75\x62\x73\x74\x72\x69\x6E\x67\x2D\x61\x66\x74\x65\x72\x28\x40\x78\x6C\x69\x6E\x6B\x3A\x68\x72\x65\x66\x2C\'\x23\'\x29\"\x20\x2F\x3E\x3C\x73\x65\x74\x20\x76\x61\x72\x69\x61\x62\x6C\x65\x3D\"\x68\x72\x65\x66\"\x20\x65\x78\x70\x72\x65\x73\x73\x69\x6F\x6E\x3D\"\x73\x75\x62\x73\x74\x72\x69\x6E\x67\x2D\x61\x66\x74\x65\x72\x28\x40\x78\x6C\x69\x6E\x6B\x3A\x68\x72\x65\x66\x2C\'\x23\'\x29\"\x2F\x3E\x3C\x78\x73\x6C\x3A\x76\x61\x6C\x75\x65\x2D\x6F\x66\x20\x73\x65\x6C\x65\x63\x74\x3D\"\x2F\x2F\x66\x62\x3A\x62\x69\x6E\x61\x72\x79\x5B\x40\x69\x64\x3D\x24\x68\x72\x65\x66\x5D\x2F\x40\x63\x6F\x6E\x74\x65\x6E\x74\x2D\x74\x79\x70\x65\"\x20\x64\x69\x73\x61\x62\x6C\x65\x2D\x6F\x75\x74\x70\x75\x74\x2D\x65\x73\x63\x61\x70\x69\x6E\x67\x3D\"\x79\x65\x73\"\x20\x2F\x3E\x3C\x78\x73\x6C\x3A\x74\x65\x78\x74\x3E\x3B\x62\x61\x73\x65\x36\x34\x2C\x3C\x2F\x78\x73\x6C\x3A\x74\x65\x78\x74\x3E\x3C\x21\x2D\x2D\x3C\x78\x73\x6C\x3A\x76\x61\x6C\x75\x65\x2D\x6F\x66\x20\x73\x65\x6C\x65\x63\x74\x3D\"\x73\x75\x62\x73\x74\x72\x69\x6E\x67\x2D\x61\x66\x74\x65\x72\x28\x40\x78\x6C\x69\x6E\x6B\x3A\x68\x72\x65\x66\x2C\'\x23\'\x29\"\x2F\x3E\x2D\x2D\x3E\x3C\x78\x73\x6C\x3A\x76\x61\x6C\x75\x65\x2D\x6F\x66\x20\x73\x65\x6C\x65\x63\x74\x3D\"\x2F\x2F\x66\x62\x3A\x62\x69\x6E\x61\x72\x79\x5B\x40\x69\x64\x3D\x24\x68\x72\x65\x66\x5D\"\x20\x20\x64\x69\x73\x61\x62\x6C\x65\x2D\x6F\x75\x74\x70\x75\x74\x2D\x65\x73\x63\x61\x70\x69\x6E\x67\x3D\"\x79\x65\x73\"\x2F\x3E\x3C\x2F\x78\x73\x6C\x3A\x61\x74\x74\x72\x69\x62\x75\x74\x65\x3E\n\n\t\t\t\t\t\x3C\x2F\x78\x73\x6C\x3A\x77\x68\x65\x6E\x3E\n\t\t\t\t\t\x3C\x78\x73\x6C\x3A\x6F\x74\x68\x65\x72\x77\x69\x73\x65\x3E\n\t\t\t\t\t\t\x3C\x78\x73\x6C\x3A\x61\x74\x74\x72\x69\x62\x75\x74\x65\x20\x6E\x61\x6D\x65\x3D\"\x73\x72\x63\"\x3E\x3C\x78\x73\x6C\x3A\x76\x61\x6C\x75\x65\x2D\x6F\x66\x20\x73\x65\x6C\x65\x63\x74\x3D\"\x40\x78\x6C\x69\x6E\x6B\x3A\x68\x72\x65\x66\"\x2F\x3E\x3C\x2F\x78\x73\x6C\x3A\x61\x74\x74\x72\x69\x62\x75\x74\x65\x3E\n\t\t\t\t\t\x3C\x2F\x78\x73\x6C\x3A\x6F\x74\x68\x65\x72\x77\x69\x73\x65\x3E\n\t\t\t\t\x3C\x2F\x78\x73\x6C\x3A\x63\x68\x6F\x6F\x73\x65\x3E\n\t\t\t\x3C\x2F\x69\x6D\x67\x3E\n\t\t\x3C\x2F\x64\x69\x76\x3E\n\t\x3C\x2F\x78\x73\x6C\x3A\x74\x65\x6D\x70\x6C\x61\x74\x65\x3E\n\x3C\x2F\x78\x73\x6C\x3A\x73\x74\x79\x6C\x65\x73\x68\x65\x65\x74\x3E",
        fb2xslb64:"data:text/xsl;base64,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"
        }
  }
);
