function reset() {
	$('#square_a').val("");
	$('#square_area').val("");

	$('#rect_a').val("");
	$('#rect_b').val("");
	$('#rect_area').val("");

	$('#parallelogram_b').val("");
	$('#parallelogram_h').val("");
	$('#parallelogram_area').val("");

	$('#trapezoid_b1').val("");
	$('#trapezoid_b2').val("");
	$('#trapezoid_h').val("");
	$('#trapezoid_area').val("");

	$('#triangle_b').val("");
	$('#triangle_h').val("");
	$('#triangle_area').val("");

	$('#equilateral_a').val("");
	$('#equilateral_area').val("");

	$('#circle_r').val("");
	$('#circle_area').val("");

	$('#ellipse_r1').val("");
	$('#ellipse_r2').val("");
	$('#ellipse_area').val("");
}

/* square begins */
function calculateSquareArea() {
	var a = $('#square_a').val();
	var area = $('#square_area').val();

	if(a == null || a == "") {
		return;
	}

	a = parseFloat(a);
	area = Math.pow(a, 2);

	$('#square_area').val(area);
}

function calculateSquareSide() {
	var a = $('#square_a').val();
	var area = $('#square_area').val();

	if(area == null || area == "") {
		return;
	}

	area = parseFloat(area);
	a = Math.sqrt(area);

	$('#square_a').val(a);
}
/* square ends */

/* rectangle begins */
function calculateRectArea() {
	var a = $('#rect_a').val();
	var b = $('#rect_b').val();

	var hasA = (a != null && a != "") ? true : false;
	var hasB = (b != null && b != "") ? true : false;

	a = parseFloat(a);
	b = parseFloat(b);

	if(hasA && hasB) {
		area = a * b;
		$('#rect_area').val(area);
	}
}

function calculateRectA() {
	var b = $('#rect_b').val();
	var area = $('#rect_area').val();

	var hasB = (b != null && b != "") ? true : false;
	var hasArea = (area != null && area != "") ? true : false;
	b = parseFloat(b);
	area = parseFloat(area);

	if(hasB && hasArea) {
		a = area / b;
		$('#rect_a').val(a);
	}
}

function calculateRectB() {
	var a = $('#rect_a').val();
	var area = $('#rect_area').val();

	var hasA = (a != null && a != "") ? true : false;
	var hasArea = (area != null && area != "") ? true : false;
	a = parseFloat(a);
	area = parseFloat(area);


	if(hasA && hasArea) {
		b = area / a;
		$('#rect_b').val(b);
	}
}
/* rectangle ends */

/* parallelogram begins */
function calculateParallelogramArea() {
	var b = $('#parallelogram_b').val();
	var h = $('#parallelogram_h').val();

	var hasB = (b != null && b != "") ? true : false;
	var hasH = (h != null && h != "") ? true : false;

	b = parseFloat(b);
	h = parseFloat(h);

	if(hasB && hasH) {
		area = b * h;
		$('#parallelogram_area').val(area);
	}
}

function calculateParallelogramB() {
	var h = $('#parallelogram_h').val();
	var area = $('#parallelogram_area').val();

	var hasH = (h != null && h != "") ? true : false;
	var hasArea = (area != null && area != "") ? true : false;

	h = parseFloat(h);
	area = parseFloat(area);

	if(hasH && hasArea) {
		b = area / h;
		$('#parallelogram_b').val(b);
	}
}

function calculateParallelogramH() {
	var b = $('#parallelogram_b').val();
	var area = $('#parallelogram_area').val();

	var hasB = (b != null && b != "") ? true : false;
	var hasArea = (area != null && area != "") ? true : false;

	b = parseFloat(b);
	area = parseFloat(area);

	if(hasB && hasArea) {
		h = area / b;
		$('#parallelogram_h').val(h);
	}
}
/* parallelogram ends */

/* trapezoid begins */
function calculateTrapezoid(mode) {
	var b1 = $('#trapezoid_b1').val();
	var b2 = $('#trapezoid_b2').val();
	var h = $('#trapezoid_h').val();
	var area = $('#trapezoid_area').val();

	var hasB1 = (b1 != null && b1 != "") ? true : false;
	var hasB2 = (b2 != null && b2 != "") ? true : false;
	var hasH = (h != null && h != "") ? true : false;
	var hasArea = (area != null && area != "") ? true : false;

	b1 = parseFloat(b1);
	b2 = parseFloat(b2);
	area = parseFloat(area);
	h = parseFloat(h);

	if(mode == 1 && hasB1 && hasB2 && hasH) {
		area = (b1 + b2) * h / 2;
		$('#trapezoid_area').val(area);
	} else if(mode == 4 && hasB1 && hasB2 && hasArea) {
		h = area * 2 / (b1 + b2);
		$('#trapezoid_h').val(h);
	} else if(mode == 3 && hasB1 && hasH && hasArea) {
		b2 = area * 2 / h - b1;
		$('#trapezoid_b2').val(b2);
	} else if(mode == 2 && hasB2 && hasH && hasArea) {
		b1 = area * 2 / h - b2;
		$('#trapezoid_b1').val(b1);
	}
}
/* trapezoid ends */

/* triangle begins */
function calculateTriangleArea() {
	var b = $('#triangle_b').val();
	var h = $('#triangle_h').val();

	if(b == null || b == "") {
		return;
	}

	if(h == null || h == "") {
		return;
	}

	b = parseFloat(b);
	h = parseFloat(h);
	area = b * h / 2;

	$('#triangle_area').val(area);
}

function calculateTriangleB() {
	var h = $('#triangle_h').val();
	var area = $('#triangle_area').val();

	var hasH = (h != null && h != "") ? true : false;
	var hasArea = (area != null && area != "") ? true : false;

	h = parseFloat(h);
	area = parseFloat(area);

	if(hasH && hasArea) {
		var b = area * 2 / h;
		$('#triangle_b').val(b);
	}
}

function calculateTriangleH() {
	var b = $('#triangle_b').val();
	var area = $('#triangle_area').val();

	var hasB = (b != null && b != "") ? true : false;
	var hasArea = (area != null && area != "") ? true : false;

	b = parseFloat(b);
	area = parseFloat(area);

	if(hasB && hasArea) {
		var h = area * 2 / b;
		$('#triangle_h').val(h);
	}
}
/* triangle ends */

/* equilateral begins */
function calculateEquilateralArea() {
	var a = $('#equilateral_a').val();
	var hasA = (a != null && a != "") ? true : false;
	a = parseFloat(a);

	if(hasA) {
		area = Math.sqrt(3) / 4 * Math.pow(a, 2);
		$('#equilateral_area').val(area);
	}
}

function calculateEquilateralB() {
	var area = $('#equilateral_area').val();
	var hasArea = (area != null && area != "") ? true : false;
	area = parseFloat(area);

	if(hasArea) {
		var a = Math.sqrt(area * 4 / Math.sqrt(3));
		$('#equilateral_a').val(a);
	}
}
/* equilateral ends */

/* circle begins */
function calculateCircleArea() {
	var r = $('#circle_r').val();
	var hasR = (r != null && r != "") ? true : false;
	r = parseFloat(r);

	if(hasR) {
		area = Math.PI * Math.pow(r, 2);
		$('#circle_area').val(area);
	}
}

function calculateCircleR() {
	var area = $('#circle_area').val();
	var hasArea = (area != null && area != "") ? true : false;
	area = parseFloat(area);

	if(hasArea) {
		var r = Math.sqrt(area / Math.PI);
		$('#circle_r').val(r);
	}
}
/* circle ends */

/* circle begins */
function calculateEllipseArea() {
	var r1 = $('#ellipse_r1').val();
	var r2 = $('#ellipse_r2').val();
	var hasR1 = (r1 != null && r1 != "") ? true : false;
	var hasR2 = (r2 != null && r2 != "") ? true : false;
	r1 = parseFloat(r1);
	r2 = parseFloat(r2);

	if(hasR1 && hasR2) {
		area = Math.PI * r1 * r2;
		$('#ellipse_area').val(area);
	}
}

function calculateEllipseR1() {
	var r2 = $('#ellipse_r2').val();
	var area = $('#ellipse_area').val();
	var hasR2 = (r2 != null && r2 != "") ? true : false;
	var hasArea = (area != null && area != "") ? true : false;
	r2 = parseFloat(r2);
	area = parseFloat(area);

	if(hasR2 && hasArea) {
		var r1 = area / Math.PI / r2;
		$('#ellipse_r1').val(r1);
	}
}

function calculateEllipseR2() {
	var r1 = $('#ellipse_r1').val();
	var area = $('#ellipse_area').val();
	var hasR1 = (r1 != null && r1 != "") ? true : false;
	var hasArea = (area != null && area != "") ? true : false;
	r1 = parseFloat(r1);
	area = parseFloat(area);

	if(hasR1 && hasArea) {
		var r2 = area / Math.PI / r1;
		$('#ellipse_r2').val(r2);
	}
}
/* circle ends */

$(function() {
	$('#square_a').keyup(function() {
		calculateSquareArea();
	});

	$('#square_area').keyup(function() {
		calculateSquareSide();
	});


	$('#submit_rect_area').click(function() {
		calculateRectArea();
	});

	$('#submit_rect_a').click(function() {
		calculateRectA();
	});

	$('#submit_rect_b').click(function() {
		calculateRectB();
	});


	$('#submit_parallelogram_area').click(function() {
		calculateParallelogramArea();
	});

	$('#submit_parallelogram_b').click(function() {
		calculateParallelogramB();
	});

	$('#submit_parallelogram_h').click(function() {
		calculateParallelogramH();
	});


	$('#submit_trapezoid_area').click(function() {
		calculateTrapezoid(1);
	});

	$('#submit_trapezoid_b1').click(function() {
		calculateTrapezoid(2);
	});

	$('#submit_trapezoid_b2').click(function() {
		calculateTrapezoid(3);
	});

	$('#submit_trapezoid_h').click(function() {
		calculateTrapezoid(4);
	});


	$('#submit_triangle_area').click(function() {
		calculateTriangleArea();
	});

	$('#submit_triangle_b').click(function() {
		calculateTriangleB();
	});

	$('#submit_triangle_h').click(function() {
		calculateTriangleH();
	});


	$('#equilateral_a').keyup(function() {
		calculateEquilateralArea();
	});

	$('#equilateral_area').keyup(function() {
		calculateEquilateralB();
	});


	$('#circle_r').keyup(function() {
		calculateCircleArea();
	});

	$('#circle_area').keyup(function() {
		calculateCircleR();
	});


	$('#submit_ellipse_area').click(function() {
		calculateEllipseArea();
	});

	$('#submit_ellipse_r1').click(function() {
		calculateEllipseR1();
	});

	$('#submit_ellipse_r2').click(function() {
		calculateEllipseR2();
	});


	$('.action_clear').click(function() {
		reset();
	});
});