/*object translation v2.0*/
function translateObj(options='') {
	this.defaultLang = options.defaultLang || 'en';
	this.lang = options.lang || '';
	this.res = new Array;

	//set and load resource for default language
	this.setDefaultLang(this.defaultLang);
	
	if (options.autoDetect) this.autoDetectLang();

	//define events
	this.translateAllEnd = options.onTranslateEnd || function() { console.log('event: end translate all')};
}

translateObj.prototype.setDefaultLang = function(lang) {
	this.defaultLang = lang;
	this.loadResource(lang);
}

translateObj.prototype.setLang = function(lang) {
	this.lang = lang;
	this.loadResource(lang);
}

translateObj.prototype.getLang = function(lang) {
	return this.lang;
}

translateObj.prototype.autoDetectLang = function() {
	var lang = navigator.language || navigator.userLanguage;
	lang = lang.substr(0,2);
	this.setLang(lang);
	return lang;
}

translateObj.prototype.loadResource = function(newLang) {
	resource = 'lng/' + newLang +  '.propeties';
	if (window.XMLHttpRequest) {// code for IE7+, Firefox, Chrome, Opera, Safari
		req=new XMLHttpRequest();
		
		req.overrideMimeType("text/plain");
		req.open("GET",resource,false);
		try{
			req.send();
			data=req.responseText;
			this.res[newLang] = JSON.parse('{' + data + '}');
			return true;
		}catch(err){
			//detect error
			console.log('Translation error: no load resource = ' + resource);
			return false;
		}
	}
}

translateObj.prototype.echo = function(cadena,args=null) {
	lang_obj = this.res[this.lang];
	
	if ((typeof lang_obj === "undefined")) {
		//console.log('no found resource ');
		lang_obj = this.res[this.defaultLang]; //set default language
	}
		
	if (typeof lang_obj[cadena] === "undefined") {
		//console.log('no found in resource ' + cadena);
		lang_obj = this.res[this.defaultLang]; //set default language
		if (!(typeof lang_obj[cadena] === "undefined")) {
			//check in default resource
			//console.log('found in alternative resource' + cadena);
			cadena = (lang_obj[cadena]);
		} else {
			//console.log('no found anywhere ' + cadena);
		}
	} else {
		//load in language resource
		//console.log('found in resource:' + cadena);
		cadena = (lang_obj[cadena]);
	}

	if (args != null) {
		//console.dir(args);	
		var i= 0;
		for(i=0;i<args.length;i++) {
			cadena = cadena.replace("%s", args[i]);
		}
	}
	return cadena;		
}

translateObj.prototype.getAllElementsWithAttribute = function(attribute) {
	var matchingElements = [];
	var allElements = document.getElementsByTagName('*');
	for (var i = 0, n = allElements.length; i < n; i++) {
		if (allElements[i].getAttribute(attribute)) {
			// Element exists with attribute. Add to array.
			matchingElements.push(allElements[i]);
		}
		
	} return matchingElements;
}

translateObj.prototype.initTranslate = function() {
	valor = this.getAllElementsWithAttribute('text-translate');
	var total = valor.length;
	for ( i=0; i < total; i++) {
		text2location = valor[i].getAttribute('text-translate');
		args = new Array();
		if (valor[i].getAttribute('data-value') !== null){
			args = valor[i].getAttribute('data-value');
			args = args.split(',');
		}

		valor[i].innerHTML = this.echo(text2location,args);
	}
	this.translateAllEnd();
}
/*
<span text-translate="line1" >line 1</span><br />
<span text-translate="line2">line 2</span><br />
<span text-translate="line1" data-value="1111,222" >line 1</span><br />
<span>hello world, your name is %s</span>
var trans = new translateObj({
	'defaultLang':'en',
	'autoDetect': false,
	'onTranslateEnd': function() {
		alert('init app');
	}

});
alert(trans.echo('line1',[1,2]));
trans.translateAll();
*/

