var acMain = new Activity("FireSketch","#page1",null);
var acInfo = new Activity("Information","#page2",acMain);
var screenW,sceenH;
var color="#000000";
var radius=20;
var step=-1;
var tool = "brush";
var hist = new Array();
var histLength = 20;
var drawn = false;

acMain.addCustomAction("Color","<span class='action'><a id='colorAction'></span></a>",function(){
	openColorBox();
});
acMain.addAction("Tools","img/brush.png",function(){
	hideOverlays();
	if(!$("#toolBox").is(":visible"))
		$("#toolBox").slideDown();
	$("#sizeCircle").css("width",(radius*2)+"px");
	$("#sizeCircle").css("height",(radius*2)+"px");
	$("#sizeCircle").css("background-color",color);
	$("#inRadius").val(radius);
});
acMain.addAction("Undo","img/undo.png",function(){
	var canvas = document.getElementById("mCanvas");
	if(step>0){
		step--;
		var newCanvas = hist[step];
		canvas.parentNode.replaceChild(newCanvas,canvas);
		newCanvas.addEventListener("touchmove", tMove, false);
		newCanvas.addEventListener("touchstart", tMove, false);
		newCanvas.addEventListener("touchend", saveHistory, false);
		hist.splice(step,1);
	}
},false);
acMain.addAction("Clear","img/clear.png",clearCanvas,false);
acMain.addAction("Save","img/save.png",saveCanvas,false);
acMain.addAction("About","img/ac_info.png",function(){
	hideOverlays();
	acInfo.start();
},false);

//var timer = setInterval(backup,5000);
//var oldURL;

acMain.onStart(function(){
	setTool($("#t_"+tool));
	setColor(color);
});

function backup(){
	var dataURL = document.getElementById("mCanvas").toDataURL();
	//MAYBE CHECK FOR CHANGES
	if(drawn){
		asyncStorage.setItem('canvas', dataURL, function() {
			console.log('backup');
			asyncStorage.setItem('bu', true);
		});
	}else{
		console.log('skipped backup (same dataURL or empty canvas)');
		drawn = false;
	}
}
function loadCanvas(dataURL) {
        var canvas = document.getElementById('mCanvas');
        var context = canvas.getContext('2d');

        // load image from data url
        var imageObj = new Image();
        imageObj.onload = function() {
          context.drawImage(this, 0, 0);
        };

        imageObj.src = dataURL;
      }

$(document).ready(function(){
	screenW = $(document).width(); 
	console.log(""+screenW);
	screenH = $(document).height()-53;
	acMain.start();
	
	//LOAD BACKUP
	asyncStorage.getItem('bu', function(value) {
		if(value==true){
			if(confirm("Do you want the recover your last sketch?")){
				asyncStorage.getItem('canvas', function(value) {
					loadCanvas(value);
					oldURL = value;
					console.log('Loaded last canvas');
				});
			}
			asyncStorage.setItem('bu',false);
		}
    });
	
	$("#page1").append("<canvas id='mCanvas' width='"+screenW+"' height='"+screenH+"'></canvas>");
	var el = document.getElementById("mCanvas");
	el.addEventListener("touchmove", tMove, false);
	el.addEventListener("touchstart", tMove, false);
	el.addEventListener("touchend", saveHistory, false);
	
	document.addEventListener("visibilitychange", function () {
		backup();
	});
	
	setTool($("#t_brush"));
	
	//COLOR CHANGE
	$("#flat").spectrum({
		flat: true,
		color: "#000000",
		showInput: true,
		showButtons: false,
		preferredFormat: "hex",
		move: function(c) {
			color = c.toHexString();
			$("#colorAction").css("backgroundColor",c);
		}
	});
	
	//TOOLBOX (TOOL select)
	$(".toolSelect").click(function(){
		setTool($(this));
	});
	
	$("#sizeCircle").click(function(){
		openColorBox();
	});
	
	//TOOLBOX SLIDER
	$("#inRadius").noUiSlider({
		 range: [1, 150]
		,start: 20
		,step: 1
		,handles: 1
		,serialization: {
			to: [ $("#txtRadius"), 'html' ]
		},
		slide:function(){
			var r = parseInt($(this).val());
			radius = r;
			$("#sizeCircle").css("width",(radius*2)+"px");
			$("#sizeCircle").css("height",(radius*2)+"px");
			$("#sizeCircle").css("background-color",color);
		}
	});
	
	//ZOOM
	$("#zoomP").click(function(){
		scaleCanvas(100);
	});
	$("#zoomM").click(function(){
		scaleCanvas(-100);
	});
	
	$(".action,.toolSelect").click(function(event) {
		event.preventDefault();
	});
	
});

function setColor(c){
	color = c;
	$("#colorAction").css("backgroundColor",c);
	$("#flat").spectrum("set",c);
}

function setTool(t){
	tool = t.attr("id").split("t_")[1];
	var img = t.find("img").attr("src");
	$("#ac-Tools a img").attr("src",img);
	$("."+t.attr("class")).css("border","3px solid #ddd");
	t.css("border","3px solid #000");
}

function openColorBox(){
	hideOverlays();
	if(!$("#colorBox").is(":visible"))
		$("#colorBox").slideDown();
}

var prevX=null,prevY=null;
function tMove(e){
	if(!drawn)
		drawn = true;
	e.preventDefault();
	if(!hideOverlays()){
		var touches = e.changedTouches;
		var offset = $( this ).offset();
		//Multitouch
		//for(var i=0;i<touches.length;i++){
			var x= touches[0].pageX - offset.left;
			var y = touches[0].pageY - offset.top;
			paint(x,y);
			prevX = x;
			prevY = y;
		//}
	}
}

function paint(x,y){
	var c=document.getElementById("mCanvas");
	var ctx=c.getContext("2d");
	ctx.globalCompositeOperation="source-over";
	ctx.lineCap = "round";
	ctx.lineWidth=(radius*2);
	switch(tool){
		case "brush":
			ctx.strokeStyle=color;
			ctx.beginPath();
			if(prevX)
				ctx.moveTo(prevX,prevY);
			else
				ctx.moveTo(x,y);
			ctx.lineTo(x,y);
			ctx.stroke();
			ctx.closePath();
			break;
		case "picker":
			data = ctx.getImageData(x, y, 1, 1).data;
			var r = data[0];
			var g = data[1];
			var b = data[2];
			setColor(rgbToHex(r,g,b));
			break;
		case "eraser":
			ctx.globalCompositeOperation = "destination-out";
			ctx.strokeStyle = "rgba(0,0,0,1)";
			ctx.beginPath();
			if(prevX)
				ctx.moveTo(prevX,prevY);
			else
				ctx.moveTo(x,y);
			ctx.lineTo(x,y);
			ctx.stroke();
			ctx.closePath();
			break;
	}
}

function hideOverlays(){
	var vis = false;
	if($("#colorBox").is(":visible")){
		$("#colorBox").slideUp();
		vis = true;
	}
	if($("#toolBox").is(":visible")){
		$("#toolBox").slideUp();
		vis = true;
	}
	if($("#overf").is(":visible")){
		$("#overf").fadeOut();
		vis = true;
	}
	return vis;
}

function clearCanvas(){
	var c=document.getElementById("mCanvas");
	var ctx=c.getContext("2d");
	ctx.clearRect(0, 0, c.width, c.height);
}

function scaleCanvas(scale){
	var cH = parseInt($("#mCanvas").css("height").split("px")[0]);
	$("#mCanvas").css("height",cH+scale);
	var cW = parseInt($("#mCanvas").css("width").split("px")[0]);
	offsetLeft = (screenW - cW)/2;
}

function saveCanvas(){
	var c=document.getElementById("mCanvas");
	var ctx=c.getContext("2d");
	var dataURL = c.toDataURL().replace(/^data:image\/(png|jpg);base64,/, "");

	var filename = prompt("Enter a filename");
	if(filename!=null){
		//SAVE
		var sdcard = navigator.getDeviceStorage("pictures");
		var file = base64toBlob(dataURL,"image/png");
		var request = sdcard.addNamed(file, filename+".png");

		request.onsuccess = function () {
		  var name = this.result;
		  alert('File "' + name + '" successfully saved');
		}

		// An error typically occur if a file with the same name already exist
		request.onerror = function () {
		  alert('Unable to write the file: ' + this.error.name);
		}
	}
}
function saveHistory(){
	prevX=null;
	prevY=null;
	//SAVE
	if(tool!="picker"){
		if(step<histLength){
			step++;
		}else{
			hist.splice(0,1);
		}
		hist.push(cloneCanvas(this));
	}
}

function cloneCanvas(oldCanvas) {

    //create a new canvas
    var newCanvas = document.createElement('canvas');
	newCanvas.setAttribute("id",oldCanvas.id);
    var context = newCanvas.getContext('2d');

    //set dimensions
    newCanvas.width = oldCanvas.width;
    newCanvas.height = oldCanvas.height;

    //apply the old canvas to the new one
    context.drawImage(oldCanvas, 0, 0);

    //return the new canvas
    return newCanvas;
}

function base64toBlob(base64Data, contentType) {
    contentType = contentType || '';
    var sliceSize = 1024;
    var byteCharacters = atob(base64Data);
    var bytesLength = byteCharacters.length;
    var slicesCount = Math.ceil(bytesLength / sliceSize);
    var byteArrays = new Array(slicesCount);

    for (var sliceIndex = 0; sliceIndex < slicesCount; ++sliceIndex) {
        var begin = sliceIndex * sliceSize;
        var end = Math.min(begin + sliceSize, bytesLength);

        var bytes = new Array(end - begin);
        for (var offset = begin, i = 0 ; offset < end; ++i, ++offset) {
            bytes[i] = byteCharacters[offset].charCodeAt(0);
        }
        byteArrays[sliceIndex] = new Uint8Array(bytes);
    }
    return new Blob(byteArrays, { type: contentType });
}

function componentToHex(c) {
    var hex = c.toString(16);
    return hex.length == 1 ? "0" + hex : hex;
}

function rgbToHex(r, g, b) {
    return "#" + componentToHex(r) + componentToHex(g) + componentToHex(b);
}