angular.module('templates.app', ['layout/headers/backable.tpl.html', 'layout/headers/basic.tpl.html', 'layout/view.tpl.html', 'modules/movie/details.tpl.html', 'modules/movie/list.tpl.html', 'modules/music/album.songs.tpl.html', 'modules/music/albums.tpl.html', 'modules/music/artist.albums.tpl.html', 'modules/music/artists.tpl.html', 'modules/music/musics.tpl.html', 'modules/music/songs.tpl.html', 'modules/navigation/navigation.tpl.html', 'modules/now/playing.tpl.html', 'modules/now/playlist.tpl.html', 'modules/remote/remote.tpl.html', 'modules/settings/hosts.tpl.html', 'modules/settings/wizard.tpl.html', 'modules/tvshow/details.tpl.html', 'modules/tvshow/episodes.tpl.html', 'modules/tvshow/list.tpl.html', 'modules/tvshow/seasons.tpl.html']);

angular.module("layout/headers/backable.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("layout/headers/backable.tpl.html",
    "<a ng-click=\"toggleDrawer()\"><i class=\"icon icon-reorder\"></i></a>\n" +
    "<a ng-click=\"back()\"><i class=\"icon icon-angle-left\"></i></a>");
}]);

angular.module("layout/headers/basic.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("layout/headers/basic.tpl.html",
    "<a ng-click=\"toggleDrawer();$event.stopPropagation();\"><i class=\"icon icon-reorder\"></i></a>");
}]);

angular.module("layout/view.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("layout/view.tpl.html",
    "<div ui-view>\n" +
    "</div>\n" +
    "");
}]);

angular.module("modules/movie/details.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("modules/movie/details.tpl.html",
    "<div ng-switch on=\"loading\" ng-class=\"{loading : loading}\">\n" +
    "    <div ng-switch-when=\"true\" class=\"loading\"><div class=\"foxy\"></div></div>\n" +
    "    <div class=\"movie detail\" ng-switch-when=\"false\">\n" +
    "        <div class=\"arts\">\n" +
    "            <div class=\"fanart\" image image-source=\"getImage(movie.fanart)\"></div>\n" +
    "            <div class=\"md-action md-action-primary\"\n" +
    "                 ng-click=\"play(movie)\" ng-show=\"!player.active\">\n" +
    "                <i class=\"icon-play\"></i>\n" +
    "            </div>\n" +
    "            <div class=\"md-action md-action-primary\"\n" +
    "                 ng-click=\"queue(movie)\" ng-show=\"player.active && !isCurrentlyPlaying\">\n" +
    "                <i class=\"icon-plus\"></i>\n" +
    "            </div>\n" +
    "            <div class=\"md-action md-action-primary\"\n" +
    "                 ng-click=\"xbmc.togglePlay()\" ng-show=\"player.active && isCurrentlyPlaying\">\n" +
    "                <i class=\"icon-play\" ng-show=\"!player.speed\"></i>\n" +
    "                <i class=\"icon-pause\" ng-show=\"player.speed\"></i>\n" +
    "            </div>\n" +
    "            <div class=\"poster-wrapper\">\n" +
    "                <img class=\" poster\" image image-source=\"getImage(movie.thumbnail || movie.poster, 'w185')\"/>\n" +
    "                <div class=\"preview\" ng-click=\"xbmc.open({'file': movie.trailer})\" ng-if=\"!isUsingExternalAddon()\">\n" +
    "                    <i class=\"icon-film\"></i>\n" +
    "                </div>\n" +
    "            </div>\n" +
    "            <streamdetails details=\"movie.streamdetails\" ng-if=\"hasAdditionalInfo()\"></streamdetails>\n" +
    "        </div>\n" +
    "        <h1>\n" +
    "            {{movie.title}}\n" +
    "        </h1>\n" +
    "        <div class=\"content\">\n" +
    "            <div class=\"row properties\">\n" +
    "                <div class=\"span3\">\n" +
    "                    <div class=\"md-circle clock\">\n" +
    "                        <i>{{movie.runtime | time | date:'HH:mm'}}</i>\n" +
    "                    </div>\n" +
    "                </div>\n" +
    "                <div class=\"span3\">\n" +
    "                    <div rating rating-value=\"movie.rating\" rating-max=\"10\"></div>\n" +
    "                </div>\n" +
    "                <div class=\"span3\">\n" +
    "                    <div class=\"md-circle movie genre\">\n" +
    "                        <i class=\"genre-{{movie.genre.join(' genre-').toLowerCase()}}\"></i>\n" +
    "                    </div>\n" +
    "                </div>\n" +
    "                <div class=\"span3\">\n" +
    "                    <div class=\"md-circle cast\" image image-source=\"getImage(movie.cast[0].thumbnail)\">\n" +
    "                    </div>\n" +
    "                </div>\n" +
    "            </div>\n" +
    "            <p class=\"plot\">{{movie.plot}}</p>\n" +
    "        </div>\n" +
    "    </div>\n" +
    "</div>");
}]);

angular.module("modules/movie/list.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("modules/movie/list.tpl.html",
    "<div ng-switch on=\"loading\" ng-class=\"{loading : loading}\">\n" +
    "    <div ng-switch-when=\"true\" class=\"loading\"><div class=\"foxy\"></div></div>\n" +
    "    <div class=\"view movies\" ng-switch-when=\"false\">\n" +
    "        <div class=\"arts\">\n" +
    "            <div class=\"banner\" image image-source=\"getImage(randomMovie.fanart,'img/backgrounds/banner.png')\">\n" +
    "            </div>\n" +
    "            <div class=\"md-action md-action-primary\"\n" +
    "                 ng-click=\"scan()\" ng-if=\"hasControls()\">\n" +
    "                <i class=\"icon-refresh\"></i>\n" +
    "            </div>\n" +
    "        </div>\n" +
    "        <div class=\"spinner\" ng-show=\"scanning\">\n" +
    "            <div class=\"bar\"></div>\n" +
    "        </div>\n" +
    "\n" +
    "        <ul data-type=\"list\" lr-infinite-scroll=\"loadMore\">\n" +
    "            <li class=\"row movie\" ng-repeat=\"movie in movies\"\n" +
    "                ng-click=\"go(getMoviesPath(movie))\">\n" +
    "                <div class=\"span3 flip-container\">\n" +
    "                    <flipper>\n" +
    "                        <div class=\"front\">\n" +
    "                            <div class=\"md-circle poster\" image image-source=\"getPoster(movie)\"></div>\n" +
    "                        </div>\n" +
    "                        <div class=\"back\" rating rating-value=\"movie.rating\" rating-max=\"10\"></div>\n" +
    "                    </flipper>\n" +
    "                </div>\n" +
    "                <div class=\"span8\">\n" +
    "                    <p>{{movie.label || movie.title}}</p>\n" +
    "                    <p ng-show=\"movie.genre\">{{movie.genre.join(', ')}}</p>\n" +
    "                    <p ng-show=\"!movie.genre\">{{movie.year}}</p>\n" +
    "                    <p class=\"clock\">\n" +
    "                        {{movie.runtime | time | date:'HH:mm'}}\n" +
    "                    </p>\n" +
    "                </div>\n" +
    "            </li>\n" +
    "        </ul>\n" +
    "        <div ng-show=\"!movies.length\" class=\"empty list\">Oops! nothing here</div>\n" +
    "        <spinner ng-show=\"fetching\"></spinner>\n" +
    "    </div>\n" +
    "</div>\n" +
    "\n" +
    "\n" +
    "");
}]);

angular.module("modules/music/album.songs.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("modules/music/album.songs.tpl.html",
    "<div ng-switch on=\"loading\" ng-class=\"{loading : loading}\">\n" +
    "    <div ng-switch-when=\"true\" class=\"loading\"><div class=\"foxy\"></div></div>\n" +
    "    <div class=\"artist\" ng-switch-when=\"false\">\n" +
    "      <div class=\"album arts\">\n" +
    "          <div class=\"banner\" image image-source=\"artist.fanart | asset:host | fallback:'img/backgrounds/banner.png'\"></div>\n" +
    "          <div class=\"md-action md-action-primary\" ng-click=\"xbmc.open({'albumid': songs[0].albumid})\">\n" +
    "              <i class=\"icon-plus\"></i>\n" +
    "          </div>\n" +
    "          <div class=\"span4 thumb\">\n" +
    "              <img class=\"vinyl\" src=\"img/backgrounds/vinyl.png\"/>\n" +
    "              <div class=\"cover\" image image-source=\"getCover(songs[0]) | fallback:'img/icons/foxy-512.png'\"></div>\n" +
    "          </div>\n" +
    "      </div>\n" +
    "      <div class=\"music album\" ng-include=\"'modules/music/songs.tpl.html'\"></div>\n" +
    "    </div>\n" +
    "  </div>\n" +
    "</div>");
}]);

angular.module("modules/music/albums.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("modules/music/albums.tpl.html",
    "<div ng-switch on=\"loading\" ng-class=\"{loading : loading}\">\n" +
    "    <div ng-switch-when=\"true\" class=\"loading\"><div class=\"foxy\"></div></div>\n" +
    "    <div ng-switch-when=\"false\">\n" +
    "        <ul data-type=\"list\" class=\"view albums\" lr-infinite-scroll=\"loadMore\">\n" +
    "            <li class=\"row album\" ng-repeat=\"album in albums\"\n" +
    "                ng-click=\"go('/music/songs/albumid/' + album.albumid)\">\n" +
    "                <div class=\"span3 flip-container\" ng-show=\"album.rating\">\n" +
    "                    <flipper>\n" +
    "                        <div class=\"front\">\n" +
    "                            <div class=\"md-circle poster\" image image-source=\"album.thumbnail | asset:host | fallback:'img/icons/foxy-512.png'\">\n" +
    "                            </div>\n" +
    "                        </div>\n" +
    "                        <div class=\"back\" rating rating-value=\"album.rating\" rating-max=\"10\"></div>\n" +
    "                    </flipper>\n" +
    "                </div>\n" +
    "                <div class=\"span3 wrapper\" ng-show=\"!album.rating\">\n" +
    "                    <div class=\"md-circle poster\" image image-source=\"album.thumbnail | asset:host | fallback:'img/icons/foxy-512.png'\">\n" +
    "                    </div>\n" +
    "                </div>\n" +
    "                <div class=\"span8\">\n" +
    "                    <p>{{album.label}}</p>\n" +
    "                    <p>{{album.artist.join(', ')}}</p>\n" +
    "                    <p>{{album.year}}</p>\n" +
    "                </div>\n" +
    "            </li>\n" +
    "        </ul>\n" +
    "        <div ng-show=\"!albums.length\" class=\"empty list\">Oops! nothing here</div>\n" +
    "        <spinner ng-show=\"fetching\"></spinner>\n" +
    "    </div>\n" +
    "</div>\n" +
    "\n" +
    "");
}]);

angular.module("modules/music/artist.albums.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("modules/music/artist.albums.tpl.html",
    "<div ng-switch on=\"loading\" ng-class=\"{loading : loading}\">\n" +
    "    <div ng-switch-when=\"true\" class=\"loading\"><div class=\"foxy\"></div></div>\n" +
    "    <div class=\"artist\" ng-switch-when=\"false\">\n" +
    "      <div class=\"arts\">\n" +
    "          <div class=\"banner\" image image-source=\"artist.fanart | asset:host | fallback:'img/backgrounds/banner.png'\"></div>\n" +
    "          <div class=\"md-action md-action-primary\" \n" +
    "               ng-click=\"xbmc.open({'artistid': artist.artistid})\">\n" +
    "              <i class=\"icon-plus\"></i>\n" +
    "          </div>\n" +
    "      </div>\n" +
    "      <div class=\"music\" ng-include=\"'modules/music/albums.tpl.html'\"></div>\n" +
    "    </div>\n" +
    "  </div>\n" +
    "</div>");
}]);

angular.module("modules/music/artists.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("modules/music/artists.tpl.html",
    "<div ng-switch on=\"loading\" ng-class=\"{loading : loading}\">\n" +
    "    <div ng-switch-when=\"true\" class=\"loading\"><div class=\"foxy\"></div></div>\n" +
    "    <div ng-switch-when=\"false\">\n" +
    "        <ul data-type=\"list\" class=\"view artists\" lr-infinite-scroll=\"loadMore\">\n" +
    "            <li class=\"row artist\" ng-repeat=\"artist in artists\"\n" +
    "                ng-click=\"go('/music/albums/artistid/' + artist.artistid)\">\n" +
    "                <div class=\"span3 wrapper\">\n" +
    "                    <div class=\"md-circle poster\" image image-source=\"artist.thumbnail | asset:host | fallback:'img/icons/foxy-512.png'\">\n" +
    "                    </div>\n" +
    "                </div>\n" +
    "                <div class=\"span8\">\n" +
    "                    <p>{{artist.label}}</p>\n" +
    "                    <p>{{artist.genre.join(', ')}}</p>\n" +
    "                </div>\n" +
    "            </li>\n" +
    "        </ul>\n" +
    "    </div>\n" +
    "    <div ng-show=\"!artists.length\" class=\"empty list\">Oops! nothing here</div>\n" +
    "    <spinner ng-show=\"fetching\"></spinner>\n" +
    "</div>\n" +
    "\n" +
    "\n" +
    "");
}]);

angular.module("modules/music/musics.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("modules/music/musics.tpl.html",
    "<div class=\"music\">\n" +
    "    <div class=\"arts\">\n" +
    "        <div class=\"banner\"></div>\n" +
    "        <div class=\"md-action md-action-primary\"\n" +
    "             ng-click=\"xbmc.open({'file' : undefined})\">\n" +
    "            <i class=\"icon-random\"></i>\n" +
    "        </div>\n" +
    "    </div>\n" +
    "    <div class=\"tabs row\">\n" +
    "        <a class=\"span4 tab\" ng-click=\"go('/musics/albums')\" ng-class=\"{selected : isSelected('music.albums')}\">Albums</a>\n" +
    "        <a class=\"span4 tab\" ng-click=\"go('/musics/artists')\" ng-class=\"{selected : isSelected('music.artists')}\">Artists</a>\n" +
    "        <a class=\"span4 tab\" ng-click=\"go('/musics/songs')\" ng-class=\"{selected : isSelected('music.songs')}\">Songs</a>\n" +
    "    </div>\n" +
    "    <div ui-view class=\"content\">\n" +
    "        \n" +
    "    </div>\n" +
    "</div>");
}]);

angular.module("modules/music/songs.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("modules/music/songs.tpl.html",
    "<div ng-switch on=\"loading\" ng-class=\"{loading : loading}\">\n" +
    "    <div ng-switch-when=\"true\" class=\"loading\"><div class=\"foxy\"></div></div>\n" +
    "    <div ng-switch-when=\"false\">\n" +
    "        <ul data-type=\"list\" class=\"view songs\" lr-infinite-scroll=\"loadMore\">\n" +
    "            <li class=\"row song\" ng-repeat=\"song in songs\"\n" +
    "                ng-click=\"play({songid : song.songid})\">\n" +
    "                <div class=\"span10\">\n" +
    "                    <p>{{song.label}}</p>\n" +
    "                    <p>{{song.artist.join(', ')}}</p>\n" +
    "                </div>\n" +
    "                <div class=\"span2\">\n" +
    "                    <p></p>\n" +
    "                    <p class=\"clock\">{{song.duration | time | date :'mm:ss'}}</p>\n" +
    "                </div>\n" +
    "            </li>\n" +
    "        </ul>\n" +
    "        <div ng-show=\"!songs.length\" class=\"empty list\">Oops! nothing here</div>\n" +
    "        <spinner ng-show=\"fetching\"></spinner>\n" +
    "    </div>\n" +
    "</div>");
}]);

angular.module("modules/navigation/navigation.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("modules/navigation/navigation.tpl.html",
    "<section data-type=\"sidebar\" id=\"drawer\" ng-class=\"{maximize : isMaximized}\">\n" +
    "    <header>\n" +
    "        <div class=\"arts\">\n" +
    "            <div class=\"row\">\n" +
    "                <div class=\"span3\" style=\"text-align : center;\">\n" +
    "                    <div class=\"md-circle status\" ng-class=\"{connected : connected, disconnected : !connected}\">\n" +
    "                        <i ng-class=\"{'icon-ok' : connected, 'icon-remove' : !connected}\"></i>\n" +
    "                    </div>\n" +
    "                </div>\n" +
    "                <h1 class=\"span9\" ng-switch on=\"connected\">\n" +
    "                    <div ng-switch-when=\"true\">\n" +
    "                        {{host.displayName}}\n" +
    "                    </div>\n" +
    "                    <div ng-switch-when=\"false\">\n" +
    "                        No connection\n" +
    "                    </div>\n" +
    "                </h1>\n" +
    "                <a ng-click=\"hideDrawer()\" class=\"collapse\">\n" +
    "                    <i class=\"icon icon-angle-left\"></i>\n" +
    "                </a>\n" +
    "            </div>\n" +
    "        </div>\n" +
    "    </header>\n" +
    "    <nav ng-class=\"{'active-player' : player.active, 'inactive-player': !player.active}\">\n" +
    "        <h2>Discover</h2>\n" +
    "        <ul>\n" +
    "            <li ng-repeat=\"item in discover\" class=\"row\"\n" +
    "                ng-click=\"go(item.hash)\" ng-class=\"{selected : isCurrent(item.hash)}\">\n" +
    "                <div class=\"span2\">\n" +
    "                    <i class=\"{{item.icon}}\"></i>\n" +
    "                </div>\n" +
    "                <div class=\"span9\">\n" +
    "                    {{item.label}}\n" +
    "                </div>\n" +
    "            </li>\n" +
    "        </ul>\n" +
    "        <h2>My content</h2>\n" +
    "        <ul>\n" +
    "            <li ng-repeat=\"item in medias\" class=\"row\"\n" +
    "                ng-click=\"go(item.hash)\" ng-class=\"{selected : isCurrent(item.hash)}\">\n" +
    "                <div class=\"span2\">\n" +
    "                    <i class=\"{{item.icon}}\"></i>\n" +
    "                </div>\n" +
    "                <div class=\"span9\">\n" +
    "                    {{item.label}}\n" +
    "                </div>\n" +
    "            </li>\n" +
    "            <li  ng-show=\"player.active\" class=\"row\"\n" +
    "                 ng-click=\"go('/now/playing')\" ng-class=\"{selected :isCurrent('/now/playing')}\">\n" +
    "                <div class=\"span2\">\n" +
    "                    <i class=\"icon-youtube-play\"></i>\n" +
    "                </div>\n" +
    "                <div class=\"span9\">\n" +
    "                    Now playing\n" +
    "                </div>\n" +
    "            </li>\n" +
    "            <li ng-show=\"player.active\" class=\"row\"\n" +
    "                ng-click=\"go('/now/playlist')\" ng-class=\"{selected :isCurrent('/now/playlist')}\">\n" +
    "                <div class=\"span2\">\n" +
    "                    <i class=\"icon-glass\"></i>\n" +
    "                </div>\n" +
    "                <div class=\"span9\">\n" +
    "                    Queue\n" +
    "                </div>\n" +
    "            </li>\n" +
    "            <li ng-repeat=\"item in controls\" class=\"row\"\n" +
    "                ng-click=\"go(item.hash)\" ng-class=\"{selected :isCurrent(item.hash)}\">\n" +
    "                <div class=\"span2\">\n" +
    "                    <i class=\"{{item.icon}}\"></i>\n" +
    "                </div>\n" +
    "                <div class=\"span9\">\n" +
    "                    {{item.label}}\n" +
    "                </div>\n" +
    "            </li>\n" +
    "            <li  class=\"row\" ng-click=\"toggleTheme()\">\n" +
    "                <div class=\"span2\">\n" +
    "                    <i class=\"icon-exchange\"></i>\n" +
    "                </div>\n" +
    "                <div class=\"span9\">\n" +
    "                    Switch theme\n" +
    "                </div>\n" +
    "            </li>\n" +
    "        </ul>\n" +
    "    </nav>\n" +
    "\n" +
    "    <a href=\"https://twitter.com/foxmoteapp\" class=\"twitter-wrapper\" target=\"_blank\">\n" +
    "      <i class=\"icon-twitter\"></i>\n" +
    "      Follow us on twitter\n" +
    "    </a>\n" +
    "    <div class=\"now playing\" ng-show=\"player.active\">\n" +
    "        <seekbar seekbar-value=\"player.seek.percentage\" seekbar-max=\"100\" seekbar-read-only=\"true\"></seekbar>\n" +
    "        <div class=\"row\">\n" +
    "            <div ng-switch on=\"hasPoster(player.item.art)\">\n" +
    "                <div ng-switch-when=\"true\" ng-click=\"go('/now/playing','none')\">\n" +
    "                    <div class=\"span3 poster-wrapper\" >\n" +
    "                        <div class=\"md-circle poster\" image image-source=\"player.item.art | thumb  | asset:host | fallback:'img/icons/foxy-512.png'\"></div>\n" +
    "                    </div>\n" +
    "                </div>\n" +
    "            </div>\n" +
    "            <div class=\"title\" ng-class=\"{span7 : hasPoster(player.item.art), span9 : !hasPoster(player.item.art)}\">\n" +
    "                {{getLabel(player.item)}}\n" +
    "            </div>\n" +
    "            <div class=\"span2 actions\">\n" +
    "                <div class=\"offset4 span4 icon-play\" ng-click=\"xbmc.togglePlay()\"  ng-show=\"!player.speed\">\n" +
    "                </div>\n" +
    "                <div class=\"offset4 span4 icon-pause\" ng-click=\"xbmc.togglePlay()\"  ng-show=\"player.speed\">\n" +
    "                </div>\n" +
    "            </div>\n" +
    "        </div>\n" +
    "    </div>\n" +
    "</section>");
}]);

angular.module("modules/now/playing.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("modules/now/playing.tpl.html",
    "<div ng-switch on=\"loading\" ng-class=\"{loading : loading, now : !loading}\">\n" +
    "    <div ng-switch-when=\"true\" class=\"loading\"><div class=\"foxy\"></div></div>\n" +
    "    <div ng-switch-when=\"false\">\n" +
    "        <div ng-switch on=\"library.item.type\" class=\"playing\">\n" +
    "            <div ng-switch-when=\"movie\">\n" +
    "                <div ng-include src=\"'modules/movie/details.tpl.html'\"></div>\n" +
    "            </div>\n" +
    "\n" +
    "            <div ng-switch-when=\"episode\">\n" +
    "                <div ng-include src=\"'modules/tvshow/details.tpl.html'\"></div>\n" +
    "            </div>\n" +
    "\n" +
    "            <div ng-switch-default class=\"detail\">\n" +
    "                <img class=\"row\" image image-source=\"library.item.thumbnail | asset:host | fallback:'img/icons/foxy-512.png'\"/>\n" +
    "                <h1>\n" +
    "                    {{library.item.label}}\n" +
    "                </h1>\n" +
    "            </div>\n" +
    "        </div>\n" +
    "        <div class=\"player\">\n" +
    "            <div class=\"row controls\">\n" +
    "                <div class=\"span3 action\" ng-click=\"toggleAudioStreams()\" ng-show=\"isTypeVideo()\">\n" +
    "                    <i class=\"icon-comments\"></i>\n" +
    "                </div>\n" +
    "                <div class=\"times\" ng-click=\"toggleTimePicker()\" ng-class=\"{span6 : isTypeVideo(), span12 : !isTypeVideo()}\">\n" +
    "                    {{player.seek.time | time | date:'HH:mm:ss'}}/\n" +
    "                    {{player.seek.totaltime | time | date:'HH:mm:ss'}}\n" +
    "                    [-{{(player.seek.totaltime - player.seek.time)  | time | date:'HH:mm:ss'}}]\n" +
    "                </div>\n" +
    "                <div class=\"span3 action\" ng-click=\"toggleSubtitles()\" ng-show=\"isTypeVideo()\">\n" +
    "                    <i class=\"icon-quote-left\"></i>\n" +
    "                </div>\n" +
    "            </div>\n" +
    "            <seekbar seekbar-value=\"player.seek.percentage\" seekbar-max=\"100\"\n" +
    "                         on-seekbar-changed=\"onSeekbarChanged(newValue)\"></seekbar>\n" +
    "            <div class=\"row controls\">\n" +
    "                <div class=\"span3\" ng-click=\"xbmc.previous()\">\n" +
    "                    <i class=\"icon-fast-backward\"></i>\n" +
    "                </div>\n" +
    "                <div class=\"span3\" ng-click=\"xbmc.togglePlay()\">\n" +
    "                    <i class=\"icon-play\" ng-show=\"!player.speed\"></i>\n" +
    "                    <i class=\"icon-pause\" ng-show=\"player.speed\"></i>\n" +
    "                </div>\n" +
    "                <div class=\"span3\" ng-click=\"xbmc.stop()\">\n" +
    "                    <i class=\"icon-stop\"></i>\n" +
    "                </div>\n" +
    "                <div class=\"span3\" ng-click=\"xbmc.next()\">\n" +
    "                    <i class=\"icon-fast-forward\"></i>\n" +
    "                </div>\n" +
    "            </div>\n" +
    "        </div>\n" +
    "    </div>\n" +
    "</div>\n" +
    "\n" +
    "<form role=\"dialog\" data-type=\"action\" class=\"chooser\" onsubmit=\"return false;\" ng-show=\"showAudioSelect\">\n" +
    "     <div class=\"content\">\n" +
    "        <header> Audio Streams </header>\n" +
    "        <div class=\"body\">\n" +
    "            <label ng-repeat=\"audiostream in player.audiostreams\">\n" +
    "                <input type=\"radio\" ng-model=\"stream\" ng-value=\"audiostream.index\" name=\"audiostreams\"/>\n" +
    "                {{audiostream.name}} ( {{audiostream.language}})\n" +
    "            </label>\n" +
    "        </div>\n" +
    "        <div class=\"actions\">\n" +
    "            <button ng-click=\"toggleAudioStreams()\"> Cancel </button>\n" +
    "            <button class=\"recommend\" ng-click=\"onValidateAudioStream()\"> Ok </button>\n" +
    "        </div>\n" +
    "    </div>\n" +
    "</form>\n" +
    "\n" +
    "<form role=\"dialog\" data-type=\"action\" class=\"chooser\" onsubmit=\"return false;\" ng-show=\"showSubtitleSelect\">\n" +
    "     <div class=\"content\">\n" +
    "        <header> Subtitles </header>\n" +
    "        <div class=\"body\">\n" +
    "            <label>\n" +
    "                <input type=\"radio\" ng-model=\"sub\" value=\"off\" name=\"subtitles\"/>\n" +
    "                None\n" +
    "            </label>\n" +
    "            <label ng-repeat=\"subtitle in player.subtitles\">\n" +
    "                <input type=\"radio\" ng-model=\"sub\" ng-value=\"subtitle.index\" name=\"subtitles\"/>\n" +
    "                {{subtitle.name}} ({{subtitle.language}})\n" +
    "            </label>\n" +
    "        </div>\n" +
    "        <div class=\"actions\">\n" +
    "            <button ng-click=\"toggleSubtitles()\"> Cancel </button>\n" +
    "            <button class=\"recommend\" ng-click=\"onValidateSubtitles()\"> Ok </button>\n" +
    "        </div>\n" +
    "    </div>\n" +
    "</form>\n" +
    "\n" +
    "<form role=\"dialog\" data-type=\"action\" class=\"chooser\" onsubmit=\"return false;\" ng-show=\"showTimePicker\">\n" +
    "    <div class=\"content\">\n" +
    "        <header>Select time </header>\n" +
    "        <div class=\"body\">\n" +
    "            <div class=\"time\">\n" +
    "                <div ng-model=\"seekTime\" class=\"picker\">\n" +
    "                  <timepicker hour-step=\"1\" minute-step=\"1\" show-meridian=\"false\"></timepicker>\n" +
    "                </div>\n" +
    "            </div>\n" +
    "        </div>\n" +
    "        <div class=\"actions\">\n" +
    "            <button  ng-click=\"toggleTimePicker()\"> Cancel </button>\n" +
    "            <button class=\"recommend\" ng-click=\"onValidateSeekTime()\"> Ok </button>\n" +
    "        </div>\n" +
    "    </div>\n" +
    "</form>");
}]);

angular.module("modules/now/playlist.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("modules/now/playlist.tpl.html",
    "<div ng-switch on=\"loading\" class=\"now\" ng-class=\"{loading : loading}\">\n" +
    "    <div ng-switch-when=\"true\" class=\"loading\"><div class=\"foxy\"></div></div>\n" +
    "    <div ng-switch-when=\"false\">\n" +
    "        <div class=\"arts\">\n" +
    "            <div class=\"banner\" image image-source=\"items[0].fanart | asset:host  | fallback:'img/backgrounds/banner.png'\">\n" +
    "            </div>\n" +
    "            <div class=\"md-action md-action-primary\" ng-click=\"xbmc.next()\">\n" +
    "                    <i class=\"icon-fast-forward\"></i>\n" +
    "            </div>\n" +
    "        </div>\n" +
    "        <ul data-type=\"list\" class=\"view songs\">\n" +
    "            <li class=\"row \" ng-repeat=\"item in items\"\n" +
    "                ng-click=\"xbmc.goTo($index)\">\n" +
    "                <div class=\"span3 flip-container\">\n" +
    "                    <flipper>\n" +
    "                        <div class=\"front\">\n" +
    "                            <div class=\"md-circle poster\" image image-source=\"item.art | thumb | asset:host | fallback:'img/icons/foxy-512.png'\"></div>\n" +
    "                        </div>\n" +
    "                        <div class=\"back\" rating rating-value=\"item.rating\" rating-max=\"10\" ng-if=\"item.rating\"></div>\n" +
    "                        <div class=\"back\" ng-if=\"!item.rating\">\n" +
    "                            <div class=\"md-circle rating\">\n" +
    "                                <div class=\"value ng-binding\">-</div>\n" +
    "                                <i class=\"star icon-star left\"></i>\n" +
    "                                <i class=\"star icon-star middle\"></i>\n" +
    "                                <i class=\"star icon-star right\"></i>\n" +
    "                            </div>\n" +
    "                        </div>\n" +
    "                    </flipper>\n" +
    "                </div>\n" +
    "                <div class=\"span8\">\n" +
    "                    <p>{{item.label}}</p>\n" +
    "                    <p ng-show=\"item.duration\">{{item.duration | time | date :'mm:ss'}}</p>\n" +
    "                    <p ng-show=\"item.runtime\">{{item.runtime| time | date :'hh:mm:ss'}}</p>\n" +
    "                    <img class=\"equalizer\" src=\"img/backgrounds/equalizer.gif\" ng-show=\"isPlaying(item.id)\"/>\n" +
    "                </div>\n" +
    "            </li>\n" +
    "        </ul>\n" +
    "        <div ng-show=\"!items.length\" class=\"empty list\">Oops! nothing here</div>\n" +
    "    </div>\n" +
    "</div>");
}]);

angular.module("modules/remote/remote.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("modules/remote/remote.tpl.html",
    "<div class=\"remote\">\n" +
    "    <div class=\"arts\">\n" +
    "        <div ng-switch on=\"player.active\">\n" +
    "            <div ng-switch-when=\"true\">\n" +
    "                <div class=\"banner\" image image-source=\"player.item.fanart | asset:host\"></div>\n" +
    "                <seekbar seekbar-value=\"player.seek.percentage\" seekbar-max=\"100\" seekbar-read-only=\"true\"></seekbar>\n" +
    "                <div class=\"label\">{{player.item.label}}</div>\n" +
    "                <div class=\"md-action md-action-primary\" ng-click=\"xbmc.togglePlay()\" ng-show=\"!player.speed\">\n" +
    "                    <i class=\"offset4 span4 icon-play\">\n" +
    "                    </i>\n" +
    "                </div>\n" +
    "                <div class=\"md-action md-action-primary\" ng-click=\"xbmc.togglePlay()\"  ng-show=\"player.speed\">\n" +
    "                    <i class=\"offset4 span4 icon-pause\">\n" +
    "                    </i>\n" +
    "                </div>\n" +
    "            </div>\n" +
    "            <div ng-switch-when=\"false\">\n" +
    "                <div class=\"banner\"></div>\n" +
    "                <div class=\"md-action md-action-primary\" ng-click=\"toggleShutdownOptions()\">\n" +
    "                    <i class=\"icon icon-power-off\"></i>\n" +
    "                </div>\n" +
    "            </div>\n" +
    "        </div>\n" +
    "    </div>\n" +
    "    <div class=\"buttons\">\n" +
    "        <div class=\"row\">\n" +
    "            <div class=\"action\">\n" +
    "                <div class=\"md-action\"  ng-click=\"xbmc.contextmenu()\">\n" +
    "                    <i class=\"icon icon-list-ul\"></i>\n" +
    "                </div>\n" +
    "            </div>\n" +
    "            <div class=\"action\">\n" +
    "                <div class=\"md-action\"  ng-click=\"xbmc.info()\">\n" +
    "                    <i class=\"icon icon-info-sign\"></i>\n" +
    "                </div>\n" +
    "            </div>\n" +
    "            <div class=\"action\">\n" +
    "                <div class=\"md-action\" ng-click=\"xbmc.showOSD()\">\n" +
    "                    <i class=\"icon icon-ellipsis-horizontal\"></i>\n" +
    "                </div>\n" +
    "            </div>\n" +
    "        </div>\n" +
    "        <div class=\"row\">\n" +
    "            <div class=\"action\">\n" +
    "                <div class=\"md-action\" ng-click=\"xbmc.previous()\">\n" +
    "                    <i class=\"icon icon-fast-backward\"></i>\n" +
    "                </div>\n" +
    "            </div>\n" +
    "            <div class=\"action\">\n" +
    "                <div class=\"md-action\" ng-click=\"xbmc.stop()\">\n" +
    "                    <i class=\"icon icon-stop\"></i>\n" +
    "                </div>\n" +
    "            </div>\n" +
    "            <div class=\"action\">\n" +
    "               <div class=\"md-action\" ng-click=\"xbmc.next()\"> \n" +
    "                    <i class=\"icon icon-fast-forward\"></i>\n" +
    "                </div>\n" +
    "            </div>\n" +
    "        </div>\n" +
    "        <div class=\"row\">\n" +
    "            <div class=\"action\">\n" +
    "                <div class=\"md-action\" ng-hold=\"xbmc.decreaseVolume(application.volume)\">\n" +
    "                    <i class=\"icon icon-volume-down\"></i>\n" +
    "                </div>\n" +
    "            </div>\n" +
    "            <div class=\"action\">\n" +
    "                <div class=\"md-action direction\"  ng-click=\"xbmc.up()\">\n" +
    "                    <i class=\"icon icon-chevron-up\"></i>\n" +
    "                </div>\n" +
    "            </div>\n" +
    "            <div class=\"action\">\n" +
    "                <div class=\"md-action\" ng-hold=\"xbmc.increaseVolume(application.volume)\" >\n" +
    "                    <i class=\"icon icon-volume-up\"></i>\n" +
    "                </div>\n" +
    "            </div>\n" +
    "        </div>\n" +
    "        <div class=\"row\">\n" +
    "            <div class=\"action\">\n" +
    "                <div class=\"md-action direction\" ng-click=\"xbmc.left()\">\n" +
    "                    <i class=\"icon icon-chevron-left\"></i>\n" +
    "                </div>\n" +
    "            </div>\n" +
    "            <div class=\"action\">\n" +
    "                <div class=\"md-action select\" ng-click=\"xbmc.select()\">\n" +
    "                    <i class=\"icon icon-circle\"></i>\n" +
    "                </div>\n" +
    "            </div>\n" +
    "            <div class=\"action\">\n" +
    "                <div class=\"md-action direction\" ng-click=\"xbmc.right()\">\n" +
    "                    <i class=\"icon icon-chevron-right\"></i>\n" +
    "                </div>\n" +
    "            </div>\n" +
    "        </div>\n" +
    "        <div class=\"row\">\n" +
    "            <div class=\"action\">\n" +
    "                <div class=\"md-action\" ng-click=\"xbmc.back()\">\n" +
    "                    <i class=\"icon icon-mail-reply\"></i>\n" +
    "                </div>\n" +
    "            </div>\n" +
    "            <div class=\"action\">\n" +
    "                <div class=\"md-action direction\" ng-click=\"xbmc.down()\">\n" +
    "                    <i class=\"icon icon-chevron-down\"></i>\n" +
    "                </div>\n" +
    "            </div>\n" +
    "            <div class=\"action\">\n" +
    "               <div class=\"md-action\" ng-click=\"toggleKeyboard()\">\n" +
    "                    <i class=\"icon icon-keyboard\"></i>\n" +
    "                </div>\n" +
    "            </div>\n" +
    "        </div>\n" +
    "\n" +
    "    </div>\n" +
    "</div>\n" +
    "\n" +
    "<form role=\"dialog\" data-type=\"action\" class=\"chooser\" onsubmit=\"return false;\" ng-show=\"showKeyboard\">\n" +
    "    <div class=\"content\">\n" +
    "        <header>Send text</header>\n" +
    "        <div class=\"body\">\n" +
    "            <textarea class=\"offset1 span10\" ng-model=\"textToSend\"\n" +
    "                          placeholder=\"Text to send\"></textarea>\n" +
    "        </div>\n" +
    "        <div class=\"actions\">\n" +
    "            <button ng-click=\"toggleKeyboard()\"> Cancel </button>\n" +
    "            <button class=\"recommend\"   ng-click=\"onValidateText()\"> Ok </button>\n" +
    "        </div>\n" +
    "    </div>\n" +
    "</form>\n" +
    "\n" +
    "<form role=\"dialog\" data-type=\"action\" class=\"chooser\" onsubmit=\"return false;\" ng-show=\"showShutdownOptions\">\n" +
    "    <div class=\"content\">\n" +
    "        <header>System</header>\n" +
    "        <div class=\"body\">\n" +
    "            <button class=\"command\" ng-click=\"execCommand('shutdown')\">Power off</button>\n" +
    "            <button class=\"command\" ng-click=\"execCommand('hibernate')\">Hibernate</button>\n" +
    "            <button class=\"command\" ng-click=\"execCommand('suspend')\">Suspend</button>\n" +
    "            <button class=\"command\" ng-click=\"execCommand('reboot')\">Reboot</button>\n" +
    "        </div>\n" +
    "        <div class=\"actions\">\n" +
    "            <button ng-click=\"toggleShutdownOptions()\">Cancel</button>\n" +
    "        </div>\n" +
    "    </div>\n" +
    "</form>\n" +
    "\n" +
    "\n" +
    "");
}]);

angular.module("modules/settings/hosts.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("modules/settings/hosts.tpl.html",
    "\n" +
    "<div class=\"hosts\">\n" +
    "  <div class=\"arts\">\n" +
    "      <div class=\"banner\"></div>\n" +
    "      <div class=\"md-action md-action-primary\" ng-click=\"go('/host/wizard')\" ng-show=\"!hasSelected\">\n" +
    "          <i class=\"icon-plus\"></i>\n" +
    "      </div>\n" +
    "      <div class=\"md-action md-action-primary\" ng-click=\"setAsDefault()\" ng-show=\"hasSelected\">\n" +
    "          <i class=\"icon-ok\"></i>\n" +
    "      </div>\n" +
    "  </div>\n" +
    "  <ul data-type=\"list\">\n" +
    "      <li class=\"row host\" ng-repeat=\"host in hosts\"\n" +
    "          ng-click=\"go('/host/' + $index)\">\n" +
    "          <div ng-switch on=\"host.default\">\n" +
    "            <div ng-switch-when=\"true\" class=\"span3 wrapper\">\n" +
    "              <div class=\"md-action md-action-primary poster\">\n" +
    "                <i class=\"icon-ok\"></i>\n" +
    "              </div> \n" +
    "            </div>\n" +
    "            <div ng-switch-when=\"false\" class=\"span3 flip-container\" ng-click=\"setAsDefault(host);$event.stopPropagation();\">\n" +
    "              <flipper>\n" +
    "                <div class=\"md-circle poster front\" image image-source=\"host.thumbnail | asset:host| fallback:'img/icons/foxy-512.png'\">\n" +
    "                </div>\n" +
    "                <div class=\"md-action md-action-primary poster back\" >\n" +
    "                  <i class=\"icon-ok\"></i>\n" +
    "                </div>   \n" +
    "              </flipper>\n" +
    "            </div>\n" +
    "          <div class=\"span8\">\n" +
    "              <p>{{host.displayName}}</p>\n" +
    "              <p>{{host.ip}}</p>\n" +
    "          </div>\n" +
    "      </li>\n" +
    "      <li ng-show=\"!hosts.length\" class=\"empty list\">Oops! There is no host yet configured. Use the <i class=\"icon-plus\"></i> icon to get started.</li>\n" +
    "  </ul>\n" +
    "</div>\n" +
    "");
}]);

angular.module("modules/settings/wizard.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("modules/settings/wizard.tpl.html",
    "\n" +
    "<form class=\"wizard\" name=\"wizard\" >\n" +
    "    <div class=\"arts\">\n" +
    "        <div class=\"banner\"></div>\n" +
    "        <div class=\"md-action md-action-primary\" ng-click=\"save()\">\n" +
    "            <i class=\"icon-save\"></i>\n" +
    "        </div>\n" +
    "    </div>\n" +
    "    <div class=\"settings\">\n" +
    "        <p> \n" +
    "            <label>Display name:</label>\n" +
    "            <input type=\"text\" placeholder=\"Ex : HTPC\" required=\"\" ng-model=\"host.displayName\" tabindex=\"1\">\n" +
    "            <button type=\"reset\" class=\"icon-remove\"></button>\n" +
    "        </p>\n" +
    "        <div class=\"row\">\n" +
    "            <p class=\"span7\">\n" +
    "                <label>Host IP:</label>\n" +
    "                <input name=\"ip\" type=\"text\" placeholder=\"Ex : 192.16.0.1, hostname\" required=\"\" ng-model=\"host.ip\" tabindex=\"2\"/>\n" +
    "                <button type=\"reset\" class=\"icon-remove\"></button>\n" +
    "            </p>\n" +
    "            <p class=\"span5\">\n" +
    "                <label>Api port</label>\n" +
    "                <input type=\"text\" placeholder=\"Ex : 9090\" required=\"\" ng-model=\"host.port\" tabindex=\"3\"/>\n" +
    "                <button type=\"reset\" class=\"icon-remove\"></button>\n" +
    "            </p>\n" +
    "        </div>\n" +
    "        <p>\n" +
    "            <label>Webserver port</label>\n" +
    "            <input type=\"text\" placeholder=\"Ex : 8080\" required=\"\" ng-model=\"host.httpPort\" tabindex=\"3\"/>\n" +
    "            <button type=\"reset\" class=\"icon-remove\"></button>\n" +
    "        </p>\n" +
    "        <p>\n" +
    "            <label>Webserver username</label>\n" +
    "            <input type=\"text\" placeholder=\"Ex : Kodi\" ng-model=\"host.username\" tabindex=\"4\"/>\n" +
    "            <button type=\"reset\" class=\"icon-remove\"></button>\n" +
    "        </p>\n" +
    "        <p>\n" +
    "            <label>Webserver password</label>\n" +
    "            <input type=\"password\" ng-model=\"host.password\" tabindex=\"5\"/>\n" +
    "            <button type=\"reset\" class=\"icon-remove\"></button>\n" +
    "        </p>\n" +
    "    </div>\n" +
    "    <div class=\"md-action md-action-danger\" ng-click=\"delete()\" ng-show=\"hosts.length > 1 && hostIndex !== null\">\n" +
    "        <i class=\"icon-trash\"></i>\n" +
    "    </div>\n" +
    "</form>");
}]);

angular.module("modules/tvshow/details.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("modules/tvshow/details.tpl.html",
    "<div ng-switch on=\"loading\" ng-class=\"{loading : loading}\">\n" +
    "    <div ng-switch-when=\"true\" class=\"loading\"><div class=\"foxy\"></div></div>\n" +
    "    <div ng-switch-when=\"false\" class=\"tvshow detail\">\n" +
    "        <div class=\"arts\">\n" +
    "            <div class=\"fanart\" image image-source=\"getFanart()\"></div>\n" +
    "            <div class=\"md-action md-action-primary\"\n" +
    "                 ng-click=\"play(episode)\" ng-show=\"!player.active\">\n" +
    "                <i class=\"icon-play\"></i>\n" +
    "            </div>\n" +
    "            <div class=\"md-action md-action-primary\"\n" +
    "                 ng-click=\"xbmc.queue({'episodeid': episode.episodeid})\" ng-show=\"player.active && !isCurrentlyPlaying\">\n" +
    "                <i class=\"icon-plus\"></i>\n" +
    "            </div>\n" +
    "            <div class=\"md-action md-action-primary\"\n" +
    "                 ng-click=\"xbmc.togglePlay()\" ng-show=\"player.active && isCurrentlyPlaying\">\n" +
    "                <i class=\"icon-play\" ng-show=\"!player.speed\"></i>\n" +
    "                <i class=\"icon-pause\" ng-show=\"player.speed\"></i>\n" +
    "            </div>\n" +
    "            <div class=\"poster-wrapper\">\n" +
    "                <img class=\" poster\" image image-source=\"getPoster()\"/>\n" +
    "            </div>\n" +
    "            <streamdetails details=\"episode.streamdetails\" ng-if=\"hasExtra()\"></streamdetails>\n" +
    "        </div>\n" +
    "        <h1>\n" +
    "            {{episode.title}}\n" +
    "        </h1>\n" +
    "        <div>\n" +
    "            <div class=\"row properties\" ng-if=\"hasExtra()\">\n" +
    "                <div class=\"span3\">\n" +
    "                    <div class=\"md-circle clock\">\n" +
    "                        <i>{{episode.runtime | time | date:'HH:mm'}}</i>\n" +
    "                    </div>\n" +
    "                </div>\n" +
    "                <div class=\"span3\">\n" +
    "                    <div rating rating-value=\"episode.rating\" rating-max=\"10\"></div>\n" +
    "                </div>\n" +
    "                <div class=\"span3\">\n" +
    "                    <div class=\"md-circle movie genre\">\n" +
    "                        <i class=\"genre-{{episode.genre.join(' genre-').toLowerCase()}}\"></i>\n" +
    "                    </div>\n" +
    "                </div>\n" +
    "                <div class=\"span3\">\n" +
    "                    <div class=\"md-circle cast\" image image-source=\"episode.cast[0].thumbnail | asset:host | fallback:'img/icons/foxy-512.png'\">\n" +
    "                    </div>\n" +
    "                </div>\n" +
    "            </div>\n" +
    "            \n" +
    "            <p class=\"plot\">{{episode.plot}}</p>\n" +
    "        </div>\n" +
    "    </div>\n" +
    "</div>\n" +
    "</div>\n" +
    "");
}]);

angular.module("modules/tvshow/episodes.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("modules/tvshow/episodes.tpl.html",
    "<div ng-switch on=\"loading\" ng-class=\"{loading : loading}\">\n" +
    "    <div ng-switch-when=\"true\" class=\"loading\"><div class=\"foxy\"></div></div>\n" +
    "    <div ng-switch-when=\"false\" class=\"tvshow\">\n" +
    "        <div class=\"arts\">\n" +
    "            <div class=\"banner\" image image-source=\"getFanart()\"></div>\n" +
    "            <div class=\"md-action md-action-primary\" ng-show=\"episodes.length\" \n" +
    "                 ng-click=\"queueAll()\" ng-if=\"hasControls()\">\n" +
    "                <i class=\"icon-plus\"></i>\n" +
    "            </div>\n" +
    "        </div>\n" +
    "        <ul data-type=\"list\" class=\"view\">\n" +
    "            <li class=\"row episode\" ng-repeat=\"episode in episodes\"\n" +
    "                ng-click=\"go(getEpisodePath(episode, $index))\">\n" +
    "                <div class=\"span3 flip-container\">\n" +
    "                    <flipper>\n" +
    "                        <div class=\"front\">\n" +
    "                            <div class=\"md-circle poster\" image image-source=\"getPoster(episode)\">\n" +
    "                                <em class=\"playcount\" ng-show=\"episode.playcount\">&#10003;</em>\n" +
    "                            </div>\n" +
    "                        </div>\n" +
    "                        <div class=\"back\" rating rating-value=\"episode.rating\" rating-max=\"10\"></div>\n" +
    "                    </div>\n" +
    "                </flipper>\n" +
    "                <div class=\"span8\">\n" +
    "                    <p>{{episode.title || episode.name}}</p>\n" +
    "                    <p>{{episode.episode | episode:episode.season}}</p>\n" +
    "                </div>\n" +
    "            </li>\n" +
    "        </ul>\n" +
    "        <div ng-show=\"!episodes.length\" class=\"empty list\">Oops! nothing here</div>\n" +
    "    </div>\n" +
    "\n" +
    "</div>\n" +
    "\n" +
    "\n" +
    "");
}]);

angular.module("modules/tvshow/list.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("modules/tvshow/list.tpl.html",
    "<div ng-switch on=\"loading\" ng-class=\"{loading : loading}\">\n" +
    "    <div ng-switch-when=\"true\" class=\"loading\"><div class=\"foxy\"></div></div>\n" +
    "    <div class=\"view tvshows\" ng-switch-when=\"false\">\n" +
    "        <div class=\"arts\">\n" +
    "            <div class=\"banner\" image image-source=\"getFanart(randomShow)\">\n" +
    "            </div>\n" +
    "            <div class=\"md-action md-action-primary\"\n" +
    "                 ng-click=\"scan()\" ng-if=\"hasControls()\">\n" +
    "                <i class=\"icon-refresh\"></i>\n" +
    "            </div>\n" +
    "        </div>\n" +
    "        <div class=\"spinner\" ng-show=\"scanning\">\n" +
    "            <div class=\"bar\"></div>\n" +
    "        </div>\n" +
    "        <ul data-type=\"list\" lr-infinite-scroll=\"loadMore\">\n" +
    "            <li class=\"tvshow row\" ng-repeat=\"show in tvshows\"\n" +
    "                ng-click=\"go(getEpisodesPath(show))\">\n" +
    "                <div class=\"span3 flip-container\">\n" +
    "                    <flipper>\n" +
    "                        <div class=\"front\">\n" +
    "                            <div class=\"md-circle poster front\" image image-source=\"getPoster(show)\">\n" +
    "                                <em class=\"playcount\" ng-show=\"show.playcount\">&#10003;</em>\n" +
    "                            </div>\n" +
    "                        </div>\n" +
    "                        <div class=\"back\" rating rating-value=\"show.rating\" rating-max=\"10\" ng-if=\"show.rating\"></div>\n" +
    "                    </flipper>\n" +
    "                </div>\n" +
    "                <div class=\"span8\">\n" +
    "                    <p>{{show.title || show.name}}</p>\n" +
    "                    <p ng-if=\"show.genre\">{{show.genre.join(', ')}}</p>\n" +
    "                    <p>{{getExtra(show)}}</p>\n" +
    "                </div>\n" +
    "            </li>\n" +
    "        </ul>\n" +
    "        <div ng-show=\"!tvshows.length\" class=\"empty list\">Oops! nothing here</div>\n" +
    "        <spinner ng-show=\"fetching\"></spinner>\n" +
    "    </div>\n" +
    "</div>\n" +
    "\n" +
    "\n" +
    "");
}]);

angular.module("modules/tvshow/seasons.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("modules/tvshow/seasons.tpl.html",
    "<div ng-switch on=\"loading\" ng-class=\"{loading : loading}\">\n" +
    "  <div ng-switch-when=\"true\" class=\"loading\"><div class=\"foxy\"></div></div>\n" +
    "  <div ng-switch-when=\"false\" class=\"seasons\">\n" +
    "    <div class=\"arts\">\n" +
    "        <div class=\"banner\" image image-source=\"getImage(seasons[0].fanart, 'img/backgrounds/banner.png')\">\n" +
    "        </div>\n" +
    "        <div class=\"md-action md-action-primary\"\n" +
    "             ng-click=\"scan()\" ng-if=\"hasControls()\">\n" +
    "        <i class=\"icon-refresh\"></i>\n" +
    "      </div>\n" +
    "    </div>\n" +
    "    <div class=\"spinner\" ng-show=\"updating\">\n" +
    "        <div class=\"bar\"></div>\n" +
    "    </div>\n" +
    "    <ul data-type=\"list\">\n" +
    "      <li class=\"row season\" ng-repeat=\"season in seasons | filter:library.criteria\"\n" +
    "          ng-click=\"go(getSeasonPath(season))\">\n" +
    "        <div class=\"span3 wrapper\">\n" +
    "          <div class=\"md-circle poster front\" image image-source=\"getPoster(season)\">\n" +
    "            <em class=\"playcount\" ng-show=\"show.playcount\">&#10003;</em>\n" +
    "          </div>\n" +
    "        </div>\n" +
    "        <div class=\"span8\">\n" +
    "          <p>{{season.showtitle}}</p>\n" +
    "          <p>{{season.label}}</p>\n" +
    "        </div>\n" +
    "      </li>\n" +
    "    </ul>\n" +
    "    <div ng-show=\"!seasons.length\" class=\"empty list\">Oops! nothing here</div>\n" +
    "  </div>\n" +
    "</div>\n" +
    "\n" +
    "");
}]);
