$(document).ready(function(){
	$("#submit").click(function(){
		var ip = "192.168.0.1";
		var input = $("#input").val();
		var regexp = /((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?))(\/(3[0-2]|[12][0-9]))?$/g;
		var match = regexp.exec(input);
		if(match == null){
			$("#input").css("border", "2px solid #b90000");
			alert("Neispravna IP adresa");
			return;
		}
		ip = match[1];
		var cidr = parseInt(match[7]);
		if(cidr != null && cidr <= 32 && cidr >= 0){
			$("#subnet_input").val(binary_to_ip(cidr_to_bin_subnet(cidr)));
		}else{
			cidr = 24;
			var regexp2 = /((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?))$/g;
			match = regexp2.exec($("#subnet_input").val());
			if(match == null){
				$("#input").css("border", "2px solid #b90000");
				$("#subnet_input").css("border", "2px solid #b90000");
				alert("Neispravna mrežna maska");
				return;
			}
			cidr = get_subnet_bits(ip_to_binary(match[1]));
			var tmp = $("#input").val();
			$("#input").val(tmp + "/" + cidr);
		}
		$("#input").css("border", "2px solid #8bb84a");
		$("#subnet_input").css("border", "2px solid #8bb84a");		
			

		var subnet_bin = cidr_to_bin_subnet(cidr);
		var subnet = binary_to_ip(subnet_bin); 

		$("#result").css('display', 'inherit');
		//$("#progress_cidr").val(cidr);
		print("ip", ip);
		print("cidr", cidr);
		print("subnet", binary_to_ip(subnet_bin));
		print("wildcard", binary_to_ip(calculate_wildcard(subnet_bin)));
		print("network", binary_to_ip(calculate_network(ip, subnet)));
		print("first_host", binary_to_ip(calculate_first_host(ip, subnet)));
		print("last_host", binary_to_ip(calculate_last_host(ip, subnet)));
		print("broadcast", binary_to_ip(calculate_broadcast(ip, subnet)));
		print("no_addresses", subnet_address_no(subnet_bin));
		print("bin_ip", html_binary(ip_to_binary(ip), cidr));
		print("bin_subnet", html_binary(subnet_bin, cidr));
		print("bin_network", html_binary(calculate_network(ip, subnet), cidr));
		
		if((tmp = special_address(ip, subnet)) != ""){
			$("#info_box").css("display", "block");
			$("#info_box").html(tmp);
		}else{
			$("#info_box").css("display", "none");
		}
	});
});

//----- conversions

function ip_to_binary (ip){
	var str = ip;
	var regexp = /(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)/g;
	var match = regexp.exec(str);
	var result = "";
	var tmp;
	for(var i = 1; i <=4; i++){
		tmp = (parseInt(match[i])).toString(2);
		result += padTextPrefix(tmp, "0", 8);
	}
	return result;
}

function binary_to_ip (binary){
	var str = padTextPrefix(binary, "0", 32);
	var regexp = /([01]{8})([01]{8})([01]{8})([01]{8})/g;
	var match = regexp.exec(str);
	return parseInt(match[1], 2) + "." + parseInt(match[2], 2) + "." + parseInt(match[3], 2) + "." + parseInt(match[4], 2);
}

function cidr_to_bin_subnet (cidr){
	var output = "";
	output += Array(cidr+1).join("1") + Array(33-cidr).join("0");
	return output;
}


function subnet_address_no (subnet_bin){
	var regexp = /1*(0*)/g;
	var match = regexp.exec(subnet_bin);
	var host_bits = match[1].length;
	return Math.pow(2,get_host_bits(subnet_bin))-2;
}

//----- calculations

function calculate_network (ip, subnet){
	var ipbin = ip_to_binary(ip);
	var subbin = ip_to_binary(subnet);
	return padTextPrefix(((parseInt(ipbin, 2) & parseInt(subbin, 2)) >>> 0).toString(2), "0", 32);
}

function calculate_wildcard(subnet){
	return padTextPrefix((~(parseInt(subnet, 2)) >>> 0).toString(2), "0", 32);
}

function calculate_broadcast(ip, subnet){
	var ip_bin = ip_to_binary(ip);
	var subnet_bin = ip_to_binary(subnet);
	var subnet_bits = get_subnet_bits(subnet_bin);
	var host_bits = get_host_bits(subnet_bin);
	return ip_bin.substring(0, subnet_bits) + Array(host_bits+1).join("1");
}

function calculate_first_host (ip, subnet){
	return calculate_network(ip, subnet).replace(/.$/, "1");
}

function calculate_last_host (ip, subnet){
	return calculate_broadcast(ip, subnet).replace(/.$/, "0");
}

function get_host_bits (subnet_binary){
	var regexp = /1*(0*)/g;
	var match = regexp.exec(subnet_binary);
	return  match[1].length;
}

function get_subnet_bits (subnet_binary){
	var regexp = /(1*)0*/g;
	var match = regexp.exec(subnet_binary);
	return  match[1].length;
}

//----- helpers

function special_address(ip){
	var array = [
		["0.0.0.0", 8, "0.0.0.0/8 - Addresses in this block refer to source hosts on \"this\" network. Address 0.0.0.0/32 may be used as a source address for this host on this network; other addresses within 0.0.0.0/8 may be used to refer to specified hosts on this network (RFC1122, Section 3.2.1.3)."],
		["10.0.0.0", 8, "10.0.0.0/8 - This block is set aside for use in private networks. Its intended use is documented in RFC1918. As described in that RFC, addresses within this block do not legitimately appear on the public Internet. These addresses can be used without any coordination with IANA or an Internet registry."],
		["127.0.0.0", 8, "127.0.0.0/8 - This block is assigned for use as the Internet host loopback address. A datagram sent by a higher-level protocol to an address anywhere within this block loops back inside the host. This is ordinarily implemented using only 127.0.0.1/32 for loopback. As described in RFC1122, Section 3.2.1.3, addresses within the entire 127.0.0.0/8 block do not legitimately appear on any network anywhere."],
		["169.254.0.0", 16, "169.254.0.0/16 - This is the \"link local\" block. As described in RFC3927, it is allocated for communication between hosts on a single link. Hosts obtain these addresses by auto-configuration, such as when a DHCP server cannot be found."],
		["172.16.0.0", 12, "172.16.0.0/12 - This block is set aside for use in private networks. Its intended use is documented in RFC1918. As described in that RFC, addresses within this block do not legitimately appear on the public Internet. These addresses can be used without any coordination with IANA or an Internet registry."],
		["192.0.0.0", 24, "192.0.0.0/24 - This block is reserved for IETF protocol assignments. At the time of writing this document, there are no current assignments. Allocation policy for future assignments is given in RFC5736."],
		["192.0.2.0", 24, "192.0.2.0/24 - This block is assigned as \"TEST-NET-1\" for use in documentation and example code. It is often used in conjunction with domain names example.com or example.net in vendor and protocol documentation. As described in RFC5737, addresses within this block do not legitimately appear on the public Internet and can be used without any coordination with IANA or an Internet registry. See RFC1166."],
		["192.88.99.0", 24, "192.88.99.0/24 - This block is allocated for use as 6to4 relay anycast addresses, in RFC3068. In contrast with previously described blocks, packets destined to addresses from this block do appear in the public Internet. RFC3068, Section 7, describes operational practices to prevent the malicious use of this block in routing protocols."],
		["192.168.0.0", 16, "192.168.0.0/16 - This block is set aside for use in private networks. Its intended use is documented in RFC1918. As described in that RFC, addresses within this block do not legitimately appear on the public Internet. These addresses can be used without any coordination with IANA or an Internet registry."],
		["198.18.0.0", 15, "198.18.0.0/15 - This block has been allocated for use in benchmark tests of network interconnect devices. RFC2544 explains that this range was assigned to minimize the chance of conflict in case a testing device were to be accidentally connected to part of the Internet. Packets with source addresses from this range are not meant to be forwarded across the Internet."],
		["198.51.100.0", 24, "198.51.100.0/24 - This block is assigned as \"TEST-NET-2\" for use in documentation and example code. It is often used in conjunction with domain names example.com or example.net in vendor and protocol documentation. As described in RFC5737, addresses within this block do not legitimately appear on the public Internet and can be used without any coordination with IANA or an Internet registry."],
		["203.0.113.0", 24, "203.0.113.0/24 - This block is assigned as \"TEST-NET-3\" for use in documentation and example code. It is often used in conjunction with domain names example.com or example.net in vendor and protocol documentation. As described in RFC5737, addresses within this block do not legitimately appear on the public Internet and can be used without any coordination with IANA or an Internet registry."],
		["224.0.0.0", 4, "224.0.0.0/4 - This block, formerly known as the Class D address space, is allocated for use in IPv4 multicast address assignments. The IANA guidelines for assignments from this space are described in RFC3171."],
		["240.0.0.0", 4, "240.0.0.0/4 - This block, formerly known as the Class E address space, is reserved for future use"]
	];
	for(var i = 0; i < array.length; i++){
		if(binary_to_ip(calculate_network(ip, binary_to_ip(cidr_to_bin_subnet(array[i][1])))) == array[i][0]){
			return array[i][2];
		}
	}
	return "";
}

function print(id, text){
	$('#' + id).html(text);
}

function html_binary (binary, cidr){
	var output = binary;
	return ["<span class='blue'>", output.slice(0, cidr), "</span><span class='red'>", output.slice(cidr), "</span>"].join('');
}

function padTextPrefix (InString, PadChar, DefLength)  {
	if (InString.length >= DefLength)
		return (InString);
	OutString = InString
	for (Count = InString.length; Count < DefLength; Count++)  {
		OutString = PadChar + OutString;
	}
	return (OutString);
}
