/**
 * Little Zoo
 *
 * written by Valéry Febvre
 * vfebvre@aester-eggs.com
 *
 * Copyright 2015 Valéry Febvre
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

var myApp;

var $$ = Dom7;

var photos = [];
var sounds = [];
var settings;
var sound;
var soundLock = false;

navigator.mozL10n.once(function() {
    var useImagesLazyLoad = true;
    if (navigator.userAgent.search('Mozilla') === 0) {
        var rev = /\((.*)\)/.exec(window.navigator.userAgent)[1].split(' ');
        rev = parseInt(rev[rev.length - 1].split(':')[1]);
        if (rev < 37) {
            useImagesLazyLoad = false;
        }
    }

    // load media info
    $$.getJSON('media_enhanced.json', function(data) {
        var i, j;
        var html;
        var index;
        var item;

        for(i=0; i<data.length/2; i++) {
            html = '<div class="card">';
            html += '<div class="card-content">';
            html += '<div class="row">';

            for(j=0; j<2; j++) {
                index = i * 2 + j;
                item = data[index];

                photos.push({
                    url: 'media/' + item.photo.filename,
                    caption: item.photo.description,
                    source: item.photo.source,
                    author: item.photo.author,
                    link: item.photo.url,
                    license: item.photo.license
                });
                html += '<div class="col-50">';
                if (useImagesLazyLoad) {
                    html += '<div data-index="' + index + '" data-background="media/' + item.photo.filename + '" class="card-photo lazy lazy-fadein"></div>';
                }
                else {
                    html += '<div data-index="' + index + '" style="background-image: url(media/' + item.photo.filename + ')" class="card-photo"></div>';
                }
                html += '<div class="card-content-inner uppercase">';
                html += navigator.mozL10n.get(item.name);
                html += '</div>';
                html += '</div>';
            }

            html += '</div>';
            html += '</div>';
            html += '</div>';
            
            $$('.view-main .page-content').append(html);

            for(j=0; j<2; j++) {
                item = data[i * 2 + j];
                sounds.push({
                    url: 'media/' + item.sound.filename,
                    source: item.sound.source,
                    author: item.sound.author,
                    link: item.sound.url,
                    license: item.sound.license
                });
            }
        }

        myApp = new Framework7({
            material: true
        });

        myApp.addView('.view-main', {
            domCache: true
        });
 
        // create photo browser
        var photoBrowser = myApp.photoBrowser({
            photos : photos,
            loop: true,
            zoom: true,
            exposition: false,
            swipeToClose: false,
            type: 'standalone',
            theme: 'dark',
            ofText: navigator.mozL10n.get('of')
        });

        var playSound = function(swiper) {
            if (soundLock) {
                return;
            }

            var index = swiper.activeIndex;
            if (index === 0) {
                index = sounds.length;
            }
            if (index > sounds.length) {
                index = 1;
            }

            sound = new buzz.sound(sounds[index - 1].url);
            sound.bind("ended", function(e) {
                soundLock = false;
                sound = null;
            });
            soundLock = true;
            sound.play();
        };

        var stopSound = function() {
            if (sound) {
                sound.stop();
                sound = null;
                soundLock = false;
            }
        };

        // add event on card to open photo browser when user click on an animal
        $$('.card-photo').on('click', function() {
            var index;

            settings = myApp.formGetData('settings');

            photoBrowser.open($$(this).data('index'));
            if (settings && settings.autoplay.length) {
                playSound(photoBrowser.swiper);
            }

            // hide animal description if defined in settings
            if (settings && settings.hide_description.length) {
                $$('.photo-browser-captions').hide();
            }

            photoBrowser.swiper.on('destroy', function(swiper) {
                stopSound();
            });

            photoBrowser.swiper.on('slideChangeStart', function(swiper) {
                stopSound();

                // auto play animal sound if defined in settings
                if (settings && settings.autoplay.length) {
                    playSound(swiper);
                }
            });

            photoBrowser.swiper.on('tap', function(swiper, event) {
                playSound(swiper);
            });
        });

        myApp.onPageInit('credits', function(page) {
            var html;

            $$.each(photos, function(i, photo) {
                var sound = sounds[i];
                html = '<li>';
                html += '<div class="item-content">';
                html += '<div class="item-media"><img src="' + photo.url + '" width="80"></div>';

                html += '<div class="item-inner">';
                html += '<div>';
                html += '<a href="javascript:void(0);" onclick="return openLink(\'' + photo.link + '\');" class="external">';
                html += '<div class="item-title color-white">' + navigator.mozL10n.get('photo') + '</div>';
                html += '<div class="item-subtitle">' + photo.author + '</div>';
                html += '<div class="item-text">' + photo.source + '</div>';
                html += '<div class="item-text">' + photo.license + '</div>';
                html += '</a>'; 
                html += '</div>';

                html += '<div style="padding-top: 8px">';
                html += '<a href="javascript:void(0);" onclick="return openLink(\'' + sound.link + '\');" class="external">';
                html += '<div class="item-title color-white">' + navigator.mozL10n.get('sound') + '</div>';
                html += '<div class="item-subtitle">' + sound.author + '</div>';
                html += '<div class="item-text">' + sound.source + '</div>';
                html += '<div class="item-text">' + sound.license + '</div>';
                html += '</a>'; 
                html += '</div>';
                html += '</div>';

                html += '</div>';
                html += '</li>';

                $$(page.container).find('#media-list ul').append(html);
            });
        });
    });
});

function openLink(url) {
    window.open(url, '_blank', 'location=yes');
    return false;
}
