$(document).ready(function() {
    L.mapbox.accessToken = 'pk.eyJ1IjoiY29temVyYWRkIiwiYSI6ImxjQjFHNFUifQ.ohrYy34a8ZIZejrPSMWIww';
    var map = L.mapbox.map('map', 'comzeradd.oada03j8')
        .setView([47, 11], 4);

    var myLoc = L.mapbox.featureLayer().addTo(map);

    var share = $('#share');
    var refresh = $('#refresh');
    var status = $('#status');
    var statustext = $('#status > p');
    var point;

    if (!navigator.geolocation) {
        $(statustext).text('Geolocation is not available');
        $(status).fadeIn('slow').delay(1000).fadeOut('slow');
    } else {
        $(statustext).text('Locating...');
        $(status).fadeIn('slow');

        map.locate();

        refresh.click(function (e) {
            e.preventDefault();
            e.stopPropagation();
            map.locate();
        });
    }

    map.on('locationfound', function(e) {
        map.fitBounds(e.bounds);
        point = e;

        myLoc.setGeoJSON({
            type: 'Feature',
            geometry: {
                type: 'Point',
                coordinates: [e.latlng.lng, e.latlng.lat]
            },
            properties: {
                'marker-color': '#0090CE',
                'marker-symbol': 'circle',
                'marker-size': 'large'
            }
        });

        status.hide();
        refresh.show();
        share.fadeIn();
    });

    map.on('locationerror', function() {
        $(statustext).text('Location could not be found');
        $(status).fadeIn('slow').delay(2000).fadeOut('slow');
    });

    function share_location(e) {
        var url = 'https://www.openstreetmap.org/?mlat=' + e.latlng.lat + '&mlon=' + e.latlng.lng;
        /* TODO: share for other platforms
        if (window.MozActivity) { */
        var activity = new MozActivity({
            name: 'share',
            data: {
                type: 'url',
                url: url
            }
        });
    }

    myLoc.on('click', function(e) {
        share_location(e);
    });

    share.click(function () {
        share_location(point);
    });
});
