var camera = new Object();
var timerID = 0;
var clickEvent = ('ontouchstart' in window ? 'touchend' : 'click');

function draw(picture){
	var binary = "";
	var length = picture.length;
	for (var i = 0 ; i < length ; i++) {
		binary += String.fromCharCode(picture.charCodeAt(i) & 255);
	}
	var image = new Image();
	image.onload = function(){
		document.querySelector("#status_text").textContent = document.webL10n.get("connectionEstablished");
		document.querySelector("#status_icon").className = 'green';
		if(window.screen.width<=image.width){
			var width=window.screen.width;
			var height=parseInt((parseInt(image.height)*parseInt(window.screen.width))/parseInt(image.width));
			document.querySelector("#stream_container").innerHTML='<canvas id="stream_cam" height="'+height+'" width="'+width+'"></canvas>';
			var canvas = document.querySelector('#stream_cam');
			canvas.getContext('2d').drawImage(image, 0, 0, width, height);
		}
		else{
			var width=image.width;
			var height=image.height;
			document.querySelector("#stream_container").innerHTML='<canvas id="stream_cam" height="'+height+'" width="'+width+'"></canvas>';
			var canvas = document.querySelector('#stream_cam');
			canvas.getContext('2d').drawImage(image, 0, 0, width, height);
		}
		timerID=setTimeout(getImg,camera.refresh*1000);
	}
	image.src = 'data:image/jpeg;base64,' + btoa(binary);
}

function getImg(){
	request = new XMLHttpRequest({ mozSystem: true });
	if(camera.login != "" || camera.password != ""){
		request.open('GET', camera.video_address, true, camera.login, camera.password);
	}
	else{
		request.open('GET', camera.video_address, true);
	}
	request.overrideMimeType('text/plain; charset=x-user-defined');
	request.onreadystatechange = function(){
		if(request.readyState == 3 && request.status == 200){
			if(request.getResponseHeader('Content-type').indexOf('multipart/x-mixed-replace') != -1){
				var boundaryIndex = request.getResponseHeader('Content-type').indexOf("boundary=");
				var boundary = request.getResponseHeader('Content-type').substr(boundaryIndex+9);
				var count = request.responseText.split(boundary).length-1;
				if(count==2){
					var data = request.responseText;
					request.abort();
					data = data.substr(boundary.length+2);
					var frame = data.substring(0,data.lastIndexOf(boundary)-2);
					var nb = 0;
					var index = 0;
					while(nb!=3){
						if(frame.substr(index,1)=="\n"){
							nb=nb+1;
						}
						index=index+1;
					}
					var picture = frame.substr(index);
					draw(picture);
				}
			}
			else if(request.getResponseHeader('Content-type').indexOf('image/jpeg') != -1){
				var frame = request.responseText;
				draw(frame);
			}
			else{
				request.onerror();
			}
		}
		else if(request.readyState == 4 && request.status == 401){
			clearTimeout(timerID);
			document.querySelector("#status_text").textContent = document.webL10n.get("connectionFailedCredentials");
			document.querySelector("#status_icon").className = 'red';
		}
	};
	request.onerror = function(){
		document.querySelector('#fullscreen').setAttribute('disabled','disabled');
		document.querySelector('#snapshot').setAttribute('disabled','disabled');
		document.querySelector('#fullscreen').addEventListener(clickEvent,function(){return 0;});
		clearTimeout(timerID);
		if(document.querySelectorAll("#stream_container>canvas").length>0){
			//If there is already a canvas element, we substitute it with the mire image,
			//there is no need to react when there is no canvas, since the mire is already there
			document.querySelector("#stream_container").innerHTML = '<img width="320" height="240" id="mire" src="Images/mire.png"/>';
		}
		document.querySelector("#status_text").textContent = document.webL10n.get("connectionFailed");
		document.querySelector("#status_icon").className = 'red';
	}
	request.send(null);
}

function takeSnapshot(){
	//Let's take a snapshot and save it in the pictures directory
	var directory = navigator.getDeviceStorage("pictures");
	document.querySelector('#stream_cam').toBlob(function(blob){
		var date = new Date();
		var result = directory.addNamed(blob, camera.name+'-'+date.getDate()+date.getMonth()+date.getFullYear()+'-'+date.getHours()+date.getMinutes()+date.getSeconds()+'.png');
		result.onsuccess = function(){alert("Picture Saved !")};
	});
}

window.addEventListener('load',function(){
	var id = parseInt((window.location.hash).replace('#',''));
	if(navigator.userAgent.toLowerCase().indexOf('android')>-1){
		document.querySelector('#snapshot').disabled=true;
	}
	else{
		document.querySelector('#snapshot').addEventListener(clickEvent,takeSnapshot);
	}
	document.querySelector('form').action = 'fullscreen.html#'+id;
	var camera = getCamera(id);
	try{
		if(camera!=undefined){
			document.querySelector('header>h1').textContent=camera.name;
		}
		else{
			throw new Error('Unknown camera !');
		}
	}
	catch(e){
		alert(e);
		return false;
	}
	getImg();
}, false);