/*! Mines - v1.2.2 - 2015-11-06
 * Copyright (c) 2015 Martin Giger;
 * This Source Code Form is subject to the terms of the Mozilla Public License,
 * v. 2.0. If a copy of the MPL was not distributed with this file, You can
 * obtain one at https://mozilla.org/MPL/2.0/.
 */
function getClassForContent(a){switch(a){case Mines.MINE_1:return"one";case Mines.MINE_2:return"two";case Mines.MINE_3:return"three";case Mines.MINE_4:return"four";case Mines.MINE_5:return"five";case Mines.MINE_6:return"six";case Mines.MINE_7:return"seven";case Mines.MINE_8:return"eight";case Mines.MINE:return"mine";default:return"air"}}function Mines(a,b,c){this.dimensions=b||[8,8],this.mineCount=c||10,this.context=a;for(var d=[],e=[],f=0;f<b[1];++f){d.push([]),e.push([]);for(var g=0;g<b[0];++g)d[f].push(Mines.AIR),e[f].push(Mines.MINE_UNKNOWN)}this.board=d,this.markedMines=e,this.printEmptyBoard(),this.context.parentNode.removeAttribute("aria-busy");var h=this;this.context.addEventListener("keydown",function(a){"r"==a.key||82==a.keyCode?h.reset():("CapsLock"==a.key||20==a.keyCode)&&h.toggleMode()},!1),Mines.hasSavedState()&&Mines.removeSavedState()}function getRandomInt(a,b){return Math.floor(Math.random()*(b-a))+a}function BoolPreference(a,b){this.title=a,this.defaultValue=b,null===localStorage.getItem(this.title)&&(this.value=this.defaultValue)}function NumberPreference(a,b){this.title=a,this.defaultValue=b,null===localStorage.getItem(this.title)&&(this.value=this.defaultValue)}function getPreference(a){var b=Defaults[a];switch(b.type){case"bool":return new BoolPreference(a,b.value);default:return new NumberPreference(a,b.value)}}function StringBundle(a){if(this.container=a,this.container.setAttribute("hidden",!0),!("mozL10n"in navigator))throw"mozL10n global not initialized."}function Timer(a,b){this.offset=a,this.output=b;var c="0.0";"Intl"in window&&(this._nf=new Intl.NumberFormat(void 0,{maximumFractionDigits:1,minimumFractionDigits:1}),c=this._nf.format(0)),navigator.mozL10n.setAttributes(this.output,TIME_UNIT_STRING,{time:c}),navigator.mozL10n.translateFragment(this.output)}var Highscores={VERSION:2,TABLE:"scores",db:null,ready:!1,init:function(){var a=window.indexedDB.open("highscores",this.VERSION);a.onupgradeneeded=this.setupDB.bind(this),a.onsuccess=function(a){this.db=a.target.result,this.setReady()}.bind(this),a.onerror=function(b){console.error(a.error)}},setupDB:function(a){this.db=a.target.result;var b=this,c=[],d=function(){var a=b.db.createObjectStore(b.TABLE,{keyPath:["score","game"]});a.createIndex("game","game",{unique:!1}),c.length&&c.forEach(function(b){a.add(b)}),b.setReady()};if(a.oldVersion>0){var e=a.target.transaction.objectStore(this.TABLE),f=e.openCursor();f.onsuccess=function(a){var e=a.target.result;e?(c.push(e.value),e["continue"]()):(b.db.deleteObjectStore(b.TABLE),d())}}else d()},setReady:function(){this.ready=!0,document.dispatchEvent(new Event("dbready"))},clear:function(){var a=this.db.transaction(this.TABLE,"readwrite"),b=a.objectStore(this.TABLE);b.clear()},isNewTop:function(a,b,c){this.getTop(a,1,function(a){c(!a.length||b<a[0].score)})},save:function(a,b,c){var d=this.db.transaction(this.TABLE,"readwrite"),e=d.objectStore(this.TABLE),f={game:a,score:b,name:c};e.add(f)},getTop:function(a,b,c){var d=this.db.transaction(this.TABLE,"readonly"),e=d.objectStore(this.TABLE),f=e.index("game").openCursor(a),g=[];f.onsuccess=function(a){var d,e=a.target.result;e?(d=e.value,d.score=parseFloat(d.score),g.push(d),e["continue"]()):c&&c(g.sort(function(a,b){return a.score-b.score}).slice(0,b))}},getGames:function(a){var b=this.db.transaction(this.TABLE,"readonly"),c=b.objectStore(this.TABLE),d=c.index("game").openKeyCursor(),e=[];d.onsuccess=function(b){var c=b.target.result;c?(-1==e.indexOf(c.key)&&e.push(c.key),c["continue"]()):a&&a(e)}}};Highscores.init(),Mines.AIR=0,Mines.MINE_1=1,Mines.MINE_2=2,Mines.MINE_3=3,Mines.MINE_4=4,Mines.MINE_5=5,Mines.MINE_6=6,Mines.MINE_7=7,Mines.MINE_8=8,Mines.MINE=9,Mines.MODE_UNCOVER=!1,Mines.MODE_FLAG=!0,Mines.MINE_UNKNOWN=0,Mines.MINE_FLAG=1,Mines.MINE_KNOWN=2,Mines.defaultBoards={beginner:{size:[8,8],mines:10},advanced:{size:[16,16],mines:40},expert:{size:[30,16],mines:99}};const COVERED_CLASS="covered",FLAGGED_CLASS="flagged",FLASH_CLASS="invalid";Mines.prototype.dimensions=[],Mines.prototype.mineCount=0,Mines.prototype.context=null,Mines.prototype.board=[],Mines.prototype.markedMines=[],Mines.prototype.boardGenerated=!1,Mines.prototype.done=!1,Mines.prototype.mode=Mines.MODE_UNCOVER,Mines.prototype.size=1,Mines.prototype.setSize=function(a){this.size=a,this.context.style.fontSize=a+"em"},Mines.prototype.gameOver=function(){this.context.classList.add("gameover"),this.context.classList.add("done"),this.context.setAttribute("aria-readonly","true"),this.done=!0,Mines.hasSavedState()&&Mines.removeSavedState(),this.context.dispatchEvent(new Event("loose"))},Mines.prototype.win=function(){this.context.classList.add("done"),this.context.setAttribute("aria-readonly","true"),this.done=!0,Mines.hasSavedState()&&Mines.removeSavedState(),this.context.dispatchEvent(new Event("win"))},Mines.prototype.reset=function(){for(var a=[],b=[],c=0;c<this.dimensions[1];++c){a.push([]),b.push([]);for(var d=0;d<this.dimensions[0];++d)a[c].push(Mines.AIR),b[c].push(Mines.MINE_UNKNOWN)}this.board=a,this.markedMines=b,this.boardGenerated=!1,this.done=!1,this.printEmptyBoard(),this.mode=Mines.MODE_UNCOVER,this.context.classList.remove("done"),this.context.classList.remove("gameover"),this.context.setAttribute("aria-readonly","false"),Mines.hasSavedState()&&Mines.removeSavedState(),this.context.dispatchEvent(new Event("reset"))},Mines.prototype.toggleMode=function(){this.mode==Mines.MODE_UNCOVER?this.mode=Mines.MODE_FLAG:this.mode=Mines.MODE_UNCOVER,this.context.dispatchEvent(new Event("modetoggle"))},Mines.prototype.generate=function(a){for(var b,c,d=this.mineCount;d>0;)b=getRandomInt(0,this.dimensions[0]),c=getRandomInt(0,this.dimensions[1]),this.board[c][b]==Mines.MINE||b==a[0]&&c==a[1]||(this.addMine(b,c),--d);this.boardGenerated=!0,this.printBoard(),this.context.dispatchEvent(new Event("generated"))},Mines.prototype.addMine=function(a,b){this.board[b][a]=Mines.MINE;var c=a>0,d=a<this.dimensions[0]-1;b>0&&(this.addNeighbouringMine(a,b-1),c&&this.addNeighbouringMine(a-1,b-1),d&&this.addNeighbouringMine(a+1,b-1)),b<this.dimensions[1]-1&&(this.addNeighbouringMine(a,b+1),c&&this.addNeighbouringMine(a-1,b+1),d&&this.addNeighbouringMine(a+1,b+1)),c&&this.addNeighbouringMine(a-1,b),d&&this.addNeighbouringMine(a+1,b)},Mines.prototype.addNeighbouringMine=function(a,b){this.board[b][a]!==Mines.MINE&&++this.board[b][a]},Mines.prototype.countFlags=function(){return this.boardGenerated?this.markedMines.reduce(function(a,b,c){return b.reduce(function(a,b,c){return Mines.MINE_FLAG===b?a+1:a},a)},0):0},Mines.prototype.nonMinesCovered=function(){if(!this.boardGenerated)return!0;var a=0;return this.markedMines.reduce(function(a,b,c){return a.concat(b)},[]).some(function(b){return Mines.MINE_KNOWN===b?!1:(++a,a>this.mineCount)},this)},Mines.prototype.getCell=function(a,b){return a>=0&&b>=0&&a<this.dimensions[0]&&b<this.dimensions[1]?this.context.rows[b].cells[a]:null},Mines.prototype.uncoverCell=function(a,b){if(this.markedMines[b][a]===Mines.MINE_UNKNOWN&&!this.done){this.boardGenerated||this.generate([a,b]);var c=this.getCell(a,b);if(c.classList.remove(COVERED_CLASS),c.setAttribute("aria-pressed","true"),this.markedMines[b][a]=Mines.MINE_KNOWN,Mines.MINE===this.board[b][a])this.gameOver();else if(this.nonMinesCovered()){if(this.cellFullyMarked(a,b)){var d=a>0,e=a<this.dimensions[0]-1;b>0&&(this.uncoverCell(a,b-1),d&&this.uncoverCell(a-1,b-1),e&&this.uncoverCell(a+1,b-1)),b<this.dimensions[1]-1&&(this.uncoverCell(a,b+1),d&&this.uncoverCell(a-1,b+1),e&&this.uncoverCell(a+1,b+1)),d&&this.uncoverCell(a-1,b),e&&this.uncoverCell(a+1,b)}}else this.win()}},Mines.prototype.flagCell=function(a,b){var c=this.getCell(a,b);Mines.MINE_FLAG===this.markedMines[b][a]?(this.markedMines[b][a]=Mines.MINE_UNKNOWN,c.classList.remove(FLAGGED_CLASS),c.setAttribute("aria-pressed","false"),this.context.dispatchEvent(new Event("unflagged"))):(this.markedMines[b][a]=Mines.MINE_FLAG,c.classList.add(FLAGGED_CLASS),c.setAttribute("aria-pressed","mixed"),this.context.dispatchEvent(new Event("flagged")))},Mines.prototype.uncoverCompleteCells=function(a,b){if(this.cellFullyMarked(a,b)){var c=a>0,d=a<this.dimensions[0]-1;b>0&&(this.uncoverCell(a,b-1),c&&this.uncoverCell(a-1,b-1),d&&this.uncoverCell(a+1,b-1)),b<this.dimensions[1]-1&&(this.uncoverCell(a,b+1),c&&this.uncoverCell(a-1,b+1),d&&this.uncoverCell(a+1,b+1)),c&&this.uncoverCell(a-1,b),d&&this.uncoverCell(a+1,b)}else this.getCell(a,b).classList.add(FLASH_CLASS)},Mines.prototype.cellIsFlagged=function(a,b){return this.markedMines[b][a]==Mines.MINE_FLAG?1:0},Mines.prototype.cellFullyMarked=function(a,b){if(Mines.MINE==this.board[b][a])return!1;if(Mines.AIR==this.board[b][a])return!0;var c=0,d=a>0,e=a<this.dimensions[0]-1;return b>0&&(c+=this.cellIsFlagged(a,b-1),d&&(c+=this.cellIsFlagged(a-1,b-1)),e&&(c+=this.cellIsFlagged(a+1,b-1))),b<this.dimensions[1]-1&&(c+=this.cellIsFlagged(a,b+1),d&&(c+=this.cellIsFlagged(a-1,b+1)),e&&(c+=this.cellIsFlagged(a+1,b+1))),d&&(c+=this.cellIsFlagged(a-1,b)),e&&(c+=this.cellIsFlagged(a+1,b)),c==this.board[b][a]},Mines.prototype.createCell=function(a,b){var c=document.createElement("td");c.classList.add(COVERED_CLASS),c.setAttribute("aria-pressed","false"),c.setAttribute("role","gridcell"),c.setAttribute("tabindex",0);var d=this;return c.addEventListener("click",function(c){c.preventDefault(),d.done||(d.markedMines[b][a]!==Mines.MINE_KNOWN?Mines.MODE_UNCOVER===d.mode&&2!=c.button?d.uncoverCell(a,b):d.flagCell(a,b):d.uncoverCompleteCells(a,b))},!1),c.addEventListener("contextmenu",function(c){c.preventDefault(),d.done||d.markedMines[b][a]===Mines.MINE_KNOWN||d.flagCell(a,b)},!1),c.addEventListener("keydown",function(e){"ArrowUp"==e.key||"PageUp"==e.key||38==e.keyCode||33==e.keyCode?(b>0&&d.getCell(a,b-1).focus(),e.preventDefault(),c.scrollIntoView()):"ArrowDown"==e.key||"PageDown"==e.key||40==e.keyCode||34==e.keyCode?(b<d.dimensions[1]-1&&d.getCell(a,b+1).focus(),e.preventDefault(),c.scrollIntoView()):"ArrowLeft"==e.key||37==e.keyCode?(a>0&&d.getCell(a-1,b).focus(),e.preventDefault(),c.scrollIntoView()):"ArrowRight"==e.key||39==e.keyCode?(a<d.dimensions[0]-1&&d.getCell(a+1,b).focus(),e.preventDefault(),c.scrollIntoView()):"Home"==e.key||36==e.keyCode?d.getCell(0,0).focus():"End"==e.key||35==e.keyCode?d.getCell(d.dimensions[0]-1,d.dimensions[1]-1).focus():" "==e.key||32==e.keyCode?c.click():d.done||d.markedMines[b][a]!==Mines.MINE_KNOWN&&("f"==e.key||70==e.keyCode)&&(e.preventDefault(),d.flagCell(a,b))},!1),c.addEventListener("transitionend",function(a){c.classList.remove(FLASH_CLASS)},!1),c},Mines.prototype.createRow=function(a){for(var b=document.createElement("tr"),c=0;c<this.dimensions[0];++c)b.appendChild(this.createCell(c,a));return b},Mines.prototype.generateBoard=function(){for(var a=0;a<this.dimensions[1];++a)this.context.appendChild(this.createRow(a))},Mines.prototype.printEmptyBoard=function(){if(this.context.childElementCount){var a,b;if(this.context.childElementCount>this.dimensions[1]){var c=this.context.childElementCount-this.dimensions[1];a=this.context.childElementCount-1;for(var d=0;c>d;++d)this.context.removeChild(this.context.rows[a-d])}for(var e=0;e<this.context.childElementCount;++e){if(b=this.context.rows[e],a=b.childElementCount,a>this.dimensions[0]){for(var f=a-this.dimensions[0],g=0;f>g;++g)b.removeChild(b.cells[a-g]);a=b.childElementCount}for(var h=0;a>h;++h)b.cells[h].textContent="",b.cells[h].className=COVERED_CLASS;if(a<this.dimensions[0])for(var i=this.dimensions[0]-a,j=0;i>j;++j)b.appendChild(this.createCell(a+j,e))}if(this.context.childElementCount<this.dimensions[1]){var k=this.dimensions[1]-this.context.childElementCount;a=this.context.childElementCount;for(var l=0;k>l;++l)this.context.appendChild(this.createRow(a+l))}}else this.generateBoard()},Mines.prototype.printBoard=function(){if(this.context)if(this.boardGenerated)for(var a,b,c=0;c<this.dimensions[1];++c){a=this.context.rows[c];for(var d=0;d<this.dimensions[0];++d)b=a.cells[d],b.textContent=this.board[c][d],b.classList.add(getClassForContent(this.board[c][d]))}else this.printEmptyBoard()},Mines.prototype.restoreBoard=function(){this.printBoard();for(var a,b,c,d=0;d<this.dimensions[1];++d){a=this.context.rows[d];for(var e=0;e<this.dimensions[0];++e)b=a.cells[e],c=this.markedMines[d][e],Mines.MINE_KNOWN===c?b.classList.remove(COVERED_CLASS):Mines.MINE_FLAG===c&&b.classList.add(FLAGGED_CLASS)}},Mines.hasSavedState=function(){return"true"==localStorage.getItem("savedGame")},Mines.removeSavedState=function(){localStorage.setItem("savedGame","false"),localStorage.setItem("gameSettings","")},Mines.prototype.saveState=function(){var a=this,b={mineCount:a.mineCount,board:a.board,markedMines:a.markedMines,mode:a.mode};localStorage.setItem("gameSettings",JSON.stringify(b)),localStorage.setItem("savedGame","true")},Mines.restoreSavedState=function(a){if(Mines.hasSavedState()){var b=JSON.parse(localStorage.getItem("gameSettings")),c=new Mines(a,[b.board[0].length,b.board.length],b.mineCount);return c.board=b.board,c.markedMines=b.markedMines,c.boardGenerated=!0,b.mode==Mines.MODE_FLAG&&c.toggleMode(),c.restoreBoard(),c}},BoolPreference.TRUE="enabled",BoolPreference.FALSE="disabled",BoolPreference.prototype={type:"bool",title:"",defaultValue:!1,get value(){return localStorage.getItem(this.title)===BoolPreference.TRUE},set value(a){localStorage.setItem(this.title,a?BoolPreference.TRUE:BoolPreference.FALSE)},reset:function(){this.value=this.defaultValue}},NumberPreference.prototype={type:"number",title:"",defaultValue:0,get value(){return parseFloat(localStorage.getItem(this.title),10)},set value(a){var b=parseFloat(a,10);"number"!=typeof b||isNaN(b)||localStorage.setItem(this.title,a)},reset:function(){this.value=this.defaultValue}};var Defaults={autotoggle:{type:"bool",value:!1},fieldsize:{type:"number",value:1},vibration:{type:"bool",value:"vibrate"in navigator}},Preferences={};for(var name in Defaults)Preferences[name]=getPreference(name);Object.defineProperty(Preferences,"reset",{value:function(){for(var a in Preferences)Preferences[a].reset()}}),StringBundle.prototype.container=null,StringBundle.prototype.getStringContainer=function(a){return this.container.querySelector("[data-l10n-id='"+a+"']")},StringBundle.prototype.getString=function(a){var b=this.getStringContainer(a);return b.textContent},StringBundle.prototype.getStringAsync=function(a,b){var c=this.getStringContainer(a),d=new Promise(function(d,e){navigator.mozL10n.once(function(){d(c.textContent)}),navigator.mozL10n.setAttributes(c,a,b),navigator.mozL10n.translateFragment(c)});return d};var TIME_UNIT_STRING="mines_time_unit";Timer.prototype.output=null,Timer.prototype.startTime=0,Timer.prototype.offset=0,Timer.prototype.interval=0,Timer.prototype.running=!1,Timer.prototype.updateOutput=function(a){"number"!=typeof a&&(a=Date.now()-this.startTime);var b;b=this._nf?this._nf.format(a/1e3):(a/1e3).toFixed(1),navigator.mozL10n.setAttributes(this.output,TIME_UNIT_STRING,{time:b}),navigator.mozL10n.translateFragment(this.output)},Timer.prototype.reset=function(){this.startTime=0,this.offset=0,this.updateOutput(0),this.running=!1,this.interval&&(clearInterval(this.interval),this.interval=0),this.output.dispatchEvent(new Event("reset"))},Timer.prototype.getTime=function(){return this.running?Date.now()-this.startTime:this.offset},Timer.prototype.start=function(){if(!this.running&&(this.startTime=Date.now()-this.offset,this.running=!0,this.output)){var a=this;this.interval=setInterval(function(){a.updateOutput()},100),this.output.dispatchEvent(new Event("start"))}},Timer.prototype.pause=function(){this.running&&(this.offset=Date.now()-this.startTime,this.running=!1,this.interval&&(clearInterval(this.interval),this.interval=0,this.updateOutput(this.offset),this.output.dispatchEvent(new CustomEvent("pause",{detail:this.offset}))))},Timer.prototype.stop=function(){if(this.running){var a=Date.now()-this.startTime;return this.running=!1,this.interval&&(clearInterval(this.interval),this.interval=0,this.output.dispatchEvent(new CustomEvent("stop",{detail:a}))),this.reset(),a}};