navigator.getUserMedia = navigator.getUserMedia || navigator.mozGetUserMedia || navigator.webkitGetUserMedia;
window.URL = window.URL || window.mozURL;

if (!navigator.getUserMedia || !MediaRecorder) {
    alert("Your device is not supported. At least Firefox OS 1.4 or later version is required to run this app.");
}

var record_button = document.querySelector('#record');
var pause_button = document.querySelector('#pause');
var stop_button = document.querySelector('#stop');
var play_button = document.querySelector('#play');
var pause_playback_button = document.querySelector('#playback-pause');
var stop_playback_button = document.querySelector('#playback-stop');
var save_button = document.querySelector('#save-link');
var reload_button = document.querySelector('#reload');

var setPlaystate = function(t) {
    document.getElementById('playstate').textContent = t;
};

var buttons = [record_button, pause_button, stop_button, play_button, pause_playback_button, stop_playback_button, save_button, reload_button];

var show = function(el) {
    el.classList.remove('invisible');
};

var hide = function(el) {
    el.classList.add('invisible');
};

var activate = function(el) {
    el.classList.remove('inactive');
};

var deactivate = function(el) {
    el.classList.add('inactive');
};

var hideAll = function() {
    for (var i = buttons.length - 1; i >= 0; i--) {
        hide(buttons[i]);
    };
};

var deactivateAll = function() {
    for (var i = buttons.length - 1; i >= 0; i--) {
        deactivate(buttons[i]);
    };
};

reload_button.addEventListener('click', function () {
    location.reload(); // very dirty hack
});

document.addEventListener('DOMContentLoaded', function() {
    screen.mozLockOrientation('portrait');
    init();
});

function init() {
    if (navigator.getUserMedia) {
        var constraints = { audio: true };

        var onsuccess = function (stream) {
            var mediaRecorder = new MediaRecorder(stream);

            record_button.addEventListener('click', function () {
                if (mediaRecorder.state == 'paused') {
                    mediaRecorder.resume();
                } else {
                    mediaRecorder.start();
                }
                hideAll();
                deactivateAll();
                show(play_button);
                show(pause_button);
                show(stop_button);
                activate(pause_button);
                activate(stop_button);
                start_counter();
                setPlaystate('recording');

            });

            pause_button.addEventListener('click', function () {
                mediaRecorder.pause();

                hideAll();
                deactivateAll();
                show(play_button);
                show(record_button);
                show(stop_button);
                activate(record_button);
                activate(stop_button);
                stop_counter();
                setPlaystate('paused');
            });

            stop_button.addEventListener('click', function () {
                if (mediaRecorder.state != 'inactive') {
                    mediaRecorder.stop();
                }
                hideAll();
                deactivateAll();
                show(play_button);
                show(reload_button);
                show(save_button);
//            activate(play_button);
                activate(reload_button);
                activate(save_button);
                stream.stop();
                stop_counter();
                setPlaystate('finished');
            });

            play_button.addEventListener('click', function () {
                document.getElementById('audio-player').play();
                hideAll();
                deactivateAll();
                show(pause_playback_button);
                show(reload_button);
                show(stop_playback_button);
                activate(pause_playback_button);
                activate(stop_playback_button);
                reset_counter();
                start_counter();
                setPlaystate('playing');
            });

            pause_playback_button.addEventListener('click', function () {
                document.getElementById('audio-player').pause();
                hideAll();
                deactivateAll();
                show(play_button);
                show(record_button);
                show(stop_playback_button);
                activate(play_button);
                activate(stop_button);
                stop_counter();
                setPlaystate('paused');
            });



            stop_playback_button.addEventListener('click', function () {
                document.getElementById('audio-player').stop();
                hideAll();
                deactivateAll();
                show(play_button);
                show(record_button);
                show(save_button);
//            activate(play_button);
                activate(record_button);
                activate(save_button);
                stop_counter();
                setPlaystate('finished');
            });


            mediaRecorder.addEventListener('dataavailable', function (response) {
                var audioURL = window.URL.createObjectURL(response.data);
                var audio = document.createElement('audio');

                if (document.querySelector('#audio-player')) {
                    document.removeChild(document.querySelector('#audio-player'));
                }

                document.querySelector('#play').classList.remove('inactive');
                audio.classList.add('invisible');
                audio.src = audioURL;
                audio.id = 'audio-player';
                document.querySelector('body').appendChild(audio);

                var link = document.getElementById('save-link');
                link.href = audioURL;
                link.download = 'NewRecording.ogg';

                document.getElementById('audio-player').addEventListener('ended', function () {
                    hideAll();
                    deactivateAll();
                    show(play_button);
                    show(reload_button);
                    show(save_button);
                    activate(play_button);
                    activate(reload_button);
                    activate(save_button);
                    stop_counter();
                    setPlaystate('finished');
                });


            })
        };
        var onerror = function (error) {
            console.log(error);
        };
        navigator.getUserMedia(constraints, onsuccess, onerror);
    }
}